-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_MONITOR_PARAMETER (
    ID                             bigint NOT NULL
    , VALUE                          lvarchar(256)       NULL
    , OM_ID                          bigint          NOT NULL
    , WTP_ID                         bigint          NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_OBJECT_MONITOR_PARAMETER
ON OBJECT_MONITOR_PARAMETER(ID);
CREATE VIEW SCI_OBJECT_MONITOR_PARAMETER (ID,VALUE,OM_ID,WTP_ID,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , VALUE                          AS VALUE
    , OM_ID                          AS OM_ID
    , WTP_ID                         AS WTP_ID
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM OBJECT_MONITOR_PARAMETER;
