-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [RESOURCE_TRACE] (
    [R_ID]                         decimal (38)    NOT NULL
    , [TAG]                          varchar(64)         NULL
    , [TRACE_INTERVAL]               integer             NULL
    , [TRACE_BASE]                   integer             NULL
    , [TRACE_BASE_MULTIPLIER]        integer         NOT NULL
    , [TD0_AVG]                      float           NOT NULL
    , [TD1_AVG]                      float           NOT NULL
    , [TD2_AVG]                      float           NOT NULL
    , [LW_AVG]                       float           NOT NULL
    , [WRITE_TIME]                   decimal (38)    NOT NULL
    , [LAST_WRITE]                   decimal (38)    NOT NULL
);
go
CREATE VIEW SCI_RESOURCE_TRACE AS
SELECT 
    [R_ID]                         AS [R_ID]
    , [TAG]                          AS [TAG]
    , [TRACE_INTERVAL]               AS [TRACE_INTERVAL]
    , [TRACE_BASE]                   AS [TRACE_BASE]
    , [TRACE_BASE_MULTIPLIER]        AS [TRACE_BASE_MULTIPLIER]
    , [TD0_AVG]                      AS [TD0_AVG]
    , [TD1_AVG]                      AS [TD1_AVG]
    , [TD2_AVG]                      AS [TD2_AVG]
    , [LW_AVG]                       AS [LW_AVG]
    , dateadd(ss, round(([WRITE_TIME] % 1125899906842624)/1000, 0), '1970-01-01') AS [WRITE_TIME]
    , dateadd(ss, round(([LAST_WRITE] % 1125899906842624)/1000, 0), '1970-01-01') AS [LAST_WRITE]
  FROM [RESOURCE_TRACE];
go
