-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE [SCHEDULE] (
    [ID]                           decimal (38) NOT NULL
    , [NAME]                         varchar(64)     NOT NULL
    , [OWNER_ID]                     decimal (38)    NOT NULL
    , [INT_ID]                       decimal (38)        NULL
    , [PARENT_ID]                    decimal (38)        NULL
    , [TIME_ZONE]                    varchar(32)     NOT NULL
    , [SE_ID]                        decimal (38)        NULL
    , [ACTIVE]                       integer         NOT NULL
    , [CREATOR_U_ID]                 decimal (38)    NOT NULL
    , [CREATE_TS]                    decimal (38)    NOT NULL
    , [CHANGER_U_ID]                 decimal (38)    NOT NULL
    , [CHANGE_TS]                    decimal (38)    NOT NULL
    , [INHERIT_PRIVS]                decimal (38)    NOT NULL
);
go
CREATE UNIQUE INDEX PK_SCHEDULE
ON [SCHEDULE]([ID]);
go
CREATE VIEW SCI_SCHEDULE AS
SELECT 
    ID 
    , [NAME]                         AS [NAME]
    , [OWNER_ID]                     AS [OWNER_ID]
    , [INT_ID]                       AS [INT_ID]
    , [PARENT_ID]                    AS [PARENT_ID]
    , [TIME_ZONE]                    AS [TIME_ZONE]
    , [SE_ID]                        AS [SE_ID]
    , CASE [ACTIVE] WHEN 1 THEN 'ACTIVE' WHEN 0 THEN 'INACTIVE' END AS [ACTIVE]
    , [CREATOR_U_ID]                 AS [CREATOR_U_ID]
    , dateadd(ss, round(([CREATE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CREATE_TS]
    , [CHANGER_U_ID]                 AS [CHANGER_U_ID]
    , dateadd(ss, round(([CHANGE_TS] % 1125899906842624)/1000, 0), '1970-01-01') AS [CHANGE_TS]
    , [INHERIT_PRIVS]                AS [INHERIT_PRIVS]
  FROM [SCHEDULE];
go
