-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `DEPENDENCY_STATE` (
    `ID`                           decimal(20) NOT NULL
    , `DD_ID`                        decimal(20)     NOT NULL
    , `ESD_ID`                       decimal(20)     NOT NULL
    , `CONDITION`                    varchar(1024)       NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
    , `VALID_FROM`                 decimal(20) NOT NULL
    , `VALID_TO`                   decimal(20) NOT NULL
) ENGINE = INNODB;
CREATE INDEX PK_DEPENDENCY_STATE
ON `DEPENDENCY_STATE`(`ID`);
CREATE VIEW SCI_C_DEPENDENCY_STATE AS
SELECT 
    ID 
    , `DD_ID`                        AS `DD_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `CONDITION`                    AS `CONDITION`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `DEPENDENCY_STATE`
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_DEPENDENCY_STATE AS
SELECT 
    ID 
    , `DD_ID`                        AS `DD_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `CONDITION`                    AS `CONDITION`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
    , VALID_FROM
    , VALID_TO
  FROM `DEPENDENCY_STATE`;
