-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE `EXIT_STATE_MAPPING` (
    `ID`                           decimal(20) NOT NULL
    , `ESMP_ID`                      decimal(20)     NOT NULL
    , `ESD_ID`                       decimal(20)     NOT NULL
    , `ECR_START`                    integer             NULL
    , `ECR_END`                      integer             NULL
    , `CREATOR_U_ID`                 decimal(20)     NOT NULL
    , `CREATE_TS`                    decimal(20)     NOT NULL
    , `CHANGER_U_ID`                 decimal(20)     NOT NULL
    , `CHANGE_TS`                    decimal(20)     NOT NULL
    , `VALID_FROM`                 decimal(20) NOT NULL
    , `VALID_TO`                   decimal(20) NOT NULL
) ENGINE = INNODB;
CREATE INDEX PK_EXIT_STATE_MAPPING
ON `EXIT_STATE_MAPPING`(`ID`);
CREATE VIEW SCI_C_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , `ESMP_ID`                      AS `ESMP_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `ECR_START`                    AS `ECR_START`
    , `ECR_END`                      AS `ECR_END`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
  FROM `EXIT_STATE_MAPPING`
 WHERE VALID_TO = 9223372036854775807;
CREATE VIEW SCI_V_EXIT_STATE_MAPPING AS
SELECT 
    ID 
    , `ESMP_ID`                      AS `ESMP_ID`
    , `ESD_ID`                       AS `ESD_ID`
    , `ECR_START`                    AS `ECR_START`
    , `ECR_END`                      AS `ECR_END`
    , `CREATOR_U_ID`                 AS `CREATOR_U_ID`
    , from_unixtime((`CREATE_TS` & ~1125899906842624)/1000) AS `CREATE_TS`
    , `CHANGER_U_ID`                 AS `CHANGER_U_ID`
    , from_unixtime((`CHANGE_TS` & ~1125899906842624)/1000) AS `CHANGE_TS`
    , VALID_FROM
    , VALID_TO
  FROM `EXIT_STATE_MAPPING`;
