-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE EXTENTS (
    ID                             NUMBER (38) PRIMARY KEY
    , O_ID                           NUMBER (38)          NOT NULL
    , SME_ID                         NUMBER (38)          NOT NULL
    , SEQUENCE                       NUMBER (38)          NOT NULL
    , EXTENT                         VARCHAR2 (256 CHAR)  NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_EXTENTS AS
SELECT 
    ID 
    , O_ID                           AS O_ID
    , SME_ID                         AS SME_ID
    , SEQUENCE                       AS SEQUENCE
    , EXTENT                         AS EXTENT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM EXTENTS;
CREATE TABLE ARC_EXTENTS (
    ID                             NUMBER (38) NOT NULL
    , O_ID                           NUMBER (38)           NULL
    , SME_ID                         NUMBER (38)           NULL
    , SEQUENCE                       NUMBER (38)           NULL
    , EXTENT                         VARCHAR2 (256 CHAR)   NULL
    , CREATOR_U_ID                   NUMBER (38)           NULL
    , CREATE_TS                      NUMBER (38)           NULL
    , CHANGER_U_ID                   NUMBER (38)           NULL
    , CHANGE_TS                      NUMBER (38)           NULL
);
