-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE OBJECT_INSTANCE (
    ID                             NUMBER (38) PRIMARY KEY
    , UNIQUE_NAME                    VARCHAR2 (256 CHAR)  NOT NULL
    , OM_ID                          NUMBER (38)          NOT NULL
    , MODIFY_TS                      NUMBER (38)              NULL
    , REMOVE_TS                      NUMBER (38)              NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_OBJECT_INSTANCE AS
SELECT 
    ID 
    , UNIQUE_NAME                    AS UNIQUE_NAME
    , OM_ID                          AS OM_ID
    , pkg_time.gmt2local(MODIFY_TS) AS MODIFY_TS
    , pkg_time.gmt2local(REMOVE_TS) AS REMOVE_TS
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM OBJECT_INSTANCE;
