-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_ALLOCATION (
    ID                             NUMBER (38) PRIMARY KEY
    , R_ID                           NUMBER (38)          NOT NULL
    , SME_ID                         NUMBER (38)          NOT NULL
    , NR_ID                          NUMBER (38)          NOT NULL
    , AMOUNT                         NUMBER (38)              NULL
    , ORIG_AMOUNT                    NUMBER (38)              NULL
    , KEEP_MODE                      NUMBER (38)          NOT NULL
    , IS_STICKY                      NUMBER (1)           NOT NULL
    , STICKY_NAME                    VARCHAR2 (64 CHAR)       NULL
    , STICKY_PARENT                  NUMBER (38)              NULL
    , ALLOCATION_TYPE                NUMBER (38)          NOT NULL
    , RSMP_ID                        NUMBER (38)              NULL
    , LOCKMODE                       NUMBER (38)              NULL
    , REFCOUNT                       NUMBER (38)          NOT NULL
    , CREATOR_U_ID                   NUMBER (38)          NOT NULL
    , CREATE_TS                      NUMBER (38)          NOT NULL
    , CHANGER_U_ID                   NUMBER (38)          NOT NULL
    , CHANGE_TS                      NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_RESOURCE_ALLOCATION AS
SELECT 
    ID 
    , R_ID                           AS R_ID
    , SME_ID                         AS SME_ID
    , NR_ID                          AS NR_ID
    , AMOUNT                         AS AMOUNT
    , ORIG_AMOUNT                    AS ORIG_AMOUNT
    , DECODE (KEEP_MODE, 0, 'NOKEEP', 1, 'KEEP', 2, 'KEEP_FINAL') AS KEEP_MODE
    , DECODE (IS_STICKY, 1, 'TRUE', 0, 'FALSE') AS IS_STICKY
    , STICKY_NAME                    AS STICKY_NAME
    , STICKY_PARENT                  AS STICKY_PARENT
    , DECODE (ALLOCATION_TYPE, 1, 'REQUEST', 6, 'MASTER_REQUEST', 2, 'RESERVATION', 3, 'MASTER_RESERVATION', 4, 'ALLOCATION', 5, 'IGNORE') AS ALLOCATION_TYPE
    , RSMP_ID                        AS RSMP_ID
    , DECODE (LOCKMODE, 255, 'N', 0, 'X', 2, 'SX', 4, 'S', 6, 'SC') AS LOCKMODE
    , REFCOUNT                       AS REFCOUNT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , pkg_time.gmt2local(CREATE_TS) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , pkg_time.gmt2local(CHANGE_TS) AS CHANGE_TS
  FROM RESOURCE_ALLOCATION;
