-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_TRACE (
    R_ID                           NUMBER (38)          NOT NULL
    , TAG                            VARCHAR2 (64 CHAR)       NULL
    , TRACE_INTERVAL                 NUMBER (38)              NULL
    , TRACE_BASE                     NUMBER (38)              NULL
    , TRACE_BASE_MULTIPLIER          NUMBER (38)          NOT NULL
    , TD0_AVG                        NUMBER               NOT NULL
    , TD1_AVG                        NUMBER               NOT NULL
    , TD2_AVG                        NUMBER               NOT NULL
    , LW_AVG                         NUMBER               NOT NULL
    , WRITE_TIME                     NUMBER (38)          NOT NULL
    , LAST_WRITE                     NUMBER (38)          NOT NULL
);
CREATE OR REPLACE VIEW SCI_RESOURCE_TRACE AS
SELECT 
    R_ID                           AS R_ID
    , TAG                            AS TAG
    , TRACE_INTERVAL                 AS TRACE_INTERVAL
    , TRACE_BASE                     AS TRACE_BASE
    , TRACE_BASE_MULTIPLIER          AS TRACE_BASE_MULTIPLIER
    , TD0_AVG                        AS TD0_AVG
    , TD1_AVG                        AS TD1_AVG
    , TD2_AVG                        AS TD2_AVG
    , LW_AVG                         AS LW_AVG
    , pkg_time.gmt2local(WRITE_TIME) AS WRITE_TIME
    , pkg_time.gmt2local(LAST_WRITE) AS LAST_WRITE
  FROM RESOURCE_TRACE;
