/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.SDMSDesktop;

import de.independit.scheduler.SDMSDesktop.SDMSExitStateMappingWindow;
import de.independit.scheduler.SDMSDesktop.SDMSExitStateWindow;
import de.independit.scheduler.SDMSDesktop.SDMSLoginDialog;
import de.independit.scheduler.SDMSDesktop.SDMSServerConnection;
import de.independit.scheduler.SDMSDesktop.SDMSShellWindow;
import de.independit.scheduler.server.output.SDMSOutput;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.DefaultDesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;

public class SDMSDesktop
extends JFrame {
    public static final String __version = "@(#) $Id: SDMSDesktop.java,v 2.1.18.1 2013/03/14 10:24:03 ronald Exp $";
    public SDMSServerConnection serverConnection = null;
    public SDMSExitStateWindow exitStateWindow;
    public SDMSExitStateMappingWindow exitStateMappingWindow;
    public SDMSShellWindow shellWindow;
    public static final int MIN_DESKTOP_WIDTH = 600;
    public static final int MIN_DESKTOP_HEIGHT = 400;
    public static final int DESKTOP_WIDTH = 800;
    public static final int DESKTOP_HEIGHT = 600;
    public static final int MAX_DESKTOP_WIDTH = 1024;
    public static final int MAX_DESKTOP_HEIGHT = 768;
    private int maxX;
    private int maxY;
    public JDesktopPane desktop;
    public JScrollPane scrollPane;
    public JViewport viewport;
    public JMenuBar menuBar;
    public JMenu fileMenu;
    public JMenu windowsMenu;
    public JToolBar toolBar;

    public static void main(String[] stringArray) {
        new SDMSDesktop();
    }

    public SDMSDesktop() {
        super("SDMS Desktop [disconnected]");
        this.setSize(800, 600);
        Dimension dimension = this.getToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
        this.desktop = new JDesktopPane();
        this.desktop.setMinimumSize(new Dimension(600, 400));
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic('f');
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic('x');
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.fileMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Reconnect");
        jMenuItem2.setMnemonic('c');
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SDMSDesktop.this.do_login();
            }
        });
        this.fileMenu.add(jMenuItem2);
        this.menuBar.add(this.fileMenu);
        this.windowsMenu = new JMenu("Windows");
        this.fileMenu.setMnemonic('w');
        this.menuBar.add(this.windowsMenu);
        this.setJMenuBar(this.menuBar);
        this.toolBar = new JToolBar();
        this.getContentPane().add((Component)this.toolBar, "North");
        this.exitStateWindow = new SDMSExitStateWindow(this, "Exit States", true, true, true, true);
        this.desktop.add((Component)this.exitStateWindow, 0);
        this.exitStateMappingWindow = new SDMSExitStateMappingWindow(this, "Exit State Mappings", true, true, true, true);
        this.desktop.add((Component)this.exitStateMappingWindow, 0);
        this.shellWindow = new SDMSShellWindow(this, "SDMS Shell", true, true, true, true);
        this.desktop.add((Component)this.shellWindow, 0);
        this.scrollPane = new JScrollPane(this.desktop);
        this.viewport = this.scrollPane.getViewport();
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.desktop.setDesktopManager(new DefaultDesktopManager(){

            @Override
            public void dragFrame(JComponent jComponent, int n, int n2) {
                boolean bl = false;
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                Rectangle rectangle = SDMSDesktop.this.desktop.getBounds();
                Rectangle rectangle2 = jComponent.getBounds();
                int n3 = n + rectangle2.width;
                int n4 = n2 + rectangle2.height;
                if (n3 > rectangle.width) {
                    if (n3 > 1024) {
                        n3 = rectangle.width;
                    }
                    SDMSDesktop.this.maxX = n3;
                    n = n3 - rectangle2.width;
                    bl = true;
                }
                if (n4 > rectangle.height) {
                    if (n4 > 768) {
                        n4 = rectangle.height;
                    }
                    SDMSDesktop.this.maxY = n4;
                    n2 = n4 - rectangle2.height;
                    bl = true;
                }
                if (bl) {
                    SDMSDesktop.this.desktop.setPreferredSize(new Dimension(SDMSDesktop.this.maxX, SDMSDesktop.this.maxY));
                }
                jComponent.setLocation(n, n2);
                SDMSDesktop.this.scrollPane.validate();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setVisible(true);
        this.do_login();
    }

    void do_login() {
        if (this.serverConnection != null) {
            try {
                this.serverConnection.finish();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.serverConnection = null;
        }
        SDMSLoginDialog sDMSLoginDialog = null;
        while (this.serverConnection == null) {
            sDMSLoginDialog = new SDMSLoginDialog(this);
            if (!sDMSLoginDialog.ok) {
                System.exit(0);
            }
            this.serverConnection = new SDMSServerConnection(sDMSLoginDialog.hostname, sDMSLoginDialog.port, sDMSLoginDialog.username, sDMSLoginDialog.password);
            try {
                SDMSOutput sDMSOutput = this.serverConnection.connect();
                if (sDMSOutput.error == null) continue;
                JOptionPane.showMessageDialog(this.desktop, "ERROR: " + sDMSOutput.error.code + "\n TEXT: " + sDMSOutput.error.message, "Error", 0);
                this.serverConnection = null;
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.desktop, "ERROR: UNKNOWN\n TEXT: " + exception.toString(), "Error", 0);
                this.serverConnection = null;
            }
        }
        this.setTitle("SDMSDesktop [" + sDMSLoginDialog.username + "@" + sDMSLoginDialog.hostname + ":" + sDMSLoginDialog.port + "]");
    }
}

