/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.util.SDMSThread;
import de.independit.scheduler.server.util.SyncFifo;
import java.util.Date;
import java.util.Vector;

public abstract class InternalSession
extends SDMSThread {
    public static final String __version = "@(#) $Id: InternalSession.java,v 2.5.2.1 2013/03/14 10:24:09 ronald Exp $";
    protected ConnectionEnvironment cEnv;
    protected int wakeupInterval;
    protected int NR;
    private boolean doWait = true;
    private long lastRun = 0L;
    public long spinDelay;
    static final int NORMAL = 0;
    static final int INITIALIZE = 1;

    public InternalSession(String string) {
        super(string);
    }

    protected void initThread(SystemEnvironment systemEnvironment, SyncFifo syncFifo, int n, String string, int n2) {
        this.wakeupInterval = n2;
        this.spinDelay = this.wakeupInterval;
        this.cEnv = new ConnectionEnvironment(this.NR, string, false, null, syncFifo, null, null);
        this.cEnv.setMe(this);
        try {
            systemEnvironment.dbConnection = Server.connectToDB(systemEnvironment);
            this.cEnv.setGid(systemEnvironment, new Vector());
            this.cEnv.gid().add(SDMSObject.adminGId);
            this.cEnv.setUid(SDMSObject.internalUId);
            this.cEnv.setUser();
        }
        catch (SDMSException sDMSException) {
            InternalSession.doTrace(this.cEnv, "Cannot find INTERNAL User : " + sDMSException.toString(), -2);
        }
        try {
            systemEnvironment.dbConnection.close();
        }
        catch (Throwable throwable) {
            InternalSession.doTrace(this.cEnv, "Error on closing DB-Connection : " + throwable.toString(), -2);
        }
    }

    protected boolean post(Node node) throws FatalException {
        node.setEnv(this.cEnv);
        this.cEnv.actstmt = node.getName();
        this.cEnv.cmdQueue().post(node);
        this.cEnv.lock().do_wait();
        if (node.result.error != null) {
            InternalSession.doTrace(this.cEnv, "Error in internal Statement: " + node.result.error.code + " " + node.result.error.message, -1);
        }
        this.cEnv.setState(0);
        this.cEnv.actstmt = null;
        return node.result.error == null;
    }

    @Override
    public int id() {
        return -this.NR;
    }

    protected abstract Node getNode(int var1);

    public ConnectionEnvironment getEnv() {
        return this.cEnv;
    }

    public void wakeUp() {
        this.doWait = false;
    }

    @Override
    public void SDMSrun() {
        try {
            try {
                this.post(this.getNode(1));
            }
            catch (SDMSException sDMSException) {
                // empty catch block
            }
            while (this.run) {
                try {
                    this.doWait = true;
                    this.lastRun = new Date().getTime();
                    if (!this.isSuspended) {
                        this.post(this.getNode(0));
                    }
                }
                catch (SDMSException sDMSException) {
                    // empty catch block
                }
                long l = new Date().getTime();
                while (this.doWait && l - this.lastRun < (long)this.wakeupInterval) {
                    try {
                        InternalSession.sleep(this.spinDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = new Date().getTime();
                }
            }
        }
        catch (Error error) {
            InternalSession.doTrace(this.cEnv, error.toString(), error.getStackTrace(), -2);
        }
    }
}

