/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server;

import de.independit.scheduler.server.Server;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ShutdownThread
extends SDMSThread {
    public static final String __version = "@(#) $Id: ShutdownThread.java,v 2.6.6.1 2013/03/14 10:24:10 ronald Exp $";
    private SystemEnvironment sysEnv;
    private static final int NR = 999999999;
    private boolean postgres = false;

    public ShutdownThread(SystemEnvironment systemEnvironment, Server server) {
        super("Shutdown");
        this.sysEnv = systemEnvironment;
    }

    @Override
    public int id() {
        return -999999999;
    }

    @Override
    public void SDMSrun() {
        if (this.run) {
            ShutdownThread.doTrace(null, "***********************************************", 0);
            ShutdownThread.doTrace(null, "**                                           **", 0);
            ShutdownThread.doTrace(null, "** U N G R A C E F U L   S H U T D O W N ! ! **", 0);
            ShutdownThread.doTrace(null, "**                                           **", 0);
            ShutdownThread.doTrace(null, "***********************************************", 0);
        }
        try {
            this.sysEnv.dbConnection = Server.connectToDB(this.sysEnv);
        }
        catch (SDMSException sDMSException) {
            ShutdownThread.doTrace(null, "Error while unlocking repository (couldn't get database connection)", -1);
            return;
        }
        try {
            if (this.sysEnv.dbConnection.getMetaData().getDriverName().startsWith("PostgreSQL")) {
                this.postgres = true;
            }
        }
        catch (SQLException sQLException) {
            ShutdownThread.doTrace(null, "Error collecting Driver Information", -1);
        }
        ShutdownThread.doTrace(null, "Release repository lock from " + SystemEnvironment.startTime, 0);
        String string = "DELETE FROM REPOSITORY_LOCK " + (this.postgres ? "WHERE TS = CAST (? AS DECIMAL)" : " WHERE TS = ?");
        try {
            PreparedStatement preparedStatement = this.sysEnv.dbConnection.prepareStatement(string);
            preparedStatement.clearParameters();
            if (this.postgres) {
                preparedStatement.setString(1, "" + SystemEnvironment.startTime);
            } else {
                preparedStatement.setLong(1, SystemEnvironment.startTime);
            }
            preparedStatement.executeUpdate();
            this.sysEnv.dbConnection.commit();
            this.sysEnv.dbConnection.close();
        }
        catch (SQLException sQLException) {
            ShutdownThread.doTrace(null, "Error while unlocking repository", -1);
        }
        ShutdownThread.doTrace(null, "Shutdown completed", 0);
    }
}

