/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.dump;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.dump.Compare;
import de.independit.scheduler.server.dump.Dump;
import de.independit.scheduler.server.dump.DumpGrant;
import de.independit.scheduler.server.dump.DumpGroup;
import de.independit.scheduler.server.dump.DumpNamedResourceGeneric;
import de.independit.scheduler.server.dump.DumpResourceStateProfile;
import de.independit.scheduler.server.dump.DumpTrigger;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerTable;
import java.util.Collections;
import java.util.Vector;

class DumpNamedResource
extends DumpNamedResourceGeneric {
    public static final String __version = "@(#) $Id: DumpNamedResource.java,v 2.7.14.1 2013/03/14 10:24:13 ronald Exp $";
    private Vector withList;
    private Vector parmList;

    DumpNamedResource(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        super(systemEnvironment, sDMSNamedResource);
    }

    @Override
    final String initialize(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = super.initialize(systemEnvironment);
        Long l = this.nr.getParentId(systemEnvironment);
        return l == null ? string : DumpNamedResource.getDumpedName(systemEnvironment, l) + '.' + string;
    }

    private final void loadTrigger(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSTriggerTable.idx_fireId.getVector(systemEnvironment, this.nrId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTrigger sDMSTrigger = (SDMSTrigger)vector.get(i);
            Long l = sDMSTrigger.getId(systemEnvironment);
            DumpTrigger.getDumpedName(systemEnvironment, l);
        }
    }

    private final void loadParameters(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector vector = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, this.nrId);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector.get(i);
            Long l = sDMSParameterDefinition.getId(systemEnvironment);
            String string = Dump.quotedName(l, sDMSParameterDefinition.getName(systemEnvironment));
            String string2 = sDMSParameterDefinition.getDefaultValue(systemEnvironment);
            String string3 = string2 != null ? Dump.quotedString(string2.substring(1)) : null;
            String string4 = string + ' ' + sDMSParameterDefinition.getTypeAsString(systemEnvironment).toLowerCase() + (string3 != null ? " = " + string3 : "");
            this.parmList.add(string4);
        }
        Collections.sort(this.parmList, Compare.Lexically);
    }

    @Override
    final void collect(SystemEnvironment systemEnvironment) throws SDMSException {
        this.withList = new Vector();
        this.parmList = new Vector();
        this.withList.add("usage = " + this.nr.getUsageAsString(systemEnvironment).toLowerCase());
        Long l = this.nr.getRspId(systemEnvironment);
        if (l == null) {
            this.withList.add("state_profile = none");
        } else {
            this.withList.add("state_profile = " + DumpResourceStateProfile.getDumpedName(systemEnvironment, l));
        }
        Long l2 = this.nr.getOwnerId(systemEnvironment);
        this.withList.add("group = " + DumpGroup.getDumpedName(systemEnvironment, l2));
        this.loadParameters(systemEnvironment);
        if (this.parmList.size() > 0) {
            this.withList.add("parameters = (\n\t\t\t" + DumpNamedResource.join(",\n\t\t\t", this.parmList) + ')');
        } else {
            this.withList.add("parameters = none");
        }
        DumpGrant.getDumpedList(systemEnvironment, this.nrId);
        this.loadTrigger(systemEnvironment);
    }

    @Override
    final void render(String string) {
        DumpNamedResource.println(string + " named_resource " + this.getName());
        DumpNamedResource.println("\twith");
        DumpNamedResource.println("\t\t" + DumpNamedResource.join(",\n\t\t", this.withList) + ';');
    }
}

