/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.locking;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.locking.LockingSystem;
import de.independit.scheduler.server.locking.SyncLock;
import de.independit.scheduler.server.repository.SDMSIndexBucket;
import de.independit.scheduler.server.repository.SDMSIndexMap;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSVersions;
import de.independit.scheduler.server.util.SDMSThread;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ObjectLock {
    private static final boolean reUseLocks = true;
    public static final int SHARED = 0;
    public static final int EXCLUSIVE = 1;
    public static final String S_SHARED = "S";
    public static final String S_EXCLUSIVE = "X";
    public static final String S_WAIT = "W";
    public static final String S_NOWAIT = "N";
    public boolean wait;
    protected boolean waiting;
    protected boolean escalated;
    protected boolean notify;
    private static ObjectLock unusedLocks = null;
    protected int id = lastId++;
    public Object object = null;
    protected SDMSThread thread = null;
    protected SyncLock syncLock = new SyncLock(this);
    public int mode = 0;
    protected ObjectLock next = null;
    protected ObjectLock prev = null;
    public static long lockHWM = 0L;
    public static long lockUsed = 0L;
    public static long lockRequest = 0L;
    public static long lockDiscarded = 0L;
    public static long lockHWMdelta = 0L;
    private static int lastId = 0;
    public long createCp;
    public String stackTrace = null;
    public String freeStackTrace = null;

    protected ObjectLock(SDMSThread sDMSThread, Object object, int n, long l) {
        this.initialize(sDMSThread, object, n, l);
    }

    protected static synchronized void freeObjectLock(SystemEnvironment systemEnvironment, ObjectLock objectLock) {
        if (objectLock.thread == null || !systemEnvironment.thread.equals(objectLock.thread)) {
            System.out.println("ObjectLock:freeObjectLock: Oops, trying to free a lock which doesnt belong to our thread !");
            if (objectLock.freeStackTrace != null) {
                System.out.println("Lock has been freed at:\n" + objectLock.freeStackTrace);
                System.out.println("Current Stack Trace:");
                System.out.println(ObjectLock.getStackTrace());
            }
            return;
        }
        --lockUsed;
        if (objectLock.notify) {
            ++lockDiscarded;
            ++lockHWMdelta;
            return;
        }
        objectLock.object = null;
        objectLock.thread = null;
        objectLock.prev = null;
        objectLock.next = unusedLocks;
        unusedLocks = objectLock;
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_FREE)) != 0) {
            objectLock.freeStackTrace = ObjectLock.getStackTrace();
        }
    }

    protected static synchronized ObjectLock getObjectLock(SDMSThread sDMSThread, Object object, int n, long l) {
        ObjectLock objectLock = null;
        if (unusedLocks == null) {
            objectLock = new ObjectLock(sDMSThread, object, n, l);
            if (lockHWMdelta > 0L) {
                --lockHWMdelta;
            } else {
                ++lockHWM;
            }
        } else {
            objectLock = unusedLocks;
            unusedLocks = objectLock.next;
            objectLock.initialize(sDMSThread, object, n, l);
        }
        ++lockUsed;
        ++lockRequest;
        return objectLock;
    }

    private void initialize(SDMSThread sDMSThread, Object object, int n, long l) {
        if (object == null) {
            throw new RuntimeException();
        }
        this.object = object;
        this.thread = sDMSThread;
        this.mode = n;
        this.next = null;
        this.prev = null;
        this.createCp = l;
        this.wait = false;
        this.waiting = false;
        this.escalated = false;
        this.notify = false;
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_STACK_TRACES)) != 0) {
            this.stackTrace = ObjectLock.getStackTrace();
        }
        if ((LockingSystem.debug & (LockingSystem.DEBUG_ALL | LockingSystem.DEBUG_FREE)) != 0) {
            this.freeStackTrace = null;
        }
    }

    public boolean releaseAllowed(SystemEnvironment systemEnvironment) {
        boolean bl = true;
        if (this.object instanceof SDMSVersions && this.mode == 1 && ((SDMSVersions)this.object).tx == systemEnvironment.tx && ((SDMSVersions)this.object).o_v != null && ((SDMSVersions)this.object).o_v.size() > 0) {
            bl = false;
        }
        return bl;
    }

    public String modeToString() {
        if (this.mode == 0) {
            return S_SHARED;
        }
        return S_EXCLUSIVE;
    }

    public String toString() {
        if (this.object != null) {
            return "ObjectLock[" + this.id + "] on " + this.objectToShortString() + "[" + "mode=" + this.modeToString() + ", wait=" + this.wait + ", waiting=" + this.waiting + ", escalated=" + this.escalated + ", notify=" + this.notify + "]";
        }
        return "ObjectLock[" + this.id + "] uninitialized";
    }

    public String dumpLockList() {
        ObjectLock objectLock = this;
        while (objectLock.prev != null) {
            objectLock = objectLock.prev;
        }
        String string = "";
        String string2 = "";
        while (objectLock != null) {
            String string3 = "Oops, lock.thread == null!";
            if (objectLock.thread != null) {
                string3 = objectLock.thread.getName();
            }
            string = objectLock == this ? string + string2 + "{Thread " + string3 + ", " + objectLock.modeToString() + ", wait=" + objectLock.wait + ", waiting=" + objectLock.waiting + ", escalated=" + objectLock.escalated + ", notify=" + objectLock.notify + "}" : string + string2 + "[Thread " + string3 + ", " + objectLock.modeToString() + ", wait=" + objectLock.wait + ", waiting=" + objectLock.waiting + ", escalated=" + objectLock.escalated + ", notify=" + objectLock.notify + "]";
            string2 = " -> ";
            objectLock = objectLock.next;
        }
        return string;
    }

    public static String objectToShortString(Object object) {
        String string = object instanceof SDMSObject ? ((SDMSObject)object).toShortString() : (object instanceof SDMSVersions ? ((SDMSVersions)object).toShortString() : (object instanceof SDMSIndexBucket ? ((SDMSIndexBucket)object).toShortString() : (object instanceof SDMSIndexMap ? ((SDMSIndexMap)object).toShortString() : (object != null ? object.toString() : "Oops! lock.object == null!"))));
        return string;
    }

    public String objectToShortString() {
        String string = this.object instanceof SDMSObject ? ((SDMSObject)this.object).toShortString() : (this.object instanceof SDMSVersions ? ((SDMSVersions)this.object).toShortString() : (this.object instanceof SDMSIndexBucket ? ((SDMSIndexBucket)this.object).toShortString() : (this.object instanceof SDMSIndexMap ? ((SDMSIndexMap)this.object).toShortString() : (this.object != null ? this.object.toString() : "Oops! lock.object == null!"))));
        return string;
    }

    public static String getStackTrace() {
        Exception exception = new Exception();
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString().intern();
    }
}

