/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.ChownChecker;
import de.independit.scheduler.server.parser.IntervalUtil;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;

public class AlterScheduledEvent
extends Node {
    public static final String __version = "@(#) $Id: AlterScheduledEvent.java,v 2.9.4.1 2013/03/14 10:24:22 ronald Exp $";
    private final ObjectURL obj;
    private final WithHash with;
    private final Boolean active;
    private final boolean noerr;

    public AlterScheduledEvent(ObjectURL objectURL, WithHash withHash, Boolean bl) {
        this.obj = objectURL;
        this.with = withHash;
        this.active = !this.with.containsKey("ACTIVE") ? null : (Boolean)this.with.get("ACTIVE");
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Number number;
        SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)this.obj.resolve(systemEnvironment);
        boolean bl = false;
        String string = null;
        if (this.active != null) {
            boolean bl2 = sDMSScheduledEvent.getIsActive(systemEnvironment);
            if (this.active != bl2) {
                if (!bl2) {
                    sDMSScheduledEvent.setIsBroken(systemEnvironment, new Boolean(false));
                    sDMSScheduledEvent.setErrorCode(systemEnvironment, null);
                    sDMSScheduledEvent.setErrorMsg(systemEnvironment, null);
                }
                sDMSScheduledEvent.setIsActive(systemEnvironment, this.active);
                SystemEnvironment.timer.notifyChange(systemEnvironment, sDMSScheduledEvent, 2);
                if (!this.active.booleanValue()) {
                    sDMSScheduledEvent.clearCalendar(systemEnvironment);
                } else {
                    bl = true;
                }
            }
        }
        if (this.with.containsKey("GROUP")) {
            String string2 = (String)this.with.get("GROUP");
            number = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)string2), new Long(0L))).getId(systemEnvironment);
            ChownChecker.check(systemEnvironment, number);
            sDMSScheduledEvent.setOwnerId(systemEnvironment, (Long)number);
        }
        if (this.with.containsKey("BACKLOG_HANDLING")) {
            sDMSScheduledEvent.setBacklogHandling(systemEnvironment, (Integer)this.with.get("BACKLOG_HANDLING"));
        }
        if (this.with.containsKey("CALENDAR")) {
            Boolean bl3 = (Boolean)this.with.get("CALENDAR");
            if (!bl3.booleanValue()) {
                sDMSScheduledEvent.clearCalendar(systemEnvironment);
                sDMSScheduledEvent.setCalendarHorizon(systemEnvironment, null);
            } else if (!sDMSScheduledEvent.getIsCalendar(systemEnvironment).booleanValue()) {
                bl = true;
                sDMSScheduledEvent.setCalendarHorizon(systemEnvironment, null);
            }
            sDMSScheduledEvent.setIsCalendar(systemEnvironment, bl3);
        }
        if (this.with.containsKey("HORIZON")) {
            if (sDMSScheduledEvent.getIsCalendar(systemEnvironment).booleanValue()) {
                Integer n = (Integer)this.with.get("HORIZON");
                bl = true;
                sDMSScheduledEvent.setCalendarHorizon(systemEnvironment, n);
            } else {
                string = ". Superfluous horizon specification ignored";
            }
        }
        if (this.with.containsKey("SUSPEND_LIMIT")) {
            WithHash withHash = (WithHash)this.with.get("SUSPEND_LIMIT");
            if (withHash == null) {
                sDMSScheduledEvent.setSuspendLimit(systemEnvironment, null);
                sDMSScheduledEvent.setSuspendLimitMultiplier(systemEnvironment, null);
            } else {
                number = (Integer)withHash.get("INTERVAL");
                Integer n = IntervalUtil.getMultiplier(systemEnvironment, withHash);
                sDMSScheduledEvent.setSuspendLimit(systemEnvironment, (Integer)number);
                sDMSScheduledEvent.setSuspendLimitMultiplier(systemEnvironment, n);
            }
        }
        if (bl) {
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, sDMSScheduledEvent.getSceId(systemEnvironment));
            number = sDMSScheduledEvent.getNextActivityTime(systemEnvironment);
            sDMSScheduledEvent.updateCalendar(systemEnvironment, (Long)number, sDMSSchedule);
        }
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207262225", "Scheduled Event altered" + (string == null ? "" : string)));
    }
}

