/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSEnvironment;
import de.independit.scheduler.server.repository.SDMSEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSFolder;
import de.independit.scheduler.server.repository.SDMSFolderTable;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import java.util.Vector;

public class DropEnvironment
extends Node {
    public static final String __version = "@(#) $Id: DropEnvironment.java,v 2.2.14.1 2013/03/14 10:24:28 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropEnvironment(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedEnvironment sDMSNamedEnvironment;
        try {
            sDMSNamedEnvironment = (SDMSNamedEnvironment)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "03311122349", "No Environment dropped"));
                return;
            }
            throw notFoundException;
        }
        Long l = sDMSNamedEnvironment.getId(systemEnvironment);
        Vector vector = SDMSSchedulingEntityTable.idx_neId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            SDMSSchedulingEntity sDMSSchedulingEntity = (SDMSSchedulingEntity)vector.get(0);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03201222321", "Environment in use by Scheduling Entity $1", (Object)sDMSSchedulingEntity.pathString(systemEnvironment)));
        }
        vector = SDMSFolderTable.idx_envId.getVector(systemEnvironment, l);
        if (vector.size() > 0) {
            SDMSFolder sDMSFolder = (SDMSFolder)vector.get(0);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03309030925", "Environment in use by Folder $1", (Object)sDMSFolder.pathString(systemEnvironment)));
        }
        vector = SDMSEnvironmentTable.idx_neId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSEnvironment sDMSEnvironment = (SDMSEnvironment)vector.get(i);
            sDMSEnvironment.delete(systemEnvironment);
        }
        sDMSNamedEnvironment.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03201230008", "Environment dropped"));
    }
}

