/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSWatchType;

public class DropWt
extends Node {
    public static final String __version = "@(#) $Id: DropWt.java,v 2.1.4.3 2013/03/20 06:42:59 ronald Exp $";
    private ObjectURL url;
    private boolean noerr;

    public DropWt(ObjectURL objectURL, Boolean bl) {
        this.url = objectURL;
        this.noerr = bl;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSWatchType sDMSWatchType;
        systemEnvironment.checkFeatureAvailability("OBJECT_MONITOR");
        try {
            sDMSWatchType = (SDMSWatchType)this.url.resolve(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            if (this.noerr) {
                this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108240959", "No Watch Type dropped"));
                return;
            }
            throw notFoundException;
        }
        sDMSWatchType.delete(systemEnvironment);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "02108241000", "Watch Type dropped"));
    }
}

