/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SerializationException;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.JobDistribution;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSRunnableQueue;
import de.independit.scheduler.server.repository.SDMSRunnableQueueTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.util.SDMSFilter;
import de.independit.scheduler.server.util.SDMSThread;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class GetNextJob
extends JobDistribution {
    public static final String __version = "@(#) $Id: GetNextJob.java,v 2.18.6.2 2013/06/18 09:49:31 ronald Exp $";

    public GetNextJob() {
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSOutputContainer sDMSOutputContainer = null;
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        vector.add("COMMAND");
        SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, systemEnvironment.cEnv.uid());
        if (sDMSScope.getIsTerminate(systemEnvironment).booleanValue()) {
            vector2.add("SHUTDOWN");
            sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, systemEnvironment.cEnv.uid());
            sDMSScope.setIsTerminate(systemEnvironment, Boolean.FALSE);
        } else if (sDMSScope.getHasAlteredConfig(systemEnvironment).booleanValue()) {
            vector2.add("ALTER");
            vector.add("CONFIG");
            vector2.add(ScopeConfig.get(systemEnvironment, sDMSScope, false));
            sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, systemEnvironment.cEnv.uid());
            sDMSScope.setHasAlteredConfig(systemEnvironment, Boolean.FALSE);
        } else if (sDMSScope.getIsSuspended(systemEnvironment).booleanValue() || !sDMSScope.getIsRegistered(systemEnvironment).booleanValue()) {
            vector2.add("NOP");
        } else {
            while (!this.search_next_job(systemEnvironment, sDMSScope, vector, vector2)) {
                vector = new Vector();
                vector2 = new Vector();
                vector.add("COMMAND");
            }
        }
        SystemEnvironment.notifier.removeFromPingList(sDMSScope.getId(systemEnvironment));
        long l = systemEnvironment.cEnv.last();
        Long l2 = sDMSScope.getLastActive(systemEnvironment);
        if (l2 == null || l > l2) {
            sDMSScope = SDMSScopeTable.getObjectForUpdate(systemEnvironment, systemEnvironment.cEnv.uid());
            sDMSScope.setLastActive(systemEnvironment, new Long(l));
        }
        sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Jobserver Command", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean search_next_job(SystemEnvironment systemEnvironment, SDMSScope sDMSScope, Vector vector, Vector vector2) throws SDMSException {
        boolean bl;
        Object object;
        int n;
        Long l = sDMSScope.getId(systemEnvironment);
        SDMSRunnableQueue sDMSRunnableQueue2 = null;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSSubmittedEntity sDMSSubmittedEntity = null;
        SDMSKillJob sDMSKillJob = null;
        Long l2 = null;
        long l3 = new Date().getTime();
        Vector vector3 = SDMSRunnableQueueTable.idx_scopeId_state.getVectorForUpdate(systemEnvironment, new SDMSKey(l, new Integer(5)));
        for (SDMSRunnableQueue sDMSRunnableQueue2 : vector3) {
            long l4;
            n = sDMSRunnableQueue2.getState(systemEnvironment);
            l2 = sDMSRunnableQueue2.getSmeId(systemEnvironment);
            try {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l2);
            }
            catch (NotFoundException notFoundException) {
                sDMSKillJob = SDMSKillJobTable.getObjectForUpdate(systemEnvironment, l2);
            }
            HashMap<Long, Long> hashMap = SystemEnvironment.jidsStarting;
            synchronized (hashMap) {
                object = SystemEnvironment.jidsStarting.get(l2);
            }
            if (object != null && (l4 = ((Long)object).longValue()) + 5000L > l3) continue;
            HashMap<Long, Long> hashMap2 = SystemEnvironment.jidsStarting;
            synchronized (hashMap2) {
                SystemEnvironment.jidsStarting.put(l2, new Long(l3));
                break;
            }
        }
        if (sDMSSubmittedEntity == null && sDMSKillJob == null) {
            object = new SDMSFilter(){

                @Override
                public boolean isValid(SystemEnvironment systemEnvironment, SDMSProxy sDMSProxy) throws SDMSException {
                    Long l = ((SDMSRunnableQueue)sDMSProxy).getSmeId(systemEnvironment);
                    try {
                        SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l);
                        return sDMSSubmittedEntity.getIsSuspended(systemEnvironment) == 0 && sDMSSubmittedEntity.getParentSuspended(systemEnvironment) == 0;
                    }
                    catch (NotFoundException notFoundException) {
                        return true;
                    }
                }
            };
            vector3 = SDMSRunnableQueueTable.idx_scopeId_state.getVectorForUpdate(systemEnvironment, (Object)new SDMSKey(l, new Integer(4)), (SDMSFilter)object);
            if (vector3.size() == 0) {
                if (SystemEnvironment.maxWriter == 1) {
                    systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                    SystemEnvironment.sched.getNextJobSchedule(systemEnvironment);
                    systemEnvironment.tx.beginSubTransaction(systemEnvironment);
                    vector3 = SDMSRunnableQueueTable.idx_scopeId_state.getVector(systemEnvironment, (Object)new SDMSKey(l, new Integer(4)), (SDMSFilter)object);
                } else {
                    SystemEnvironment.sched.requestSchedule();
                }
            }
            if (vector3.size() > 0) {
                Long l5 = Long.MAX_VALUE;
                int n2 = 0;
                for (int i = 0; i < vector3.size(); ++i) {
                    sDMSRunnableQueue2 = (SDMSRunnableQueue)vector3.get(i);
                    n = sDMSRunnableQueue2.getState(systemEnvironment);
                    try {
                        l2 = sDMSRunnableQueue2.getSmeId(systemEnvironment);
                        SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObjectForUpdate(systemEnvironment, l2);
                        if (sDMSSubmittedEntity2.getRunnableTs(systemEnvironment) > l5) continue;
                        ++n2;
                        sDMSSubmittedEntity = sDMSSubmittedEntity2;
                        l5 = sDMSSubmittedEntity.getRunnableTs(systemEnvironment);
                        continue;
                    }
                    catch (NotFoundException notFoundException) {
                        sDMSKillJob = SDMSKillJobTable.getObject(systemEnvironment, l2);
                        if (sDMSKillJob.getRunnableTs(systemEnvironment) > l5) continue;
                        ++n2;
                        l5 = sDMSKillJob.getRunnableTs(systemEnvironment);
                    }
                }
            }
        }
        if (sDMSSubmittedEntity == null) {
            if (sDMSKillJob != null) {
                try {
                    bl = this.startKillJob(systemEnvironment, sDMSKillJob, sDMSScope, vector, vector2);
                }
                catch (SerializationException serializationException) {
                    throw serializationException;
                }
                catch (SDMSException sDMSException) {
                    SDMSThread.doTrace(this.env, "Exception from startKillJob : " + sDMSException.toString(), sDMSException.getStackTrace(), -1);
                    this.setToError(systemEnvironment, sDMSKillJob, l2, sDMSException.toSDMSMessage());
                    bl = false;
                }
            } else {
                vector2.add("NOP");
                systemEnvironment.tx.commitSubTransaction(systemEnvironment);
                bl = true;
            }
        } else {
            try {
                bl = this.startJob(systemEnvironment, sDMSSubmittedEntity, sDMSScope, vector, vector2);
            }
            catch (SerializationException serializationException) {
                throw serializationException;
            }
            catch (SDMSException sDMSException) {
                SDMSThread.doTrace(this.env, "Exception from startJob : " + sDMSException.toString(), sDMSException.getStackTrace(), -1);
                this.setToError(systemEnvironment, sDMSSubmittedEntity, l2, sDMSException.toSDMSMessage());
                bl = false;
            }
        }
        return bl;
    }
}

