/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.repository.SDMSEvent;
import de.independit.scheduler.server.repository.SDMSEventTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSScheduledEvent;
import de.independit.scheduler.server.repository.SDMSScheduledEventTable;
import de.independit.scheduler.server.timer.TimerUnit;
import de.independit.scheduler.server.util.DateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ListScheduledEvent
extends Node {
    public static final String __version = "@(#) $Id: ListScheduledEvent.java,v 2.11.8.2 2013/06/18 09:49:34 ronald Exp $";
    private static final String empty = "";

    public ListScheduledEvent() {
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("OWNER");
        vector.add("SCHEDULE");
        vector.add("EVENT");
        vector.add("ACTIVE");
        vector.add("EFF_ACTIVE");
        vector.add("BROKEN");
        vector.add("ERROR_CODE");
        vector.add("ERROR_MSG");
        vector.add("LAST_START");
        vector.add("NEXT_START");
        vector.add("NEXT_CALC");
        vector.add("PRIVS");
        vector.add("BACKLOG_HANDLING");
        vector.add("SUSPEND_LIMIT");
        vector.add("EFFECTIVE_SUSPEND_LIMIT");
        vector.add("CALENDAR");
        vector.add("CALENDAR_HORIZON");
        vector.add("EFFECTIVE_CALENDAR_HORIZON");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "List of Scheduled Events", vector);
        Iterator iterator = SDMSScheduledEventTable.table.iterator(systemEnvironment);
        while (iterator.hasNext()) {
            SDMSScheduledEvent sDMSScheduledEvent = (SDMSScheduledEvent)iterator.next();
            Vector<Object> vector2 = new Vector<Object>();
            vector2.add(sDMSScheduledEvent.getId(systemEnvironment));
            Long l = sDMSScheduledEvent.getOwnerId(systemEnvironment);
            SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
            vector2.add(sDMSGroup.getName(systemEnvironment));
            Long l2 = sDMSScheduledEvent.getSceId(systemEnvironment);
            SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l2);
            vector2.add(sDMSSchedule.pathVector(systemEnvironment));
            Long l3 = sDMSScheduledEvent.getEvtId(systemEnvironment);
            SDMSEvent sDMSEvent = SDMSEventTable.getObject(systemEnvironment, l3);
            vector2.add(sDMSEvent.getName(systemEnvironment));
            vector2.add(sDMSScheduledEvent.getIsActive(systemEnvironment));
            vector2.add(new Boolean(sDMSScheduledEvent.isReallyActive(systemEnvironment)));
            vector2.add(sDMSScheduledEvent.getIsBroken(systemEnvironment));
            String string = sDMSScheduledEvent.getErrorCode(systemEnvironment);
            if (string == null) {
                vector2.add(empty);
            } else {
                vector2.add(string);
            }
            String string2 = sDMSScheduledEvent.getErrorMsg(systemEnvironment);
            if (string2 == null) {
                vector2.add(empty);
            } else {
                vector2.add(string2);
            }
            Long l4 = sDMSScheduledEvent.getLastStartTime(systemEnvironment);
            if (l4 == null) {
                vector2.add(empty);
            } else {
                vector2.add(new DateTime(l4).toString());
            }
            Long l5 = sDMSScheduledEvent.getNextActivityTime(systemEnvironment);
            if (l5 == null) {
                vector2.add(empty);
                vector2.add(empty);
            } else {
                boolean bl = sDMSScheduledEvent.getNextActivityIsTrigger(systemEnvironment);
                if (bl) {
                    vector2.add(new DateTime(l5).toString());
                    vector2.add(empty);
                } else {
                    vector2.add(empty);
                    vector2.add(new DateTime(l5).toString());
                }
            }
            vector2.add(sDMSScheduledEvent.getPrivileges(systemEnvironment).toString());
            vector2.add(sDMSScheduledEvent.getBacklogHandlingAsString(systemEnvironment));
            TimerUnit timerUnit = new TimerUnit(sDMSScheduledEvent.getSuspendLimitMultiplier(systemEnvironment), sDMSScheduledEvent.getSuspendLimit(systemEnvironment));
            if (timerUnit.isINF()) {
                vector2.add(empty);
            } else {
                vector2.add(timerUnit.asString());
            }
            vector2.add(sDMSScheduledEvent.getEffectiveSuspendLimit(systemEnvironment).asString());
            Boolean bl = sDMSScheduledEvent.getIsCalendar(systemEnvironment);
            vector2.add(sDMSScheduledEvent.getIsCalendarAsString(systemEnvironment));
            if (bl.booleanValue()) {
                Integer n = sDMSScheduledEvent.getCalendarHorizon(systemEnvironment);
                vector2.add(n == null ? empty : n);
                vector2.add(sDMSScheduledEvent.getEffectiveCalendarHorizon(systemEnvironment));
            } else {
                vector2.add(empty);
                vector2.add(empty);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 2, 3));
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207261919", "$1 Scheduled Event(s) found", (Object)new Integer(sDMSOutputContainer.lines)));
    }
}

