/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.util.CheckSum;
import java.util.Random;
import java.util.Vector;

public abstract class ManipUser
extends Node {
    public static final String __version = "@(#) $Id";
    protected String user;
    protected ObjectURL url;
    protected String passwd;
    protected String salt;
    protected Integer method;
    protected String txtPasswd;
    protected Boolean enable;
    protected Long defaultGId;
    protected Vector grouplist;
    protected Vector addlist;
    protected Vector dellist;
    protected WithHash with;
    private boolean withEvaluated = false;
    protected Long publicGId;
    protected Integer connect_type;
    protected Vector userEquiv = null;
    protected static final Long ZERO = new Long(0L);
    protected static final int MD5LENGTH = 35;

    public ManipUser(ObjectURL objectURL, WithHash withHash) {
        this.with = withHash;
        this.url = objectURL;
        this.user = null;
        this.grouplist = new Vector();
        this.addlist = new Vector();
        this.dellist = new Vector();
        this.method = new Integer(1);
    }

    public ManipUser(String string, WithHash withHash) {
        this.with = withHash;
        this.user = string;
        this.url = null;
        this.grouplist = new Vector();
        this.addlist = new Vector();
        this.dellist = new Vector();
        this.method = new Integer(1);
    }

    @Override
    public abstract void go(SystemEnvironment var1) throws SDMSException;

    public static String generateSalt() {
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random(System.currentTimeMillis());
        for (int i = 0; i < 64; ++i) {
            char c = (char)(random.nextInt(96) + 32);
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    protected void evaluate_with(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l;
        int n;
        Vector vector;
        SDMSGroup sDMSGroup = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)"PUBLIC"), new Long(0L)));
        this.publicGId = sDMSGroup.getId(systemEnvironment);
        if (this.withEvaluated) {
            return;
        }
        this.passwd = null;
        if (this.with.containsKey("PASSWORD")) {
            this.txtPasswd = (String)this.with.get("PASSWORD");
            this.passwd = this.method == 0 ? CheckSum.mkstr(CheckSum.md5((this.txtPasswd + this.salt).getBytes()), true) : CheckSum.mkstr(CheckSum.sha256((this.txtPasswd + this.salt).getBytes()), false);
        }
        if (this.with.containsKey("RAWPASSWORD")) {
            if (this.passwd == null) {
                vector = (Vector)this.with.get("RAWPASSWORD");
                this.passwd = (String)vector.get(0);
                this.salt = (String)vector.get(1);
                if (this.passwd.length() == 35) {
                    this.method = new Integer(0);
                }
            } else {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "04312181625", "Both PASSWORD and RAWPASSWORD are not allowed"));
            }
        }
        this.enable = !this.with.containsKey("ENABLE") ? Boolean.TRUE : (Boolean)this.with.get("ENABLE");
        if (this.with.containsKey("DEFAULTGROUP")) {
            sDMSGroup = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)this.with.get("DEFAULTGROUP"))), new Long(0L)));
            this.defaultGId = sDMSGroup.getId(systemEnvironment);
        } else {
            this.defaultGId = null;
        }
        if (this.defaultGId != null) {
            this.grouplist.add(this.defaultGId);
        }
        if (this.with.containsKey("GROUPLIST")) {
            vector = (Vector)this.with.get("GROUPLIST");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), new Long(0L))).getId(systemEnvironment);
                if (l.equals(this.defaultGId)) continue;
                this.grouplist.add(l);
            }
        }
        this.connect_type = this.with.containsKey("CONNECT") ? (Integer)this.with.get("CONNECT") : new Integer(0);
        if (this.with.containsKey("EQUIVALENT")) {
            this.userEquiv = (Vector)this.with.get("EQUIVALENT");
        }
        if (this.with.containsKey("ADDGROUP")) {
            vector = (Vector)this.with.get("ADDGROUP");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), new Long(0L))).getId(systemEnvironment);
                this.addlist.add(l);
            }
        }
        if (this.with.containsKey("DELGROUP")) {
            vector = (Vector)this.with.get("DELGROUP");
            for (n = 0; n < vector.size(); ++n) {
                l = SDMSGroupTable.idx_name_deleteVersion_getUnique(systemEnvironment, new SDMSKey((Comparable)((Object)((String)vector.get(n))), new Long(0L))).getId(systemEnvironment);
                this.dellist.add(l);
            }
        }
        this.withEvaluated = true;
    }
}

