/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ObjectURL;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import java.util.Vector;

public class RenameNamedResource
extends Node {
    public static final String __version = "@(#) $Id: RenameNamedResource.java,v 2.2.2.1 2013/03/14 10:24:45 ronald Exp $";
    private ObjectURL url;
    private Vector path2;
    private String newName;

    public RenameNamedResource(ObjectURL objectURL, Vector vector) {
        this.url = objectURL;
        this.path2 = vector;
        this.newName = null;
    }

    public RenameNamedResource(ObjectURL objectURL, String string) {
        this.url = objectURL;
        this.path2 = null;
        this.newName = string;
    }

    private void moveNamedResource(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        Long l;
        String string;
        SDMSNamedResource sDMSNamedResource2;
        try {
            sDMSNamedResource2 = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path2);
            string = sDMSNamedResource.getName(systemEnvironment);
        }
        catch (NotFoundException notFoundException) {
            string = (String)this.path2.remove(this.path2.size() - 1);
            sDMSNamedResource2 = SDMSNamedResourceTable.getNamedResource(systemEnvironment, this.path2);
        }
        Long l2 = sDMSNamedResource2.getId(systemEnvironment);
        Long l3 = sDMSNamedResource.getParentId(systemEnvironment);
        if (l3 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03704102156", "The category RESOURCE cannot be moved"));
        }
        if (sDMSNamedResource2.getUsage(systemEnvironment) != 8) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03206250011", "Resource cannot be contained within another Resource"));
        }
        Long l4 = sDMSNamedResource.getId(systemEnvironment);
        if (l2.equals(l4)) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207041900", "A category cannot be moved below itself"));
        }
        while ((l = sDMSNamedResource2.getParentId(systemEnvironment)) != null) {
            if (l.equals(l4)) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03207041903", "A Folder cannot be moved below itself"));
            }
            sDMSNamedResource2 = SDMSNamedResourceTable.getObject(systemEnvironment, l);
        }
        sDMSNamedResource.set_ParentIdName(systemEnvironment, l2, string);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03112161307", "Named Resource moved"));
    }

    private void renameNamedResource(SystemEnvironment systemEnvironment, SDMSNamedResource sDMSNamedResource) throws SDMSException {
        sDMSNamedResource.setName(systemEnvironment, this.newName);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03203150039", "Named Resource renamed"));
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = (SDMSNamedResource)this.url.resolve(systemEnvironment);
        if (this.newName == null) {
            this.moveNamedResource(systemEnvironment, sDMSNamedResource);
        } else {
            this.renameNamedResource(systemEnvironment, sDMSNamedResource);
        }
    }
}

