/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.ScheduleUtil;
import de.independit.scheduler.server.parser.ShowCommented;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSPrivilege;
import de.independit.scheduler.server.repository.SDMSSchedule;
import de.independit.scheduler.server.repository.SDMSScheduleTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import java.util.Date;
import java.util.Vector;

public class ShowSchedule
extends ShowCommented {
    public static final String __version = "@(#) $Id: ShowSchedule.java,v 2.7.2.2 2013/06/18 09:49:37 ronald Exp $";
    private final Vector path;

    public ShowSchedule(Vector vector) {
        this.path = vector;
        this.txMode = 1;
        this.auditFlag = false;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = SDMSScheduleTable.pathToId(systemEnvironment, this.path);
        SDMSSchedule sDMSSchedule = SDMSScheduleTable.getObject(systemEnvironment, l);
        if (!sDMSSchedule.checkPrivileges(systemEnvironment, 0x10000000L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411723", "Insufficient privileges"));
        }
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("NAME");
        vector.add("OWNER");
        vector.add("INHERIT_PRIVS");
        vector.add("INTERVAL");
        vector.add("TIME_ZONE");
        vector.add("ACTIVE");
        vector.add("EFF_ACTIVE");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("COMMENT");
        vector.add("COMMENTTYPE");
        Vector<Object> vector2 = new Vector<Object>();
        Long l2 = sDMSSchedule.getId(systemEnvironment);
        vector2.add(l);
        vector2.add(sDMSSchedule.pathVector(systemEnvironment));
        Long l3 = sDMSSchedule.getOwnerId(systemEnvironment);
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l3);
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(new SDMSPrivilege(systemEnvironment, sDMSSchedule.getInheritPrivs(systemEnvironment)).toString());
        vector2.add(ScheduleUtil.getIvalName(systemEnvironment, sDMSSchedule));
        vector2.add(sDMSSchedule.getTimeZone(systemEnvironment));
        vector2.add(sDMSSchedule.getIsActive(systemEnvironment));
        vector2.add(new Boolean(sDMSSchedule.isReallyActive(systemEnvironment)));
        Date date = new Date();
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSchedule.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSchedule.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSchedule.getChangerUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSchedule.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSSchedule.getPrivileges(systemEnvironment).toString());
        vector2.add(this.getCommentContainer(systemEnvironment, l));
        vector2.add(this.getCommentInfoType(systemEnvironment, l));
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, "Schedule", vector, vector2);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "04207260049", "Schedule shown"));
    }
}

