/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser;

import de.independit.scheduler.server.SchedulingThread;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.HierarchyLister;
import de.independit.scheduler.server.parser.Node;
import de.independit.scheduler.server.parser.ResourceScopeLister;
import de.independit.scheduler.server.parser.ScopeConfig;
import de.independit.scheduler.server.parser.SsResourceScopeFormatter;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSDependencyDefinition;
import de.independit.scheduler.server.repository.SDMSDependencyDefinitionTable;
import de.independit.scheduler.server.repository.SDMSDependencyInstance;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyInstanceTable;
import de.independit.scheduler.server.repository.SDMSDependencyState;
import de.independit.scheduler.server.repository.SDMSDependencyStateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSDependencyStateTable;
import de.independit.scheduler.server.repository.SDMSEntityVariable;
import de.independit.scheduler.server.repository.SDMSEntityVariableTable;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfile;
import de.independit.scheduler.server.repository.SDMSExitStateMappingProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateProfile;
import de.independit.scheduler.server.repository.SDMSExitStateProfileTable;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfile;
import de.independit.scheduler.server.repository.SDMSExitStateTranslationProfileTable;
import de.independit.scheduler.server.repository.SDMSFootprint;
import de.independit.scheduler.server.repository.SDMSFootprintTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSHierarchyInstance;
import de.independit.scheduler.server.repository.SDMSHierarchyInstanceTable;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedEnvironment;
import de.independit.scheduler.server.repository.SDMSNamedEnvironmentTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceAllocation;
import de.independit.scheduler.server.repository.SDMSResourceAllocationTable;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchy;
import de.independit.scheduler.server.repository.SDMSSchedulingHierarchyTable;
import de.independit.scheduler.server.repository.SDMSScope;
import de.independit.scheduler.server.repository.SDMSScopeTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStats;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityTable;
import de.independit.scheduler.server.repository.SDMSUserTable;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprint;
import de.independit.scheduler.server.repository.SDMSnpSrvrSRFootprintTable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ShowSubmitted
extends Node {
    private static final int REQUIRED = 1;
    private static final int DEPENDENTS = 2;
    final Long jobId;
    long actVersion;
    Vector path;
    String tag;
    final WithHash with;
    static final int[] auditSortCols = new int[]{2, 3, 0};

    public ShowSubmitted(Long l) {
        this.txMode = 1;
        this.auditFlag = false;
        this.jobId = l;
        this.tag = null;
        this.with = null;
    }

    public ShowSubmitted(String string) {
        this.txMode = 1;
        this.auditFlag = false;
        this.jobId = null;
        this.tag = string;
        this.with = null;
    }

    public ShowSubmitted(Long l, WithHash withHash) {
        this.txMode = 1;
        this.auditFlag = false;
        this.jobId = l;
        this.tag = null;
        this.with = withHash;
    }

    public ShowSubmitted(String string, WithHash withHash) {
        this.txMode = 1;
        this.auditFlag = false;
        this.jobId = null;
        this.tag = string;
        this.with = withHash;
    }

    @Override
    public void go(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSSubmittedEntity sDMSSubmittedEntity;
        SDMSOutputContainer sDMSOutputContainer = null;
        if (this.jobId != null) {
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, this.jobId);
        } else {
            Vector vector = SDMSSubmittedEntityTable.idx_submitTag.getVector(systemEnvironment, this.tag);
            if (vector.size() > 0) {
                sDMSSubmittedEntity = (SDMSSubmittedEntity)vector.get(0);
            } else {
                throw new NotFoundException(new SDMSMessage(systemEnvironment, "03406032050", "Job with submittag $1 not found", (Object)this.tag));
            }
        }
        if (!sDMSSubmittedEntity.checkPrivileges(systemEnvironment, 4096L)) {
            throw new AccessViolationException(new SDMSMessage(systemEnvironment, "034020411726", "Insufficient privileges"));
        }
        this.actVersion = sDMSSubmittedEntity.getSeVersion(systemEnvironment);
        sDMSOutputContainer = this.showSchedulingEntity(systemEnvironment, sDMSSubmittedEntity);
        this.result.setOutputContainer(sDMSOutputContainer);
        this.result.setFeedback(new SDMSMessage(systemEnvironment, "03205081158", "Job shown"));
    }

    private SDMSOutputContainer showSchedulingEntity(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSExitStateDefinition sDMSExitStateDefinition;
        Vector<String> vector = new Vector<String>();
        Vector<Object> vector2 = new Vector<Object>();
        SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), this.actVersion);
        String string = sDMSSchedulingEntity.getTypeAsString(systemEnvironment);
        vector.add("ID");
        vector.add("SE_NAME");
        vector.add("SE_OWNER");
        vector.add("SE_TYPE");
        vector.add("SE_RUN_PROGRAM");
        vector.add("SE_RERUN_PROGRAM");
        vector.add("SE_KILL_PROGRAM");
        vector.add("SE_WORKDIR");
        vector.add("SE_LOGFILE");
        vector.add("SE_TRUNC_LOG");
        vector.add("SE_ERRLOGFILE");
        vector.add("SE_TRUNC_ERRLOG");
        vector.add("SE_EXPECTED_RUNTIME");
        vector.add("SE_PRIORITY");
        vector.add("SE_SUBMIT_SUSPENDED");
        vector.add("SE_MASTER_SUBMITTABLE");
        vector.add("SE_DEPENDENCY_MODE");
        vector.add("SE_ESP_NAME");
        vector.add("SE_ESM_NAME");
        vector.add("SE_ENV_NAME");
        vector.add("SE_FP_NAME");
        vector.add("MASTER_ID");
        vector.add("TIME_ZONE");
        vector.add("CHILD_TAG");
        vector.add("SE_VERSION");
        vector.add("OWNER");
        vector.add("PARENT_ID");
        vector.add("SCOPE_ID");
        vector.add("HTTPHOST");
        vector.add("HTTPPORT");
        vector.add("IS_STATIC");
        vector.add("MERGE_MODE");
        vector.add("STATE");
        vector.add("IS_DISABLED");
        vector.add("IS_PARENT_DISABLED");
        vector.add("IS_CANCELLED");
        vector.add("JOB_ESD_ID");
        vector.add("JOB_ESD_PREF");
        vector.add("JOB_IS_FINAL");
        vector.add("JOB_IS_RESTARTABLE");
        vector.add("FINAL_ESD_ID");
        vector.add("EXIT_CODE");
        vector.add("COMMANDLINE");
        vector.add("RR_COMMANDLINE");
        vector.add("WORKDIR");
        vector.add("LOGFILE");
        vector.add("ERRLOGFILE");
        vector.add("PID");
        vector.add("EXT_PID");
        vector.add("ERROR_MSG");
        vector.add("KILL_ID");
        vector.add("KILL_EXIT_CODE");
        vector.add("IS_SUSPENDED");
        vector.add("IS_SUSPENDED_LOCAL");
        vector.add("PRIORITY");
        vector.add("RAW_PRIORITY");
        vector.add("NICEVALUE");
        vector.add("NP_NICEVALUE");
        vector.add("MIN_PRIORITY");
        vector.add("AGING_AMOUNT");
        vector.add("AGING_BASE");
        vector.add("DYNAMIC_PRIORITY");
        vector.add("PARENT_SUSPENDED");
        vector.add("SUBMIT_TS");
        vector.add("RESUME_TS");
        vector.add("SYNC_TS");
        vector.add("RESOURCE_TS");
        vector.add("RUNNABLE_TS");
        vector.add("START_TS");
        vector.add("FINISH_TS");
        vector.add("FINAL_TS");
        vector.add("CNT_SUBMITTED");
        vector.add("CNT_DEPENDENCY_WAIT");
        vector.add("CNT_SYNCHRONIZE_WAIT");
        vector.add("CNT_RESOURCE_WAIT");
        vector.add("CNT_RUNNABLE");
        vector.add("CNT_STARTING");
        vector.add("CNT_STARTED");
        vector.add("CNT_RUNNING");
        vector.add("CNT_TO_KILL");
        vector.add("CNT_KILLED");
        vector.add("CNT_CANCELLED");
        vector.add("CNT_FINISHED");
        vector.add("CNT_FINAL");
        vector.add("CNT_BROKEN_ACTIVE");
        vector.add("CNT_BROKEN_FINISHED");
        vector.add("CNT_ERROR");
        vector.add("CNT_RESTARTABLE");
        vector.add("CNT_UNREACHABLE");
        vector.add("CNT_WARN");
        vector.add("WARN_COUNT");
        vector.add("IDLE_TIME");
        vector.add("DEPENDENCY_WAIT_TIME");
        vector.add("SUSPEND_TIME");
        vector.add("SYNC_TIME");
        vector.add("RESOURCE_TIME");
        vector.add("JOBSERVER_TIME");
        vector.add("RESTARTABLE_TIME");
        vector.add("CHILD_WAIT_TIME");
        vector.add("PROCESS_TIME");
        vector.add("ACTIVE_TIME");
        vector.add("IDLE_PCT");
        vector.add("CHILDREN");
        vector.add("PARENTS");
        vector.add("PARAMETER");
        vector.add("REQUIRED_JOBS");
        vector.add("DEPENDENT_JOBS");
        vector.add("REQUIRED_RESOURCES");
        vector.add("SUBMIT_PATH");
        vector.add("IS_REPLACED");
        vector.add("TIMEOUT_AMOUNT");
        vector.add("TIMEOUT_BASE");
        vector.add("TIMEOUT_STATE");
        vector.add("RERUN_SEQ");
        vector.add("AUDIT_TRAIL");
        vector.add("CHILD_SUSPENDED");
        vector.add("CNT_PENDING");
        vector.add("CREATOR");
        vector.add("CREATE_TIME");
        vector.add("CHANGER");
        vector.add("CHANGE_TIME");
        vector.add("PRIVS");
        vector.add("SE_PRIVS");
        vector.add("SUBMITTAG");
        vector.add("UNRESOLVED_HANDLING");
        vector.add("DEFINED_RESOURCES");
        if (string.equals("JOB")) {
            vector.add("RUNS");
        }
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Date date = new Date();
        vector2.add(l);
        vector2.add(sDMSSchedulingEntity.pathVector(systemEnvironment, this.actVersion));
        SDMSGroup sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSchedulingEntity.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(string);
        vector2.add(sDMSSchedulingEntity.getRunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getRerunProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getKillProgram(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getWorkdir(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getLogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncLog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getErrlogfile(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTruncErrlog(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getExpectedRuntime(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getPriority(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getSubmitSuspended(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getMasterSubmittable(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getDependencyOperationAsString(systemEnvironment));
        Long l2 = sDMSSchedulingEntity.getEspId(systemEnvironment);
        SDMSExitStateProfile sDMSExitStateProfile = SDMSExitStateProfileTable.getObject(systemEnvironment, l2, this.actVersion);
        vector2.add(sDMSExitStateProfile.getName(systemEnvironment));
        Long l3 = sDMSSchedulingEntity.getEsmpId(systemEnvironment);
        if (l3 != null) {
            SDMSExitStateMappingProfile sDMSExitStateMappingProfile = SDMSExitStateMappingProfileTable.getObject(systemEnvironment, l3, this.actVersion);
            vector2.add(sDMSExitStateMappingProfile.getName(systemEnvironment));
        } else {
            vector2.add("<default>");
        }
        Long l4 = sDMSSchedulingEntity.getNeId(systemEnvironment);
        if (l4 != null) {
            SDMSNamedEnvironment sDMSNamedEnvironment = SDMSNamedEnvironmentTable.getObject(systemEnvironment, l4, this.actVersion);
            vector2.add(sDMSNamedEnvironment.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        Long l5 = sDMSSchedulingEntity.getFpId(systemEnvironment);
        if (l5 != null) {
            SDMSFootprint sDMSFootprint = SDMSFootprintTable.getObject(systemEnvironment, l5, this.actVersion);
            vector2.add(sDMSFootprint.getName(systemEnvironment));
        } else {
            vector2.add("<null>");
        }
        vector2.add(sDMSSubmittedEntity.getMasterId(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getEffectiveTimeZoneName(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getChildTag(systemEnvironment));
        vector2.add(new Long(this.actVersion));
        sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, sDMSSubmittedEntity.getOwnerId(systemEnvironment));
        vector2.add(sDMSGroup.getName(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getParentId(systemEnvironment));
        Long l6 = sDMSSubmittedEntity.getScopeId(systemEnvironment);
        if (l6 != null) {
            try {
                SDMSScope sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l6);
                vector2.add(sDMSScope.pathVector(systemEnvironment));
                vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPHOST"));
                vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPPORT"));
            }
            catch (NotFoundException notFoundException) {
                vector2.add("Scope deleted");
                vector2.add(null);
                vector2.add(null);
            }
        } else {
            vector2.add(null);
            vector2.add(null);
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getIsStatic(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getMergeModeAsString(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getStateAsString(systemEnvironment));
        Boolean bl = sDMSSubmittedEntity.getIsCancelled(systemEnvironment);
        if (bl == null) {
            bl = sDMSSubmittedEntity.getState(systemEnvironment) == 10 ? Boolean.TRUE : Boolean.FALSE;
        }
        vector2.add(sDMSSubmittedEntity.getIsDisabled(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getIsParentDisabled(systemEnvironment));
        vector2.add(bl);
        Long l7 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
        if (l7 != null) {
            sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l7, this.actVersion);
            vector2.add(sDMSExitStateDefinition.getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getJobEsdPref(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getJobIsFinal(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getJobIsRestartable(systemEnvironment));
        l7 = sDMSSubmittedEntity.getFinalEsdId(systemEnvironment);
        if (l7 != null) {
            sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l7, this.actVersion);
            vector2.add(sDMSExitStateDefinition.getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getExitCode(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCommandline(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getRrCommandline(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getWorkdir(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getLogfile(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getErrlogfile(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getPid(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getExtPid(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getErrorMsg(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getKillId(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getKillExitCode(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getIsSuspendedAsString(systemEnvironment));
        Boolean bl2 = sDMSSubmittedEntity.getIsSuspendedLocal(systemEnvironment);
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        vector2.add(bl2);
        vector2.add(sDMSSubmittedEntity.getPriority(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getRawPriority(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getNice(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getNpNice(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getMinPriority(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getAgingAmount(systemEnvironment));
        vector2.add("MINUTES");
        if (sDMSSchedulingEntity.getType(systemEnvironment) == 1) {
            vector2.add(new Integer(SystemEnvironment.sched.getDynPriority(systemEnvironment, sDMSSubmittedEntity)));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getParentSuspended(systemEnvironment));
        Long l8 = sDMSSubmittedEntity.getSubmitTs(systemEnvironment);
        if (l8 != null) {
            date.setTime(l8);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        Long l9 = sDMSSubmittedEntity.getResumeTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l9 = sDMSSubmittedEntity.getSyncTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l9 = sDMSSubmittedEntity.getResourceTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l9 = sDMSSubmittedEntity.getRunnableTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l9 = sDMSSubmittedEntity.getStartTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l9 = sDMSSubmittedEntity.getFinishTs(systemEnvironment);
        if (l9 != null) {
            date.setTime(l9);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        Long l10 = sDMSSubmittedEntity.getFinalTs(systemEnvironment);
        if (l10 != null) {
            date.setTime(l10);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntRunnable(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntStarting(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntStarted(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntRunning(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntToKill(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntKilled(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntCancelled(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntFinished(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntFinal(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntError(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntRestartable(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntWarn(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getWarnCount(systemEnvironment));
        Integer n = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getIdleTime(systemEnvironment), sDMSSubmittedEntity.getIdleTs(systemEnvironment), -1);
        vector2.add(n.toString());
        Integer n2 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getDependencyWaitTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 1);
        vector2.add(n2.toString());
        Integer n3 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getSuspendTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 2);
        vector2.add(n3.toString());
        Integer n4 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getSyncTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 3);
        vector2.add(n4.toString());
        Integer n5 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getResourceTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 4);
        vector2.add(n5.toString());
        Integer n6 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getJobserverTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 5);
        vector2.add(n6.toString());
        Integer n7 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getRestartableTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 6);
        vector2.add(n7.toString());
        Integer n8 = sDMSSubmittedEntity.evaluateTime(systemEnvironment, sDMSSubmittedEntity.getChildWaitTime(systemEnvironment), sDMSSubmittedEntity.getStatisticTs(systemEnvironment), 7);
        vector2.add(n8.toString());
        int n9 = l10 != null ? (int)((l10 - l8) / 1000L) : (int)((systemEnvironment.cEnv.last() - l8) / 1000L);
        int n10 = n9 - n2;
        vector2.add(new Integer(n10));
        vector2.add(new Integer(n10 - n));
        if (n10 == 0) {
            vector2.add("");
        } else {
            vector2.add(new Integer(n * 100 / n10));
        }
        vector2.add(this.childContainer(systemEnvironment, l));
        vector2.add(this.parentContainer(systemEnvironment, l));
        vector2.add(this.parameterContainer(systemEnvironment, sDMSSubmittedEntity, sDMSSchedulingEntity));
        vector2.add(this.requiredJobContainer(systemEnvironment, sDMSSubmittedEntity));
        vector2.add(this.dependentJobContainer(systemEnvironment, sDMSSubmittedEntity));
        vector2.add(this.resourceContainer(systemEnvironment, sDMSSubmittedEntity));
        vector2.add(sDMSSubmittedEntity.getSubmitPathString(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getIsReplaced(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTimeoutAmount(systemEnvironment));
        vector2.add(sDMSSchedulingEntity.getTimeoutBaseAsString(systemEnvironment));
        l7 = sDMSSchedulingEntity.getTimeoutStateId(systemEnvironment);
        if (l7 != null) {
            vector2.add(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l7, this.actVersion).getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getRerunSeq(systemEnvironment));
        vector2.add(this.auditContainer(systemEnvironment, sDMSSubmittedEntity));
        vector2.add(sDMSSubmittedEntity.getChildSuspended(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getCntPending(systemEnvironment));
        try {
            vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSubmittedEntity.getCreatorUId(systemEnvironment)).getName(systemEnvironment));
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSubmittedEntity.getCreateTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        try {
            try {
                vector2.add(SDMSUserTable.getObject(systemEnvironment, sDMSSubmittedEntity.getChangerUId(systemEnvironment)).getName(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector2.add(SDMSScopeTable.getObject(systemEnvironment, sDMSSubmittedEntity.getChangerUId(systemEnvironment)).pathString(systemEnvironment));
            }
        }
        catch (NotFoundException notFoundException) {
            vector2.add("unknown");
        }
        date.setTime(sDMSSubmittedEntity.getChangeTs(systemEnvironment));
        vector2.add(systemEnvironment.systemDateFormat.format(date));
        vector2.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
        vector2.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment, this.actVersion).toString());
        vector2.add(sDMSSubmittedEntity.getSubmitTag(systemEnvironment));
        Integer n11 = sDMSSubmittedEntity.getUnresolvedHandling(systemEnvironment);
        if (n11 == null) {
            vector2.add(null);
        } else if (n11 == 3) {
            vector2.add("SUSPEND");
        } else if (n11 == 4) {
            vector2.add("DEFERED");
        } else {
            vector2.add("IGNORE");
        }
        vector2.add(this.definedResources(systemEnvironment, l));
        if (string.equals("JOB")) {
            vector2.add(this.runs(systemEnvironment, sDMSSubmittedEntity));
        }
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, new SDMSMessage(systemEnvironment, "03205081202", "Job"), vector, vector2);
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer childContainer(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, l);
        return this.familyContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer parentContainer(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector vector = SDMSHierarchyInstanceTable.idx_childId.getVector(systemEnvironment, l);
        return this.familyContainer(systemEnvironment, vector);
    }

    private SDMSOutputContainer familyContainer(SystemEnvironment systemEnvironment, Vector vector) throws SDMSException {
        Vector<String> vector2 = new Vector<String>();
        vector2.add("CHILDID");
        vector2.add("CHILDPRIVS");
        vector2.add("CHILDSENAME");
        vector2.add("CHILDSETYPE");
        vector2.add("CHILDSEPRIVS");
        vector2.add("PARENTID");
        vector2.add("PARENTPRIVS");
        vector2.add("PARENTSENAME");
        vector2.add("PARENTSETYPE");
        vector2.add("PARENTSEPRIVS");
        vector2.add("IS_STATIC");
        vector2.add("PRIORITY");
        vector2.add("SUSPEND");
        vector2.add("MERGE_MODE");
        vector2.add("EST_NAME");
        vector2.add("IGNORED_DEPENDENCIES");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        for (SDMSHierarchyInstance sDMSHierarchyInstance : vector) {
            SDMSSchedulingHierarchy sDMSSchedulingHierarchy = SDMSSchedulingHierarchyTable.getObject(systemEnvironment, sDMSHierarchyInstance.getShId(systemEnvironment), this.actVersion);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSHierarchyInstance.getChildId(systemEnvironment));
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getChildId(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), this.actVersion);
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment, this.actVersion));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment, this.actVersion).toString());
            vector3.add(sDMSHierarchyInstance.getParentId(systemEnvironment));
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSHierarchyInstance.getParentId(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), this.actVersion);
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment, this.actVersion));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment, this.actVersion).toString());
            vector3.add(sDMSSchedulingHierarchy.getIsStatic(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getPriority(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getSuspendAsString(systemEnvironment));
            vector3.add(sDMSSchedulingHierarchy.getMergeModeAsString(systemEnvironment));
            Long l = sDMSSchedulingHierarchy.getEstpId(systemEnvironment);
            if (l != null) {
                SDMSExitStateTranslationProfile sDMSExitStateTranslationProfile = SDMSExitStateTranslationProfileTable.getObject(systemEnvironment, l, this.actVersion);
                vector3.add(sDMSExitStateTranslationProfile.getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            Vector vector4 = SDMSIgnoredDependencyTable.idx_shId.getVector(systemEnvironment, (Object)sDMSSchedulingHierarchy.getId(systemEnvironment), this.actVersion);
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector4.size(); ++i) {
                SDMSIgnoredDependency sDMSIgnoredDependency = (SDMSIgnoredDependency)vector4.get(i);
                stringBuffer.append(string);
                stringBuffer.append(sDMSIgnoredDependency.getDdName(systemEnvironment));
                string = ",";
            }
            vector3.add(new String(stringBuffer));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer parameterContainer(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSSchedulingEntity sDMSSchedulingEntity) throws SDMSException {
        Vector<Object> vector;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("NAME");
        vector2.add("TYPE");
        vector2.add("VALUE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        Vector vector3 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, (Object)sDMSSchedulingEntity.getId(systemEnvironment), this.actVersion);
        for (n = 0; n < vector3.size(); ++n) {
            SDMSParameterDefinition sDMSParameterDefinition = (SDMSParameterDefinition)vector3.get(n);
            vector = new Vector<Object>();
            vector.add(sDMSParameterDefinition.getId(systemEnvironment));
            vector.add(sDMSParameterDefinition.getName(systemEnvironment));
            hashSet.add(sDMSParameterDefinition.getName(systemEnvironment));
            vector.add(sDMSParameterDefinition.getTypeAsString(systemEnvironment));
            try {
                vector.add(sDMSSubmittedEntity.getVariableValue(systemEnvironment, sDMSParameterDefinition.getName(systemEnvironment), false, "DEFAULT"));
            }
            catch (NotFoundException notFoundException) {
                vector.add(null);
            }
            catch (CommonErrorException commonErrorException) {
                vector.add("ERROR: " + commonErrorException.toString());
            }
            sDMSOutputContainer.addData(systemEnvironment, vector);
        }
        vector3 = SDMSEntityVariableTable.idx_smeId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (n = 0; n < vector3.size(); ++n) {
            SDMSEntityVariable sDMSEntityVariable = (SDMSEntityVariable)vector3.get(n);
            if (hashSet.contains(sDMSEntityVariable.getName(systemEnvironment))) continue;
            vector = new Vector();
            vector.add(sDMSEntityVariable.getId(systemEnvironment));
            vector.add(sDMSEntityVariable.getName(systemEnvironment));
            vector.add("LOCAL");
            vector.add(sDMSEntityVariable.getValue(systemEnvironment).substring(1));
            sDMSOutputContainer.addData(systemEnvironment, vector);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer requiredJobContainer(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector = SDMSDependencyInstanceTable.idx_dependentId.getVector(systemEnvironment, l);
        SDMSOutputContainer sDMSOutputContainer = this.dependentContainer(systemEnvironment, vector, 1);
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 3, 7));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer dependentJobContainer(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Object object2;
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector = SDMSDependencyInstanceTable.idx_requiredId.getVector(systemEnvironment, l);
        Vector<Object> vector2 = new Vector<Object>();
        for (Object object2 : vector) {
            if (!((SDMSDependencyInstanceProxyGeneric)object2).getDependentId(systemEnvironment).equals(((SDMSDependencyInstanceProxyGeneric)object2).getDependentIdOrig(systemEnvironment))) continue;
            vector2.add(object2);
        }
        object2 = this.dependentContainer(systemEnvironment, vector2, 2);
        Collections.sort(((SDMSOutputContainer)object2).dataset, ((SDMSOutputContainer)object2).getComparator(systemEnvironment, 3, 2));
        return object2;
    }

    private SDMSOutputContainer dependentContainer(SystemEnvironment systemEnvironment, Vector vector, int n) throws SDMSException {
        Vector<String> vector2 = new Vector<String>();
        vector2.add("ID");
        vector2.add("DEPENDENT_ID");
        vector2.add("DEPENDENT_PATH");
        vector2.add("DEPENDENT_PRIVS");
        vector2.add("DEPENDENT_ID_ORIG");
        vector2.add("DEPENDENT_PATH_ORIG");
        vector2.add("DEPENDENT_PRIVS_ORIG");
        vector2.add("DEPENDENCY_OPERATION");
        vector2.add("REQUIRED_ID");
        vector2.add("REQUIRED_PATH");
        vector2.add("REQUIRED_PRIVS");
        vector2.add("STATE");
        vector2.add("DD_ID");
        vector2.add("DD_NAME");
        vector2.add("DD_DEPENDENTNAME");
        vector2.add("DD_DEPENDENTTYPE");
        vector2.add("DD_DEPENDENTPRIVS");
        vector2.add("DD_REQUIREDNAME");
        vector2.add("DD_REQUIREDTYPE");
        vector2.add("DD_REQUIREDPRIVS");
        vector2.add("DD_UNRESOLVED_HANDLING");
        vector2.add("DD_STATE_SELECTION");
        vector2.add("DD_MODE");
        vector2.add("DD_STATES");
        vector2.add("JOB_STATE");
        vector2.add("IS_SUSPENDED");
        vector2.add("PARENT_SUSPENDED");
        vector2.add("CNT_SUBMITTED");
        vector2.add("CNT_DEPENDENCY_WAIT");
        vector2.add("CNT_SYNCHRONIZE_WAIT");
        vector2.add("CNT_RESOURCE_WAIT");
        vector2.add("CNT_RUNNABLE");
        vector2.add("CNT_STARTING");
        vector2.add("CNT_STARTED");
        vector2.add("CNT_RUNNING");
        vector2.add("CNT_TO_KILL");
        vector2.add("CNT_KILLED");
        vector2.add("CNT_CANCELLED");
        vector2.add("CNT_FINISHED");
        vector2.add("CNT_FINAL");
        vector2.add("CNT_BROKEN_ACTIVE");
        vector2.add("CNT_BROKEN_FINISHED");
        vector2.add("CNT_ERROR");
        vector2.add("CNT_RESTARTABLE");
        vector2.add("CNT_UNREACHABLE");
        vector2.add("JOB_IS_FINAL");
        vector2.add("CHILD_TAG");
        vector2.add("FINAL_STATE");
        vector2.add("CHILDREN");
        vector2.add("IGNORE");
        vector2.add("CHILD_SUSPENDED");
        vector2.add("CNT_PENDING");
        vector2.add("DD_CONDITION");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector2);
        for (int i = 0; i < vector.size(); ++i) {
            SDMSProxy sDMSProxy;
            Object object;
            SDMSDependencyInstance sDMSDependencyInstance = (SDMSDependencyInstance)vector.get(i);
            SDMSDependencyDefinition sDMSDependencyDefinition = SDMSDependencyDefinitionTable.getObject(systemEnvironment, sDMSDependencyInstance.getDdId(systemEnvironment), this.actVersion);
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSDependencyInstance.getId(systemEnvironment));
            vector3.add(sDMSDependencyInstance.getDependentId(systemEnvironment));
            SDMSSubmittedEntity sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getDependentId(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getSubmitPathString(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
            vector3.add(sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
            sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getDependentIdOrig(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getSubmitPathString(systemEnvironment));
            vector3.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
            vector3.add(sDMSDependencyInstance.getDependencyOperationAsString(systemEnvironment));
            vector3.add(sDMSDependencyInstance.getRequiredId(systemEnvironment));
            if (n == 1) {
                try {
                    sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getRequiredId(systemEnvironment));
                }
                catch (NotFoundException notFoundException) {
                    sDMSSubmittedEntity = null;
                }
            } else {
                sDMSSubmittedEntity = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSDependencyInstance.getDependentId(systemEnvironment));
            }
            if (sDMSSubmittedEntity == null) {
                object = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeRequiredId(systemEnvironment), this.actVersion);
                vector3.add(((SDMSSchedulingEntity)object).pathVector(systemEnvironment, this.actVersion));
                vector3.add(null);
            } else {
                vector3.add(sDMSSubmittedEntity.getSubmitPathString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getPrivileges(systemEnvironment).toString());
            }
            vector3.add(sDMSDependencyInstance.getStateAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getId(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getName(systemEnvironment));
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeDependentId(systemEnvironment), this.actVersion);
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment, this.actVersion));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment, this.actVersion).toString());
            sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSDependencyDefinition.getSeRequiredId(systemEnvironment), this.actVersion);
            vector3.add(sDMSSchedulingEntity.pathVector(systemEnvironment, this.actVersion));
            vector3.add(sDMSSchedulingEntity.getTypeAsString(systemEnvironment));
            vector3.add(sDMSSchedulingEntity.getPrivileges(systemEnvironment, this.actVersion).toString());
            vector3.add(sDMSDependencyDefinition.getUnresolvedHandlingAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getStateSelectionAsString(systemEnvironment));
            vector3.add(sDMSDependencyDefinition.getModeAsString(systemEnvironment));
            object = SDMSDependencyStateTable.idx_ddId.getVector(systemEnvironment, (Object)sDMSDependencyDefinition.getId(systemEnvironment), this.actVersion);
            String string = "";
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < ((Vector)object).size(); ++j) {
                sDMSProxy = (SDMSDependencyState)((Vector)object).get(j);
                String string2 = SDMSExitStateDefinitionTable.getObject(systemEnvironment, ((SDMSDependencyStateProxyGeneric)sDMSProxy).getEsdId(systemEnvironment), this.actVersion).getName(systemEnvironment);
                stringBuffer.append(string);
                stringBuffer.append(string2);
                String string3 = ((SDMSDependencyStateProxyGeneric)sDMSProxy).getCondition(systemEnvironment);
                if (string3 != null) {
                    stringBuffer.append("*");
                }
                string = ",";
            }
            vector3.add(new String(stringBuffer));
            if (sDMSSubmittedEntity != null) {
                vector3.add(sDMSSubmittedEntity.getStateAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getIsSuspendedAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getParentSuspended(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntSubmitted(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntDependencyWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntSynchronizeWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntResourceWait(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntRunnable(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntStarting(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntStarted(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntRunning(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntToKill(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntKilled(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntCancelled(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntFinished(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntFinal(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntBrokenActive(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntBrokenFinished(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntError(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntRestartable(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntUnreachable(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getJobIsFinal(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getChildTag(systemEnvironment));
                if (sDMSSubmittedEntity.getState(systemEnvironment) == 12 || sDMSDependencyDefinition.getMode(systemEnvironment) == 2 && sDMSSubmittedEntity.getJobIsFinal(systemEnvironment).booleanValue()) {
                    Long l = sDMSDependencyDefinition.getMode(systemEnvironment) == 2 ? sDMSSubmittedEntity.getJobEsdId(systemEnvironment) : sDMSSubmittedEntity.getFinalEsdId(systemEnvironment);
                    if (l != null) {
                        sDMSProxy = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l);
                        vector3.add(((SDMSExitStateDefinitionProxyGeneric)sDMSProxy).getName(systemEnvironment));
                    } else {
                        vector3.add(null);
                    }
                } else {
                    vector3.add(null);
                }
                Vector vector4 = SDMSHierarchyInstanceTable.idx_parentId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
                vector3.add(new Integer(vector4.size()));
                vector3.add(sDMSDependencyInstance.getIgnoreAsString(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getChildSuspended(systemEnvironment));
                vector3.add(sDMSSubmittedEntity.getCntPending(systemEnvironment));
                vector3.add(sDMSDependencyDefinition.getCondition(systemEnvironment));
            } else {
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(null);
                vector3.add(sDMSDependencyInstance.getIgnoreAsString(systemEnvironment));
                vector3.add(null);
                vector3.add(null);
                vector3.add(sDMSDependencyDefinition.getCondition(systemEnvironment));
            }
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer resourceContainer(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Serializable serializable;
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        Object object;
        try {
            object = SchedulingThread.getJobFootprint(systemEnvironment, sDMSSubmittedEntity);
            hashMap3 = (HashMap)((Vector)object).get(0);
            hashMap2 = (HashMap)((Vector)object).get(1);
            hashMap = (HashMap)((Vector)object).get(2);
        }
        catch (NotFoundException notFoundException) {
            hashMap3 = new HashMap();
            hashMap2 = new HashMap();
            hashMap = new HashMap();
        }
        object = new ResourceScopeLister(null, null);
        ((HierarchyLister)object).setTitle(null);
        ((HierarchyLister)object).setFormatter(new SsResourceScopeFormatter(systemEnvironment, sDMSSubmittedEntity));
        int[] nArray = new int[]{1};
        ((HierarchyLister)object).setSortColumns(nArray);
        Vector<Object> vector = new Vector<Object>();
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        int n = sDMSSubmittedEntity.getState(systemEnvironment);
        boolean bl = false;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                bl = true;
            }
            case 0: {
                Iterator<Object> iterator;
                SDMSProxy sDMSProxy;
                HashSet<Long> hashSet = new HashSet<Long>();
                serializable = SDMSScopeTable.idx_type.getVector(systemEnvironment, new Integer(2));
                int n2 = ((Vector)serializable).size();
                for (int i = 0; i < n2; ++i) {
                    sDMSProxy = (SDMSScope)((Vector)serializable).get(i);
                    SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = (SDMSnpSrvrSRFootprint)SDMSnpSrvrSRFootprintTable.idx_sId.getUnique(systemEnvironment, sDMSProxy.getId(systemEnvironment));
                    HashMap hashMap4 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                    if (!SchedulingThread.fits(systemEnvironment, hashMap4, hashMap3, sDMSSubmittedEntity, bl, (SDMSScope)(bl ? sDMSProxy : null))) continue;
                    iterator = hashMap3.keySet().iterator();
                    boolean bl2 = false;
                    block9: while (iterator.hasNext()) {
                        Long l2 = (Long)iterator.next();
                        Long l3 = (Long)hashMap4.get(l2);
                        Vector vector2 = SDMSResourceAllocationTable.idx_smeId_nrId.getVector(systemEnvironment, new SDMSKey(l, l2));
                        for (int j = 0; j < vector2.size(); ++j) {
                            SDMSResourceAllocation sDMSResourceAllocation = (SDMSResourceAllocation)vector2.get(j);
                            if (!sDMSResourceAllocation.getRId(systemEnvironment).equals(l3)) continue;
                            hashSet.add(l3);
                            bl2 = true;
                            continue block9;
                        }
                    }
                    if (!bl2) continue;
                    hashSet.add(sDMSProxy.getId(systemEnvironment));
                }
                for (Vector vector3 : hashMap2.values()) {
                    sDMSProxy = (SDMSResource)vector3.get(1);
                    hashSet.add(sDMSProxy.getId(systemEnvironment));
                }
                for (Vector vector4 : hashMap.values()) {
                    sDMSProxy = (SDMSResource)vector4.get(1);
                    hashSet.add(sDMSProxy.getId(systemEnvironment));
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 13: {
                SDMSResource sDMSResource;
                HashSet<Long> hashSet = new HashSet<Long>();
                SDMSnpSrvrSRFootprint sDMSnpSrvrSRFootprint = (SDMSnpSrvrSRFootprint)SDMSnpSrvrSRFootprintTable.idx_sId.getUnique(systemEnvironment, sDMSSubmittedEntity.getScopeId(systemEnvironment));
                HashMap hashMap5 = sDMSnpSrvrSRFootprint.getFp(systemEnvironment);
                hashSet.add(sDMSSubmittedEntity.getScopeId(systemEnvironment));
                for (Serializable serializable2 : hashMap3.keySet()) {
                    hashSet.add((Long)hashMap5.get(serializable2));
                }
                for (Serializable serializable2 : hashMap2.values()) {
                    sDMSResource = (SDMSResource)((Vector)serializable2).get(1);
                    hashSet.add(sDMSResource.getId(systemEnvironment));
                }
                for (Serializable serializable2 : hashMap.values()) {
                    sDMSResource = (SDMSResource)((Vector)serializable2).get(1);
                    hashSet.add(sDMSResource.getId(systemEnvironment));
                }
                Iterator<Object> iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    vector.add(iterator.next());
                }
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                int n3;
                Vector vector5 = SDMSResourceAllocationTable.idx_smeId.getVector(systemEnvironment, l);
                int n4 = vector5.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    vector.add(((SDMSResourceAllocation)vector5.get(n3)).getRId(systemEnvironment));
                }
                vector5 = SDMSResourceAllocationTable.idx_smeId.getVector(systemEnvironment, new Long(-l.longValue()));
                n4 = vector5.size();
                for (n3 = 0; n3 < n4; ++n3) {
                    vector.add(((SDMSResourceAllocation)vector5.get(n3)).getRId(systemEnvironment));
                }
                break;
            }
        }
        ((HierarchyLister)object).setObjectsToList(vector);
        serializable = ((HierarchyLister)object).list(systemEnvironment, false);
        return serializable;
    }

    private SDMSOutputContainer definedResources(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("RESOURCE_NAME");
        vector.add("RESOURCE_USAGE");
        vector.add("RESOURCE_OWNER");
        vector.add("RESOURCE_PRIVS");
        vector.add("RESOURCE_STATE");
        vector.add("RESOURCE_TIMESTAMP");
        vector.add("REQUESTABLE_AMOUNT");
        vector.add("TOTAL_AMOUNT");
        vector.add("FREE_AMOUNT");
        vector.add("ONLINE");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSResourceTable.idx_scopeId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSResource sDMSResource = (SDMSResource)vector2.get(i);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, sDMSResource.getNrId(systemEnvironment));
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSResource.getId(systemEnvironment));
            vector3.add(sDMSNamedResource.pathVector(systemEnvironment));
            vector3.add(sDMSNamedResource.getUsageAsString(systemEnvironment));
            vector3.add(SDMSGroupTable.getObject(systemEnvironment, sDMSResource.getOwnerId(systemEnvironment)).getName(systemEnvironment));
            vector3.add(sDMSResource.getPrivileges(systemEnvironment).toString());
            Long l2 = sDMSResource.getRsdId(systemEnvironment);
            if (l2 != null) {
                vector3.add(SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
            } else {
                vector3.add(null);
            }
            Long l3 = sDMSResource.getRsdTime(systemEnvironment);
            if (l3 != null && sDMSNamedResource.getUsage(systemEnvironment) == 4 && sDMSNamedResource.getRspId(systemEnvironment) != null) {
                long l4 = l3;
                Date date = new Date();
                date.setTime(l4);
                vector3.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector3.add(null);
            }
            vector3.add(sDMSResource.getRequestableAmount(systemEnvironment));
            vector3.add(sDMSResource.getAmount(systemEnvironment));
            vector3.add(sDMSResource.getFreeAmount(systemEnvironment));
            vector3.add(sDMSResource.getIsOnline(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }

    private SDMSOutputContainer runs(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        SDMSExitStateDefinition sDMSExitStateDefinition;
        SDMSScope sDMSScope;
        Vector<String> vector = new Vector<String>();
        vector.add("RERUN_SEQ");
        vector.add("SCOPE_ID");
        vector.add("HTTPHOST");
        vector.add("HTTPPORT");
        vector.add("JOB_ESD_ID");
        vector.add("EXIT_CODE");
        vector.add("COMMANDLINE");
        vector.add("WORKDIR");
        vector.add("LOGFILE");
        vector.add("ERRLOGFILE");
        vector.add("EXT_PID");
        vector.add("SYNC_TS");
        vector.add("RESOURCE_TS");
        vector.add("RUNNABLE_TS");
        vector.add("START_TS");
        vector.add("FINISH_TS");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Date date = new Date();
        Vector<Object> vector2 = new Vector<Object>();
        int n = sDMSSubmittedEntity.getRerunSeq(systemEnvironment);
        vector2.add(new Integer(n));
        Long l = sDMSSubmittedEntity.getScopeId(systemEnvironment);
        if (l != null) {
            try {
                sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
                vector2.add(sDMSScope.pathVector(systemEnvironment));
                vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPHOST"));
                vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPPORT"));
            }
            catch (NotFoundException notFoundException) {
                vector2.add("Scope deleted");
                vector2.add(null);
                vector2.add(null);
            }
        } else {
            vector2.add(null);
            vector2.add(null);
            vector2.add(null);
        }
        Long l2 = sDMSSubmittedEntity.getJobEsdId(systemEnvironment);
        if (l2 != null) {
            sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2, this.actVersion);
            vector2.add(sDMSExitStateDefinition.getName(systemEnvironment));
        } else {
            vector2.add(null);
        }
        vector2.add(sDMSSubmittedEntity.getExitCode(systemEnvironment));
        if (n == 0) {
            vector2.add(sDMSSubmittedEntity.getCommandline(systemEnvironment));
        } else {
            vector2.add(sDMSSubmittedEntity.getRrCommandline(systemEnvironment));
        }
        vector2.add(sDMSSubmittedEntity.getWorkdir(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getLogfile(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getErrlogfile(systemEnvironment));
        vector2.add(sDMSSubmittedEntity.getExtPid(systemEnvironment));
        Long l3 = sDMSSubmittedEntity.getSyncTs(systemEnvironment);
        if (l3 != null) {
            date.setTime(l3);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l3 = sDMSSubmittedEntity.getResourceTs(systemEnvironment);
        if (l3 != null) {
            date.setTime(l3);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l3 = sDMSSubmittedEntity.getRunnableTs(systemEnvironment);
        if (l3 != null) {
            date.setTime(l3);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l3 = sDMSSubmittedEntity.getStartTs(systemEnvironment);
        if (l3 != null) {
            date.setTime(l3);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        l3 = sDMSSubmittedEntity.getFinishTs(systemEnvironment);
        if (l3 != null) {
            date.setTime(l3);
            vector2.add(systemEnvironment.systemDateFormat.format(date));
        } else {
            vector2.add(null);
        }
        sDMSOutputContainer.addData(systemEnvironment, vector2);
        Vector vector3 = SDMSSubmittedEntityStatsTable.idx_smeId.getVector(systemEnvironment, sDMSSubmittedEntity.getId(systemEnvironment));
        for (int i = 0; i < vector3.size(); ++i) {
            SDMSSubmittedEntityStats sDMSSubmittedEntityStats = (SDMSSubmittedEntityStats)vector3.get(i);
            vector2 = new Vector();
            n = sDMSSubmittedEntityStats.getRerunSeq(systemEnvironment);
            vector2.add(new Integer(n));
            l = sDMSSubmittedEntityStats.getScopeId(systemEnvironment);
            if (l != null) {
                try {
                    sDMSScope = SDMSScopeTable.getObject(systemEnvironment, l);
                    vector2.add(sDMSScope.pathVector(systemEnvironment));
                    vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPHOST"));
                    vector2.add(ScopeConfig.getItem(systemEnvironment, sDMSScope, "HTTPPORT"));
                }
                catch (NotFoundException notFoundException) {
                    vector2.add("Scope deleted");
                    vector2.add(null);
                    vector2.add(null);
                }
            } else {
                vector2.add(null);
                vector2.add(null);
                vector2.add(null);
            }
            l2 = sDMSSubmittedEntityStats.getJobEsdId(systemEnvironment);
            if (l2 != null) {
                sDMSExitStateDefinition = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2, this.actVersion);
                vector2.add(sDMSExitStateDefinition.getName(systemEnvironment));
            } else {
                vector2.add(null);
            }
            vector2.add(sDMSSubmittedEntityStats.getExitCode(systemEnvironment));
            vector2.add(sDMSSubmittedEntityStats.getCommandline(systemEnvironment));
            vector2.add(sDMSSubmittedEntityStats.getWorkdir(systemEnvironment));
            vector2.add(sDMSSubmittedEntityStats.getLogfile(systemEnvironment));
            vector2.add(sDMSSubmittedEntityStats.getErrlogfile(systemEnvironment));
            vector2.add(sDMSSubmittedEntityStats.getExtPid(systemEnvironment));
            l3 = sDMSSubmittedEntityStats.getSyncTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector2.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector2.add(null);
            }
            l3 = sDMSSubmittedEntityStats.getResourceTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector2.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector2.add(null);
            }
            l3 = sDMSSubmittedEntityStats.getRunnableTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector2.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector2.add(null);
            }
            l3 = sDMSSubmittedEntityStats.getStartTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector2.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector2.add(null);
            }
            l3 = sDMSSubmittedEntityStats.getFinishTs(systemEnvironment);
            if (l3 != null) {
                date.setTime(l3);
                vector2.add(systemEnvironment.systemDateFormat.format(date));
            } else {
                vector2.add(null);
            }
            sDMSOutputContainer.addData(systemEnvironment, vector2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 0));
        return sDMSOutputContainer;
    }

    private void auditContainerRenderSme(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity, SDMSOutputContainer sDMSOutputContainer, Vector vector, Boolean bl) throws SDMSException {
        Long l = sDMSSubmittedEntity.getId(systemEnvironment);
        Vector vector2 = SDMSAuditTrailTable.idx_objectId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSAuditTrail sDMSAuditTrail = (SDMSAuditTrail)vector2.get(i);
            if (vector != null && !vector.contains(sDMSAuditTrail.getAction(systemEnvironment))) continue;
            Vector<Object> vector3 = new Vector<Object>();
            vector3.add(sDMSAuditTrail.getId(systemEnvironment));
            Long l2 = sDMSAuditTrail.getUserId(systemEnvironment);
            if (l2.equals(sDMSSubmittedEntity.getId(systemEnvironment))) {
                vector3.add("SELF");
            } else {
                try {
                    try {
                        vector3.add(SDMSUserTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
                    }
                    catch (NotFoundException notFoundException) {
                        vector3.add(SDMSScopeTable.getObject(systemEnvironment, l2).pathString(systemEnvironment));
                    }
                }
                catch (NotFoundException notFoundException) {
                    vector3.add("unknown");
                }
            }
            vector3.add(sDMSAuditTrail.getTs(systemEnvironment));
            vector3.add(sDMSAuditTrail.getTxId(systemEnvironment));
            vector3.add(sDMSAuditTrail.getActionAsString(systemEnvironment));
            try {
                SDMSSubmittedEntity sDMSSubmittedEntity2 = SDMSSubmittedEntityTable.getObject(systemEnvironment, sDMSAuditTrail.getOriginId(systemEnvironment));
                vector3.add(sDMSSubmittedEntity2.getSubmitPathString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                vector3.add(sDMSAuditTrail.getOriginId(systemEnvironment));
            }
            vector3.add(l);
            vector3.add(SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSSubmittedEntity.getSeId(systemEnvironment), sDMSSubmittedEntity.getSeVersion(systemEnvironment)).pathString(systemEnvironment, sDMSSubmittedEntity.getSeVersion(systemEnvironment)));
            vector3.add(sDMSAuditTrail.getActionComment(systemEnvironment));
            vector3.add(sDMSAuditTrail.getActionInfo(systemEnvironment));
            sDMSOutputContainer.addData(systemEnvironment, vector3);
        }
        if (bl.booleanValue()) {
            Vector vector4 = SDMSSubmittedEntityTable.idx_parentId.getVector(systemEnvironment, l);
            for (int i = 0; i < vector4.size(); ++i) {
                this.auditContainerRenderSme(systemEnvironment, (SDMSSubmittedEntity)vector4.get(i), sDMSOutputContainer, vector, bl);
            }
        }
    }

    private SDMSOutputContainer auditContainer(SystemEnvironment systemEnvironment, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Date date = new Date();
        Vector<String> vector = new Vector<String>();
        vector.add("ID");
        vector.add("USERNAME");
        vector.add("TIME");
        vector.add("TXID");
        vector.add("ACTION");
        vector.add("ORIGINID");
        vector.add("JOBID");
        vector.add("JOBNAME");
        vector.add("COMMENT");
        vector.add("INFO");
        Vector vector2 = null;
        Boolean bl = null;
        if (this.with != null) {
            vector2 = (Vector)this.with.get("FILTER");
            bl = (Boolean)this.with.get("RECURSIVE");
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        this.auditContainerRenderSme(systemEnvironment, sDMSSubmittedEntity, sDMSOutputContainer, vector2, bl);
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, auditSortCols));
        for (int i = 0; i < sDMSOutputContainer.dataset.size(); ++i) {
            Vector vector3 = (Vector)sDMSOutputContainer.dataset.get(i);
            date.setTime((Long)vector3.get(2));
            vector3.set(2, systemEnvironment.systemDateFormat.format(date));
            sDMSOutputContainer.setWidth(systemEnvironment, 2, systemEnvironment.systemDateFormat.format(date).toString().length());
        }
        return sDMSOutputContainer;
    }
}

