/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.parser.dumpClasses;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.parser.dumpClasses.DumpESD;
import de.independit.scheduler.server.parser.dumpClasses.DumpGroup;
import de.independit.scheduler.server.parser.dumpClasses.DumpLine;
import de.independit.scheduler.server.parser.dumpClasses.DumpNR;
import de.independit.scheduler.server.parser.dumpClasses.DumpOM;
import de.independit.scheduler.server.parser.dumpClasses.DumpR;
import de.independit.scheduler.server.parser.dumpClasses.DumpRSD;
import de.independit.scheduler.server.parser.dumpClasses.DumpSE;
import de.independit.scheduler.server.parser.dumpClasses.Dumper;
import de.independit.scheduler.server.repository.SDMSExitStateDefinition;
import de.independit.scheduler.server.repository.SDMSExitStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSGroup;
import de.independit.scheduler.server.repository.SDMSGroupTable;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSResource;
import de.independit.scheduler.server.repository.SDMSResourceStateDefinitionTable;
import de.independit.scheduler.server.repository.SDMSResourceTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSTrigger;
import de.independit.scheduler.server.repository.SDMSTriggerParameter;
import de.independit.scheduler.server.repository.SDMSTriggerParameterTable;
import de.independit.scheduler.server.repository.SDMSTriggerState;
import de.independit.scheduler.server.repository.SDMSTriggerStateTable;
import java.util.HashMap;
import java.util.Vector;

public class DumpTR
extends Dumper {
    static boolean isRerun = false;
    static boolean isInverse = false;

    public static String getDumpedURL(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, HashMap hashMap) throws SDMSException {
        return "trigger " + DumpTR.getDumpedName(systemEnvironment, sDMSTrigger, hashMap);
    }

    public static String getDumpedName(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, HashMap hashMap) throws SDMSException {
        String string = DumpTR.quotedName(sDMSTrigger.getName(systemEnvironment));
        int n = sDMSTrigger.getObjectType(systemEnvironment);
        isInverse = sDMSTrigger.getIsInverse(systemEnvironment);
        Long l = isInverse ? sDMSTrigger.getSeId(systemEnvironment) : sDMSTrigger.getFireId(systemEnvironment);
        switch (n) {
            case 0: {
                SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l);
                string = string + " on job definition " + DumpSE.getDumpedName(systemEnvironment, sDMSSchedulingEntity, hashMap);
                break;
            }
            case 2: {
                SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l);
                string = string + " on named resource " + DumpNR.getDumpedName(systemEnvironment, sDMSNamedResource, hashMap);
                break;
            }
            case 1: {
                SDMSResource sDMSResource = SDMSResourceTable.getObject(systemEnvironment, l);
                string = string + " on resource " + DumpR.getDumpedName(systemEnvironment, sDMSResource, hashMap);
                break;
            }
            case 3: {
                SDMSObjectMonitor sDMSObjectMonitor = SDMSObjectMonitorTable.getObject(systemEnvironment, l);
                string = string + " on object monitor " + DumpOM.getDumpedName(systemEnvironment, sDMSObjectMonitor, hashMap);
            }
        }
        if (isInverse) {
            string = string + " inverse";
        }
        return string;
    }

    private static String getCheckKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        String string = null;
        Integer n = sDMSTrigger.getCheckAmount(systemEnvironment);
        if (n != null) {
            string = "\tcheck = " + n.toString() + " " + sDMSTrigger.getCheckBaseAsString(systemEnvironment);
        }
        return string;
    }

    private static String getStateKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, boolean bl, HashMap hashMap) throws SDMSException {
        String string = "state = ";
        Vector vector = SDMSTriggerStateTable.idx_triggerId.getSortedVector(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
        if (vector.size() == 0) {
            string = string + "none";
        } else {
            string = string + "(\n\t\t";
            String string2 = "";
            for (int i = 0; i < vector.size(); ++i) {
                Comparable<Long> comparable;
                Long l;
                SDMSTriggerState sDMSTriggerState = (SDMSTriggerState)vector.get(i);
                if (bl) {
                    l = sDMSTriggerState.getFromStateId(systemEnvironment);
                    comparable = sDMSTriggerState.getToStateId(systemEnvironment);
                    String string3 = l == null ? "any" : DumpRSD.getDumpedName(systemEnvironment, SDMSResourceStateDefinitionTable.getObject(systemEnvironment, l), hashMap);
                    String string4 = comparable == null ? "any" : DumpRSD.getDumpedName(systemEnvironment, SDMSResourceStateDefinitionTable.getObject(systemEnvironment, comparable), hashMap);
                    string = string + string2 + string3 + " " + string4;
                } else {
                    l = sDMSTriggerState.getToStateId(systemEnvironment);
                    comparable = SDMSExitStateDefinitionTable.getObject(systemEnvironment, l);
                    string = string + string2 + DumpESD.getDumpedName(systemEnvironment, (SDMSExitStateDefinition)comparable, hashMap);
                }
                string2 = ",\n\t\t";
            }
            string = string + "\n\t)";
        }
        return string;
    }

    private static String getParameterKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        String string = "parameters = ";
        Vector vector = SDMSTriggerParameterTable.idx_triggerId.getSortedVector(systemEnvironment, sDMSTrigger.getId(systemEnvironment));
        if (vector.size() == 0) {
            string = string + "none";
        } else {
            string = string + "(\n\t\t";
            String string2 = "";
            for (int i = 0; i < vector.size(); ++i) {
                SDMSTriggerParameter sDMSTriggerParameter = (SDMSTriggerParameter)vector.get(i);
                String string3 = DumpTR.quotedName(sDMSTriggerParameter.getName(systemEnvironment));
                String string4 = DumpTR.quotedString(sDMSTriggerParameter.getExpression(systemEnvironment));
                string = string + string2 + string3 + " = " + string4;
                string2 = ",\n\t\t";
            }
            string = string + "\n\t)";
        }
        return string;
    }

    private static String getResumeKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        String string = null;
        String string2 = sDMSTrigger.getResumeAt(systemEnvironment);
        Integer n = sDMSTrigger.getResumeIn(systemEnvironment);
        String string3 = sDMSTrigger.getResumeBaseAsString(systemEnvironment);
        if (string2 != null) {
            string = "resume at '" + string2 + "'";
        } else if (n != null) {
            string = "resume in " + n + " " + string3;
        }
        return string;
    }

    private static String getMainSeKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, HashMap hashMap) throws SDMSException {
        Long l = sDMSTrigger.getMainSeId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return "main " + DumpSE.getDumpedName(systemEnvironment, SDMSSchedulingEntityTable.getObject(systemEnvironment, l), hashMap);
    }

    private static String getParentSeKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, HashMap hashMap) throws SDMSException {
        Long l = sDMSTrigger.getParentSeId(systemEnvironment);
        if (l == null) {
            return null;
        }
        return "parent " + DumpSE.getDumpedName(systemEnvironment, SDMSSchedulingEntityTable.getObject(systemEnvironment, l), hashMap);
    }

    private static String getAction(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, HashMap hashMap) throws SDMSException {
        String string;
        if (sDMSTrigger.getAction(systemEnvironment) == 0) {
            string = isInverse ? "submit after " + DumpSE.getDumpedName(systemEnvironment, SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSTrigger.getFireId(systemEnvironment)), hashMap) : "submit " + DumpSE.getDumpedName(systemEnvironment, SDMSSchedulingEntityTable.getObject(systemEnvironment, sDMSTrigger.getSeId(systemEnvironment)), hashMap);
            isRerun = false;
        } else {
            string = "rerun";
            isRerun = true;
        }
        return string;
    }

    private static String getEventKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        String string = "events = (";
        String string2 = "";
        String string3 = ", ";
        if (sDMSTrigger.getIsCreate(systemEnvironment).booleanValue()) {
            string = string + "create";
            string2 = string3;
        }
        if (sDMSTrigger.getIsChange(systemEnvironment).booleanValue()) {
            string = string + string2 + "change";
            string2 = string3;
        }
        if (sDMSTrigger.getIsDelete(systemEnvironment).booleanValue()) {
            string = string + string2 + "delete";
            string2 = string3;
        }
        string = string + ")";
        return string;
    }

    private static String getEventGroupKlausel(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger) throws SDMSException {
        return sDMSTrigger.getIsGroup(systemEnvironment) != false ? "group event" : "single event";
    }

    public static Vector dump(SystemEnvironment systemEnvironment, SDMSTrigger sDMSTrigger, Vector vector, HashMap hashMap) throws SDMSException {
        String string;
        Vector<DumpLine> vector2 = new Vector<DumpLine>();
        String string2 = DumpTR.getDumpedURL(systemEnvironment, sDMSTrigger, hashMap);
        Long l = sDMSTrigger.getSubmitOwnerId(systemEnvironment);
        isInverse = sDMSTrigger.getIsInverse(systemEnvironment);
        SDMSGroup sDMSGroup = null;
        int n = sDMSTrigger.getObjectType(systemEnvironment);
        if (l != null && sDMSTrigger.getIsMaster(systemEnvironment).booleanValue()) {
            sDMSGroup = SDMSGroupTable.getObject(systemEnvironment, l);
        }
        string = (string = sDMSTrigger.getCondition(systemEnvironment)) == null ? "none" : DumpTR.quotedString(string);
        String string3 = sDMSTrigger.getIsWarnOnLimit(systemEnvironment) != false ? "warn" : "nowarn";
        String string4 = null;
        Long l2 = sDMSTrigger.getLimitState(systemEnvironment);
        if (l2 != null) {
            string4 = DumpTR.quotedString(SDMSExitStateDefinitionTable.getObject(systemEnvironment, l2).getName(systemEnvironment));
        }
        String string5 = sDMSTrigger.getIsSuspend(systemEnvironment) != false ? "suspend" : "nosuspend";
        String string6 = DumpTR.getResumeKlausel(systemEnvironment, sDMSTrigger);
        String string7 = sDMSTrigger.getIsMaster(systemEnvironment) != false ? "master" : "nomaster";
        String string8 = DumpTR.getCheckKlausel(systemEnvironment, sDMSTrigger);
        String string9 = DumpTR.getStateKlausel(systemEnvironment, sDMSTrigger, n != 0 && n != 3, hashMap);
        String string10 = string3;
        String string11 = null;
        if (SystemEnvironment.dumpLangLevel >= 1 || string4 != null) {
            if (string4 == null) {
                string4 = "none";
            }
            string11 = "limit state = " + string4;
        }
        String string12 = "condition = " + string;
        String string13 = "type = " + sDMSTrigger.getTypeAsString(systemEnvironment);
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = null;
        if (n == 3) {
            string16 = DumpTR.getEventKlausel(systemEnvironment, sDMSTrigger);
            string17 = DumpTR.getEventGroupKlausel(systemEnvironment, sDMSTrigger);
            string14 = DumpTR.getMainSeKlausel(systemEnvironment, sDMSTrigger, hashMap);
            string15 = DumpTR.getParentSeKlausel(systemEnvironment, sDMSTrigger, hashMap);
            string9 = null;
            string8 = null;
            string10 = null;
            string12 = null;
            string13 = null;
        }
        String string18 = DumpTR.getParameterKlausel(systemEnvironment, sDMSTrigger);
        String string19 = DumpTR.getAction(systemEnvironment, sDMSTrigger, hashMap);
        String string20 = "create or alter " + string2 + "\nwith\n" + (sDMSGroup == null ? "" : "\tgroup = " + DumpGroup.getDumpedName(systemEnvironment, sDMSGroup, hashMap) + ",\n") + (sDMSTrigger.getIsActive(systemEnvironment) != false ? "\tactive" : "\tinactive") + ",\n" + (string8 == null ? "" : string8 + ",\n") + (string12 == null ? "" : "\t" + string12 + ",\n") + (isRerun ? "" : "\t" + string7 + ",\n") + (string10 == null ? "" : "\t" + string10 + ",\n") + (string11 == null ? "" : "\t" + string11 + ",\n") + "\t" + string5 + ",\n" + (string6 == null ? "" : "\t" + string6 + ",\n") + (string9 == null ? "" : "\t" + string9 + ",\n") + (string16 == null ? "" : "\t" + string16 + ",\n") + (string17 == null ? "" : "\t" + string17 + ",\n") + (string14 == null ? "" : "\t" + string14 + ",\n") + (string15 == null ? "" : "\t" + string15 + ",\n") + (n == 0 ? "\tsubmitcount = " + sDMSTrigger.getMaxRetry(systemEnvironment) + ",\n" : "") + "\t" + string19 + (string13 == null ? "" : ",\n\t" + string13 + ",\n") + string18 + ";\n\n";
        if (n == 2) {
            string20 = "/* WARNING! NEEDS TO BE CONVERTED TO PLAIN RESOURCE TRIGGERS!\n" + string20 + "*/\n\n";
        }
        vector2.add(new DumpLine(50, string20));
        vector.add(string2);
        return vector2;
    }
}

