/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSAuditTrailGeneric
extends SDMSObject
implements Cloneable {
    public static final int ENVIRONMENT = 1;
    public static final int EVENT = 18;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int GROUP = 21;
    public static final int INTERVAL = 19;
    public static final int JOB = 17;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCHEDULE = 20;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int USER = 8;
    public static final int RERUN = 1;
    public static final int RERUN_RECURSIVE = 2;
    public static final int CANCEL = 3;
    public static final int SUSPEND = 4;
    public static final int RESUME = 5;
    public static final int SET_STATE = 6;
    public static final int SET_EXIT_STATE = 7;
    public static final int IGNORE_DEPENDENCY = 8;
    public static final int IGNORE_DEP_RECURSIVE = 9;
    public static final int IGNORE_RESOURCE = 10;
    public static final int KILL = 11;
    public static final int ALTER_RUN_PROGRAM = 12;
    public static final int ALTER_RERUN_PROGRAM = 13;
    public static final int COMMENT_JOB = 14;
    public static final int SUBMITTED = 15;
    public static final int TRIGGER_FAILED = 16;
    public static final int TRIGGER_SUBMIT = 17;
    public static final int JOB_RESTARTABLE = 18;
    public static final int CHANGE_PRIORITY = 19;
    public static final int RENICE = 20;
    public static final int SUBMIT_SUSPENDED = 21;
    public static final int IGNORE_NAMED_RESOURCE = 22;
    public static final int TIMEOUT = 23;
    public static final int SET_RESOURCE_STATE = 24;
    public static final int JOB_IN_ERROR = 25;
    public static final int CLEAR_WARNING = 26;
    public static final int SET_WARNING = 27;
    public static final int JOB_UNREACHABLE = 28;
    public static final int SET_PARAMETERS = 29;
    public static final int DISABLE = 30;
    public static final int ENABLE = 31;
    public static final int CLONE = 32;
    public static final int nr_id = 1;
    public static final int nr_userId = 2;
    public static final int nr_ts = 3;
    public static final int nr_txId = 4;
    public static final int nr_action = 5;
    public static final int nr_objectType = 6;
    public static final int nr_objectId = 7;
    public static final int nr_originId = 8;
    public static final int nr_isSetWarning = 9;
    public static final int nr_actionInfo = 10;
    public static final int nr_actionComment = 11;
    public static final int nr_creatorUId = 12;
    public static final int nr_createTs = 13;
    public static final int nr_changerUId = 14;
    public static final int nr_changeTs = 15;
    public static String tableName = "AUDIT_TRAIL";
    protected Long userId;
    protected Long ts;
    protected Long txId;
    protected Integer action;
    protected Integer objectType;
    protected Long objectId;
    protected Long originId;
    protected Boolean isSetWarning;
    protected String actionInfo;
    protected String actionComment;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSAuditTrailGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Long l4, Long l5, Boolean bl, String string, String string2, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        super(systemEnvironment, SDMSAuditTrailTableGeneric.table);
        this.userId = l;
        this.ts = l2;
        this.txId = l3;
        this.action = n;
        this.objectType = n2;
        this.objectId = l4;
        this.originId = l5;
        this.isSetWarning = bl;
        if (string != null && string.length() > 1024) {
            string = string.substring(0, 1024);
        }
        this.actionInfo = string;
        if (string2 != null && string2.length() > 1024) {
            string2 = string2.substring(0, 1024);
        }
        this.actionComment = string2;
        this.creatorUId = l6;
        this.createTs = l7;
        this.changerUId = l8;
        this.changeTs = l9;
    }

    public Long getUserId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.userId;
    }

    public void setUserId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.userId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
            }
            SDMSAuditTrailGeneric sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
            sDMSAuditTrailGeneric.userId = l;
            sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ts;
    }

    public void setTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ts.equals(l)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.ts = l;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getTxId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.txId;
    }

    public void setTxId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.txId.equals(l)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.txId = l;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Integer getAction(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.action;
    }

    public String getActionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAction(systemEnvironment);
        switch (n) {
            case 1: {
                return "RERUN";
            }
            case 2: {
                return "RERUN_RECURSIVE";
            }
            case 3: {
                return "CANCEL";
            }
            case 4: {
                return "SUSPEND";
            }
            case 5: {
                return "RESUME";
            }
            case 6: {
                return "SET_STATE";
            }
            case 7: {
                return "SET_EXIT_STATE";
            }
            case 8: {
                return "IGNORE_DEPENDENCY";
            }
            case 9: {
                return "IGNORE_DEP_RECURSIVE";
            }
            case 10: {
                return "IGNORE_RESOURCE";
            }
            case 11: {
                return "KILL";
            }
            case 12: {
                return "ALTER_RUN_PROGRAM";
            }
            case 13: {
                return "ALTER_RERUN_PROGRAM";
            }
            case 14: {
                return "COMMENT_JOB";
            }
            case 15: {
                return "SUBMITTED";
            }
            case 16: {
                return "TRIGGER_FAILED";
            }
            case 17: {
                return "TRIGGER_SUBMIT";
            }
            case 18: {
                return "JOB_RESTARTABLE";
            }
            case 19: {
                return "CHANGE_PRIORITY";
            }
            case 20: {
                return "RENICE";
            }
            case 21: {
                return "SUBMIT_SUSPENDED";
            }
            case 22: {
                return "IGNORE_NAMED_RESOURCE";
            }
            case 23: {
                return "TIMEOUT";
            }
            case 24: {
                return "SET_RESOURCE_STATE";
            }
            case 25: {
                return "JOB_IN_ERROR";
            }
            case 26: {
                return "CLEAR_WARNING";
            }
            case 27: {
                return "SET_WARNING";
            }
            case 28: {
                return "JOB_UNREACHABLE";
            }
            case 29: {
                return "SET_PARAMETERS";
            }
            case 30: {
                return "DISABLE";
            }
            case 31: {
                return "ENABLE";
            }
            case 32: {
                return "CLONE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown AuditTrail.action: $1", (Object)this.getAction(systemEnvironment)));
    }

    public void setAction(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.action.equals(n)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.action = n;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Integer getObjectType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectType;
    }

    public String getObjectTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getObjectType(systemEnvironment);
        switch (n) {
            case 17: {
                return "JOB";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown AuditTrail.objectType: $1", (Object)this.getObjectType(systemEnvironment)));
    }

    public void setObjectType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.objectType.equals(n)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.objectType = n;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getObjectId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objectId;
    }

    public void setObjectId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.objectId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
            }
            SDMSAuditTrailGeneric sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
            sDMSAuditTrailGeneric.objectId = l;
            sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOriginId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.originId;
    }

    public void setOriginId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.originId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
            }
            SDMSAuditTrailGeneric sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
            sDMSAuditTrailGeneric.originId = l;
            sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Boolean getIsSetWarning(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isSetWarning;
    }

    public void setIsSetWarning(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isSetWarning.equals(bl)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.isSetWarning = bl;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public String getActionInfo(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.actionInfo;
    }

    public void setActionInfo(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.actionInfo)) {
            return;
        }
        if (string == null && this.actionInfo == null) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            string = string.substring(0, 1024);
        }
        sDMSAuditTrailGeneric.actionInfo = string;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public String getActionComment(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.actionComment;
    }

    public void setActionComment(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.actionComment)) {
            return;
        }
        if (string == null && this.actionComment == null) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 1024) {
            string = string.substring(0, 1024);
        }
        sDMSAuditTrailGeneric.actionComment = string;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.creatorUId = l;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(AuditTrail) Change of system object not allowed"));
        }
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.createTs = l;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.changerUId = l;
        sDMSAuditTrailGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = this;
        if (sDMSAuditTrailGeneric.versions.o_v == null || sDMSAuditTrailGeneric.versions.o_v.size() == 0 || sDMSAuditTrailGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSAuditTrailGeneric = (SDMSAuditTrailGeneric)this.change(systemEnvironment);
        }
        sDMSAuditTrailGeneric.changeTs = l;
        sDMSAuditTrailGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSAuditTrailGeneric != this) {
            sDMSAuditTrailGeneric.versions.table.index(systemEnvironment, sDMSAuditTrailGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSAuditTrail(this);
    }

    protected SDMSAuditTrailGeneric(Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Long l5, Long l6, Boolean bl, String string, String string2, Long l7, Long l8, Long l9, Long l10, long l11, long l12) {
        this.id = l;
        this.userId = l2;
        this.ts = l3;
        this.txId = l4;
        this.action = n;
        this.objectType = n2;
        this.objectId = l5;
        this.originId = l6;
        this.isSetWarning = bl;
        this.actionInfo = string;
        this.actionComment = string2;
        this.creatorUId = l7;
        this.createTs = l8;
        this.changerUId = l9;
        this.changeTs = l10;
        this.validFrom = l11;
        this.validTo = l12;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "AUDIT_TRAIL" + string3 + " (" + "ID" + ", " + string2 + "USER_ID" + string3 + ", " + string2 + "TS" + string3 + ", " + string2 + "TXID" + string3 + ", " + string2 + "ACTION" + string3 + ", " + string2 + "OBJECT_TYPE" + string3 + ", " + string2 + "OBJECT_ID" + string3 + ", " + string2 + "ORIGIN_ID" + string3 + ", " + string2 + "IS_SET_WARNING" + string3 + ", " + string2 + "ACTION_INFO" + string3 + ", " + string2 + "ACTION_COMMENT" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSAuditTrailGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "AuditTrail: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.userId);
            preparedStatement.setLong(3, this.ts);
            preparedStatement.setLong(4, this.txId);
            preparedStatement.setInt(5, this.action);
            preparedStatement.setInt(6, this.objectType);
            preparedStatement.setLong(7, this.objectId);
            preparedStatement.setLong(8, this.originId);
            preparedStatement.setInt(9, this.isSetWarning != false ? 1 : 0);
            if (this.actionInfo == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.actionInfo);
            }
            if (this.actionComment == null) {
                preparedStatement.setNull(11, 12);
            } else {
                preparedStatement.setString(11, this.actionComment);
            }
            preparedStatement.setLong(12, this.creatorUId);
            preparedStatement.setLong(13, this.createTs);
            preparedStatement.setLong(14, this.changerUId);
            preparedStatement.setLong(15, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "AuditTrail: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "AUDIT_TRAIL" + string3 + " WHERE ID = ?";
                SDMSAuditTrailGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "AuditTrail: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "AuditTrail: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "AUDIT_TRAIL" + string3 + " SET " + "" + string2 + "USER_ID" + string3 + " = ? " + ", " + string2 + "TS" + string3 + " = ? " + ", " + string2 + "TXID" + string3 + " = ? " + ", " + string2 + "ACTION" + string3 + " = ? " + ", " + string2 + "OBJECT_TYPE" + string3 + " = ? " + ", " + string2 + "OBJECT_ID" + string3 + " = ? " + ", " + string2 + "ORIGIN_ID" + string3 + " = ? " + ", " + string2 + "IS_SET_WARNING" + string3 + " = ? " + ", " + string2 + "ACTION_INFO" + string3 + " = ? " + ", " + string2 + "ACTION_COMMENT" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSAuditTrailGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "AuditTrail: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.userId);
            preparedStatement.setLong(2, this.ts);
            preparedStatement.setLong(3, this.txId);
            preparedStatement.setInt(4, this.action);
            preparedStatement.setInt(5, this.objectType);
            preparedStatement.setLong(6, this.objectId);
            preparedStatement.setLong(7, this.originId);
            preparedStatement.setInt(8, this.isSetWarning != false ? 1 : 0);
            if (this.actionInfo == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.actionInfo);
            }
            if (this.actionComment == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.actionComment);
            }
            preparedStatement.setLong(11, this.creatorUId);
            preparedStatement.setLong(12, this.createTs);
            preparedStatement.setLong(13, this.changerUId);
            preparedStatement.setLong(14, this.changeTs);
            preparedStatement.setLong(15, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "AuditTrail: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkAction(Integer n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkObjectType(Integer n) {
        switch (n) {
            case 17: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : AuditTrail", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "userId : " + this.userId, 2);
        SDMSThread.doTrace(null, "ts : " + this.ts, 2);
        SDMSThread.doTrace(null, "txId : " + this.txId, 2);
        SDMSThread.doTrace(null, "action : " + this.action, 2);
        SDMSThread.doTrace(null, "objectType : " + this.objectType, 2);
        SDMSThread.doTrace(null, "objectId : " + this.objectId, 2);
        SDMSThread.doTrace(null, "originId : " + this.originId, 2);
        SDMSThread.doTrace(null, "isSetWarning : " + this.isSetWarning, 2);
        SDMSThread.doTrace(null, "actionInfo : " + this.actionInfo, 2);
        SDMSThread.doTrace(null, "actionComment : " + this.actionComment, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "userId        : " + this.userId + "\n" + string + "ts            : " + this.ts + "\n" + string + "txId          : " + this.txId + "\n" + string + "action        : " + this.action + "\n" + string + "objectType    : " + this.objectType + "\n" + string + "objectId      : " + this.objectId + "\n" + string + "originId      : " + this.originId + "\n" + string + "isSetWarning  : " + this.isSetWarning + "\n" + string + "actionInfo    : " + this.actionInfo + "\n" + string + "actionComment : " + this.actionComment + "\n" + string + "creatorUId    : " + this.creatorUId + "\n" + string + "createTs      : " + this.createTs + "\n" + string + "changerUId    : " + this.changerUId + "\n" + string + "changeTs      : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

