/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSAuditTrail;
import de.independit.scheduler.server.repository.SDMSAuditTrailGeneric;
import de.independit.scheduler.server.repository.SDMSAuditTrailTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSAuditTrailTableGeneric
extends SDMSTable {
    public static final String tableName = "AUDIT_TRAIL";
    public static SDMSAuditTrailTable table = null;
    public static final String[] columnNames = new String[]{"ID", "USER_ID", "TS", "TXID", "ACTION", "OBJECT_TYPE", "OBJECT_ID", "ORIGIN_ID", "IS_SET_WARNING", "ACTION_INFO", "ACTION_COMMENT", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_userId;
    public static SDMSIndex idx_objectId;
    public static SDMSIndex idx_originId;

    public SDMSAuditTrailTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "AuditTrail"));
        }
        table = (SDMSAuditTrailTable)this;
        table = (SDMSAuditTrailTable)this;
        this.isVersioned = false;
        idx_userId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "userId");
        idx_objectId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "objectId");
        idx_originId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "originId");
    }

    public SDMSAuditTrail create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Long l4, Long l5, Boolean bl, String string, String string2) throws SDMSException {
        SDMSAuditTrail sDMSAuditTrail;
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        Long l8 = systemEnvironment.cEnv.uid();
        Long l9 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "AuditTrail"));
        }
        this.validate(systemEnvironment, l, l2, l3, n, n2, l4, l5, bl, string, string2, l6, l7, l8, l9);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSAuditTrailGeneric sDMSAuditTrailGeneric = new SDMSAuditTrailGeneric(systemEnvironment, l, l2, l3, n, n2, l4, l5, bl, string, string2, l6, l7, l8, l9);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSAuditTrailGeneric.versions, true);
            table.put(systemEnvironment, sDMSAuditTrailGeneric.id, sDMSAuditTrailGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSAuditTrail = (SDMSAuditTrail)sDMSAuditTrailGeneric.toProxy(systemEnvironment);
            sDMSAuditTrail.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSAuditTrail sDMSAuditTrail2 = (SDMSAuditTrail)sDMSAuditTrailGeneric.toProxy(systemEnvironment);
            sDMSAuditTrail2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSAuditTrail)) {
            throw new AccessViolationException(sDMSAuditTrail.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSAuditTrail.touchMaster(systemEnvironment);
        return sDMSAuditTrail;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSAuditTrail sDMSAuditTrail) throws SDMSException {
        return sDMSAuditTrail.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Integer n, Integer n2, Long l4, Long l5, Boolean bl, String string, String string2, Long l6, Long l7, Long l8, Long l9) throws SDMSException {
        if (!SDMSAuditTrailGeneric.checkAction(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "AuditTrail: $1 $2", (Object)"action", (Object)n));
        }
        if (!SDMSAuditTrailGeneric.checkObjectType(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "AuditTrail: $1 $2", (Object)"objectType", (Object)n2));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        String string2;
        Boolean bl;
        Long l7;
        Long l8;
        Integer n;
        Integer n2;
        Long l9;
        Long l10;
        Long l11;
        Long l12;
        try {
            l12 = new Long(resultSet.getLong(1));
            l11 = new Long(resultSet.getLong(2));
            l10 = new Long(resultSet.getLong(3));
            l9 = new Long(resultSet.getLong(4));
            n2 = new Integer(resultSet.getInt(5));
            n = new Integer(resultSet.getInt(6));
            l8 = new Long(resultSet.getLong(7));
            l7 = new Long(resultSet.getLong(8));
            bl = new Boolean(resultSet.getInt(9) != 0);
            string2 = resultSet.getString(10);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(11);
            if (resultSet.wasNull()) {
                string = null;
            }
            l6 = new Long(resultSet.getLong(12));
            l5 = new Long(resultSet.getLong(13));
            l4 = new Long(resultSet.getLong(14));
            l3 = new Long(resultSet.getLong(15));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "AuditTrail: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSAuditTrailGeneric(l12, l11, l10, l9, n2, n, l8, l7, bl, string2, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "USER_ID" + string2 + ", " + string + "TS" + string2 + ", " + string + "TXID" + string2 + ", " + string + "ACTION" + string2 + ", " + string + "OBJECT_TYPE" + string2 + ", " + string + "OBJECT_ID" + string2 + ", " + string + "ORIGIN_ID" + string2 + ", " + string + "IS_SET_WARNING" + string2 + ", " + string + "ACTION_INFO" + string2 + ", " + string + "ACTION_COMMENT" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + ", " + "       SME2LOAD " + " WHERE " + string + this.tableName() + string2 + ".OBJECT_ID = SME2LOAD.ID");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_userId.check(((SDMSAuditTrailGeneric)sDMSObject).userId, sDMSObject);
        string = string + "idx_userId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_objectId.check(((SDMSAuditTrailGeneric)sDMSObject).objectId, sDMSObject);
        string = string + "idx_objectId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_originId.check(((SDMSAuditTrailGeneric)sDMSObject).originId, sDMSObject);
        string = string + "idx_originId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_userId.put(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).userId, sDMSObject, (1L & l) != 0L);
        idx_objectId.put(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).objectId, sDMSObject, (2L & l) != 0L);
        idx_originId.put(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).originId, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_userId.remove(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).userId, sDMSObject);
        idx_objectId.remove(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).objectId, sDMSObject);
        idx_originId.remove(systemEnvironment, ((SDMSAuditTrailGeneric)sDMSObject).originId, sDMSObject);
    }

    public static SDMSAuditTrail getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSAuditTrail)table.get(systemEnvironment, l);
    }

    public static SDMSAuditTrail getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSAuditTrail)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSAuditTrail getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSAuditTrail)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

