/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSExitState;
import de.independit.scheduler.server.repository.SDMSExitStateGeneric;
import de.independit.scheduler.server.repository.SDMSExitStateTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSExitStateTableGeneric
extends SDMSTable {
    public static final String tableName = "EXIT_STATE";
    public static SDMSExitStateTable table = null;
    public static final String[] columnNames = new String[]{"ID", "PREFERENCE", "IS_FINAL", "IS_RESTARTABLE", "IS_UNREACHABLE", "IS_BROKEN", "IS_BATCH_DEFAULT", "IS_DEPENDENCY_DEFAULT", "ESP_ID", "ESD_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_espId;
    public static SDMSIndex idx_esdId;
    public static SDMSIndex idx_espId_esdId;

    public SDMSExitStateTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ExitState"));
        }
        table = (SDMSExitStateTable)this;
        table = (SDMSExitStateTable)this;
        this.isVersioned = true;
        idx_espId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "espId");
        idx_esdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "esdId");
        idx_espId_esdId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "espId_esdId");
    }

    public SDMSExitState create(SystemEnvironment systemEnvironment, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Long l, Long l2) throws SDMSException {
        SDMSExitState sDMSExitState;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ExitState"));
        }
        this.validate(systemEnvironment, n, bl, bl2, bl3, bl4, bl5, bl6, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSExitStateGeneric sDMSExitStateGeneric = new SDMSExitStateGeneric(systemEnvironment, n, bl, bl2, bl3, bl4, bl5, bl6, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSExitStateGeneric.versions, true);
            table.put(systemEnvironment, sDMSExitStateGeneric.id, sDMSExitStateGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSExitState = (SDMSExitState)sDMSExitStateGeneric.toProxy(systemEnvironment);
            sDMSExitState.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSExitState sDMSExitState2 = (SDMSExitState)sDMSExitStateGeneric.toProxy(systemEnvironment);
            sDMSExitState2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSExitState)) {
            throw new AccessViolationException(sDMSExitState.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSExitState.touchMaster(systemEnvironment);
        return sDMSExitState;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSExitState sDMSExitState) throws SDMSException {
        return sDMSExitState.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Integer n, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, Boolean bl5, Boolean bl6, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Boolean bl;
        Boolean bl2;
        Boolean bl3;
        Boolean bl4;
        Boolean bl5;
        Boolean bl6;
        Integer n;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            n = new Integer(resultSet.getInt(2));
            bl6 = new Boolean(resultSet.getInt(3) != 0);
            bl5 = new Boolean(resultSet.getInt(4) != 0);
            bl4 = new Boolean(resultSet.getInt(5) != 0);
            bl3 = new Boolean(resultSet.getInt(6) != 0);
            bl2 = new Boolean(resultSet.getInt(7) != 0);
            bl = new Boolean(resultSet.getInt(8) != 0);
            l8 = new Long(resultSet.getLong(9));
            l7 = new Long(resultSet.getLong(10));
            l6 = new Long(resultSet.getLong(11));
            l5 = new Long(resultSet.getLong(12));
            l4 = new Long(resultSet.getLong(13));
            l3 = new Long(resultSet.getLong(14));
            l2 = resultSet.getLong(15);
            l = resultSet.getLong(16);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ExitState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSExitStateGeneric(l9, n, bl6, bl5, bl4, bl3, bl2, bl, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "PREFERENCE" + string2 + ", " + string + "IS_FINAL" + string2 + ", " + string + "IS_RESTARTABLE" + string2 + ", " + string + "IS_UNREACHABLE" + string2 + ", " + string + "IS_BROKEN" + string2 + ", " + string + "IS_BATCH_DEFAULT" + string2 + ", " + string + "IS_DEPENDENCY_DEFAULT" + string2 + ", " + string + "ESP_ID" + string2 + ", " + string + "ESD_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_espId.check(((SDMSExitStateGeneric)sDMSObject).espId, sDMSObject);
        string = string + "idx_espId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_esdId.check(((SDMSExitStateGeneric)sDMSObject).esdId, sDMSObject);
        string = string + "idx_esdId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).espId);
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).esdId);
        bl = idx_espId_esdId.check(sDMSKey, sDMSObject);
        string = string + "idx_espId_esdId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_espId.put(systemEnvironment, ((SDMSExitStateGeneric)sDMSObject).espId, sDMSObject, (1L & l) != 0L);
        idx_esdId.put(systemEnvironment, ((SDMSExitStateGeneric)sDMSObject).esdId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).espId);
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).esdId);
        idx_espId_esdId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_espId.remove(systemEnvironment, ((SDMSExitStateGeneric)sDMSObject).espId, sDMSObject);
        idx_esdId.remove(systemEnvironment, ((SDMSExitStateGeneric)sDMSObject).esdId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).espId);
        sDMSKey.add(((SDMSExitStateGeneric)sDMSObject).esdId);
        idx_espId_esdId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSExitState getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitState)table.get(systemEnvironment, l);
    }

    public static SDMSExitState getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSExitState)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSExitState getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSExitState)table.get(systemEnvironment, l, l2);
    }

    public static SDMSExitState idx_espId_esdId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitState)idx_espId_esdId.getUnique(systemEnvironment, object);
    }

    public static SDMSExitState idx_espId_esdId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSExitState)idx_espId_esdId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSExitState idx_espId_esdId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSExitState)idx_espId_esdId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

