/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIgnoredDependency;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyGeneric;
import de.independit.scheduler.server.repository.SDMSIgnoredDependencyTable;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSIgnoredDependencyTableGeneric
extends SDMSTable {
    public static final String tableName = "IGNORED_DEPENDENCY";
    public static SDMSIgnoredDependencyTable table = null;
    public static final String[] columnNames = new String[]{"ID", "SH_ID", "DD_NAME", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_shId;
    public static SDMSIndex idx_shId_ddName;

    public SDMSIgnoredDependencyTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "IgnoredDependency"));
        }
        table = (SDMSIgnoredDependencyTable)this;
        table = (SDMSIgnoredDependencyTable)this;
        this.isVersioned = true;
        idx_shId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "shId");
        idx_shId_ddName = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "shId_ddName");
    }

    public SDMSIgnoredDependency create(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSIgnoredDependency sDMSIgnoredDependency;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "IgnoredDependency"));
        }
        this.validate(systemEnvironment, l, string, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSIgnoredDependencyGeneric sDMSIgnoredDependencyGeneric = new SDMSIgnoredDependencyGeneric(systemEnvironment, l, string, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSIgnoredDependencyGeneric.versions, true);
            table.put(systemEnvironment, sDMSIgnoredDependencyGeneric.id, sDMSIgnoredDependencyGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSIgnoredDependency = (SDMSIgnoredDependency)sDMSIgnoredDependencyGeneric.toProxy(systemEnvironment);
            sDMSIgnoredDependency.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSIgnoredDependency sDMSIgnoredDependency2 = (SDMSIgnoredDependency)sDMSIgnoredDependencyGeneric.toProxy(systemEnvironment);
            sDMSIgnoredDependency2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSIgnoredDependency)) {
            throw new AccessViolationException(sDMSIgnoredDependency.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSIgnoredDependency.touchMaster(systemEnvironment);
        return sDMSIgnoredDependency;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSIgnoredDependency sDMSIgnoredDependency) throws SDMSException {
        return sDMSIgnoredDependency.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, String string, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            l7 = new Long(resultSet.getLong(2));
            string = resultSet.getString(3);
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = resultSet.getLong(8);
            l = resultSet.getLong(9);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "IgnoredDependency: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSIgnoredDependencyGeneric(l8, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "SH_ID" + string2 + ", " + string + "DD_NAME" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_shId.check(((SDMSIgnoredDependencyGeneric)sDMSObject).shId, sDMSObject);
        string = string + "idx_shId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSIgnoredDependencyGeneric)sDMSObject).shId);
        sDMSKey.add((Comparable)((Object)((SDMSIgnoredDependencyGeneric)sDMSObject).ddName));
        bl = idx_shId_ddName.check(sDMSKey, sDMSObject);
        string = string + "idx_shId_ddName: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_shId.put(systemEnvironment, ((SDMSIgnoredDependencyGeneric)sDMSObject).shId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSIgnoredDependencyGeneric)sDMSObject).shId);
        sDMSKey.add((Comparable)((Object)((SDMSIgnoredDependencyGeneric)sDMSObject).ddName));
        idx_shId_ddName.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_shId.remove(systemEnvironment, ((SDMSIgnoredDependencyGeneric)sDMSObject).shId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSIgnoredDependencyGeneric)sDMSObject).shId);
        sDMSKey.add((Comparable)((Object)((SDMSIgnoredDependencyGeneric)sDMSObject).ddName));
        idx_shId_ddName.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSIgnoredDependency getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIgnoredDependency)table.get(systemEnvironment, l);
    }

    public static SDMSIgnoredDependency getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIgnoredDependency)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSIgnoredDependency getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSIgnoredDependency)table.get(systemEnvironment, l, l2);
    }

    public static SDMSIgnoredDependency idx_shId_ddName_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSIgnoredDependency)idx_shId_ddName.getUnique(systemEnvironment, object);
    }

    public static SDMSIgnoredDependency idx_shId_ddName_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSIgnoredDependency)idx_shId_ddName.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSIgnoredDependency idx_shId_ddName_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSIgnoredDependency)idx_shId_ddName.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

