/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSInterval;
import de.independit.scheduler.server.repository.SDMSIntervalTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSIntervalGeneric
extends SDMSObject
implements Cloneable {
    public static final int MINUTE = 0;
    public static final int HOUR = 1;
    public static final int DAY = 2;
    public static final int WEEK = 3;
    public static final int MONTH = 4;
    public static final int YEAR = 5;
    public static final long MINUTE_DUR = 60000L;
    public static final long HOUR_DUR = 3600000L;
    public static final long DAY_DUR = 86400000L;
    public static final long WEEK_DUR = 604800000L;
    public static final long MONTH_DUR = 2592000000L;
    public static final long YEAR_DUR = 31536000000L;
    public static final long MINUTE_DUR_M = 1L;
    public static final long HOUR_DUR_M = 60L;
    public static final long DAY_DUR_M = 1440L;
    public static final long WEEK_DUR_M = 10080L;
    public static final long MONTH_DUR_M = 43200L;
    public static final long YEAR_DUR_M = 525600L;
    public static final int SYSTEM = 0;
    public static final int SELECT = 99;
    public static final int DISTRIBUTION = 25;
    public static final int ENVIRONMENT = 1;
    public static final int EXIT_STATE_DEFINITION = 2;
    public static final int EXIT_STATE_PROFILE = 3;
    public static final int EXIT_STATE_MAPPING = 4;
    public static final int EXIT_STATE_TRANSLATION = 5;
    public static final int FOLDER = 6;
    public static final int FOOTPRINT = 7;
    public static final int USER = 8;
    public static final int JOB_DEFINITION = 9;
    public static final int NAMED_RESOURCE = 10;
    public static final int NICE_PROFILE = 31;
    public static final int PARAMETER = 23;
    public static final int POOL = 24;
    public static final int RESOURCE = 11;
    public static final int RESOURCE_STATE_MAPPING = 12;
    public static final int RESOURCE_STATE_DEFINITION = 13;
    public static final int RESOURCE_STATE_PROFILE = 14;
    public static final int SCOPE = 15;
    public static final int TRIGGER = 16;
    public static final int JOB = 17;
    public static final int EVENT = 18;
    public static final int INTERVAL = 19;
    public static final int SCHEDULE = 20;
    public static final int GROUP = 21;
    public static final int SCHEDULED_EVENT = 22;
    public static final int COMMENT = 26;
    public static final int GRANT = 27;
    public static final int RESOURCE_TEMPLATE = 28;
    public static final int WATCH_TYPE = 29;
    public static final int OBJECT_MONITOR = 30;
    public static final int INTERVAL_DISPATCHER = 88;
    public static final long MINUTE_MAX = 60000L;
    public static final long HOUR_MAX = 3600000L;
    public static final long DAY_MAX = 90000000L;
    public static final long WEEK_MAX = 608400000L;
    public static final long MONTH_MAX = 2682000000L;
    public static final long YEAR_MAX = 31622400000L;
    public static final int nr_id = 1;
    public static final int nr_name = 2;
    public static final int nr_ownerId = 3;
    public static final int nr_startTime = 4;
    public static final int nr_endTime = 5;
    public static final int nr_delay = 6;
    public static final int nr_baseInterval = 7;
    public static final int nr_baseIntervalMultiplier = 8;
    public static final int nr_duration = 9;
    public static final int nr_durationMultiplier = 10;
    public static final int nr_syncTime = 11;
    public static final int nr_isInverse = 12;
    public static final int nr_isMerge = 13;
    public static final int nr_embeddedIntervalId = 14;
    public static final int nr_seId = 15;
    public static final int nr_objId = 16;
    public static final int nr_objType = 17;
    public static final int nr_creatorUId = 18;
    public static final int nr_createTs = 19;
    public static final int nr_changerUId = 20;
    public static final int nr_changeTs = 21;
    public static String tableName = "INTERVALL";
    protected String name;
    protected Long ownerId;
    protected Long startTime;
    protected Long endTime;
    protected Long delay;
    protected Integer baseInterval;
    protected Integer baseIntervalMultiplier;
    protected Integer duration;
    protected Integer durationMultiplier;
    protected Long syncTime;
    protected Boolean isInverse;
    protected Boolean isMerge;
    protected Long embeddedIntervalId;
    protected Long seId;
    protected Long objId;
    protected Integer objType;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSIntervalGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, Integer n3, Integer n4, Long l5, Boolean bl, Boolean bl2, Long l6, Long l7, Long l8, Integer n5, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
        super(systemEnvironment, SDMSIntervalTableGeneric.table);
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(Interval) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.ownerId = l;
        this.startTime = l2;
        this.endTime = l3;
        this.delay = l4;
        this.baseInterval = n;
        this.baseIntervalMultiplier = n2;
        this.duration = n3;
        this.durationMultiplier = n4;
        this.syncTime = l5;
        this.isInverse = bl;
        this.isMerge = bl2;
        this.embeddedIntervalId = l6;
        this.seId = l7;
        this.objId = l8;
        this.objType = n5;
        this.creatorUId = l9;
        this.createTs = l10;
        this.changerUId = l11;
        this.changeTs = l12;
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
            }
            SDMSIntervalGeneric sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(Interval) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSIntervalGeneric.name = string;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 33L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOwnerId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.ownerId;
    }

    public void setOwnerId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.ownerId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
            }
            SDMSIntervalGeneric sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            sDMSIntervalGeneric.ownerId = l;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getStartTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.startTime;
    }

    public void setStartTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.startTime)) {
            return;
        }
        if (l == null && this.startTime == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.startTime = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getEndTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.endTime;
    }

    public void setEndTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.endTime)) {
            return;
        }
        if (l == null && this.endTime == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.endTime = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getDelay(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.delay;
    }

    public void setDelay(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.delay)) {
            return;
        }
        if (l == null && this.delay == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.delay = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Integer getBaseInterval(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.baseInterval;
    }

    public String getBaseIntervalAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getBaseInterval(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Interval.baseInterval: $1", (Object)this.getBaseInterval(systemEnvironment)));
    }

    public void setBaseInterval(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.baseInterval)) {
            return;
        }
        if (n == null && this.baseInterval == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.baseInterval = n;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Integer getBaseIntervalMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.baseIntervalMultiplier;
    }

    public void setBaseIntervalMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.baseIntervalMultiplier)) {
            return;
        }
        if (n == null && this.baseIntervalMultiplier == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.baseIntervalMultiplier = n;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Integer getDuration(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.duration;
    }

    public String getDurationAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getDuration(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "MINUTE";
            }
            case 1: {
                return "HOUR";
            }
            case 2: {
                return "DAY";
            }
            case 3: {
                return "WEEK";
            }
            case 4: {
                return "MONTH";
            }
            case 5: {
                return "YEAR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Interval.duration: $1", (Object)this.getDuration(systemEnvironment)));
    }

    public void setDuration(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.duration)) {
            return;
        }
        if (n == null && this.duration == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.duration = n;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Integer getDurationMultiplier(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.durationMultiplier;
    }

    public void setDurationMultiplier(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.durationMultiplier)) {
            return;
        }
        if (n == null && this.durationMultiplier == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.durationMultiplier = n;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getSyncTime(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.syncTime;
    }

    public void setSyncTime(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.syncTime.equals(l)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.syncTime = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Boolean getIsInverse(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isInverse;
    }

    public void setIsInverse(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isInverse.equals(bl)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.isInverse = bl;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Boolean getIsMerge(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isMerge;
    }

    public void setIsMerge(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isMerge.equals(bl)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.isMerge = bl;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getEmbeddedIntervalId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.embeddedIntervalId;
    }

    public void setEmbeddedIntervalId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.embeddedIntervalId)) {
            return;
        }
        if (l == null && this.embeddedIntervalId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
            }
            SDMSIntervalGeneric sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            sDMSIntervalGeneric.embeddedIntervalId = l;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.seId)) {
            return;
        }
        if (l == null && this.seId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
            }
            SDMSIntervalGeneric sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            sDMSIntervalGeneric.seId = l;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getObjId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objId;
    }

    public void setObjId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.objId)) {
            return;
        }
        if (l == null && this.objId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
            }
            SDMSIntervalGeneric sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            sDMSIntervalGeneric.objId = l;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 48L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getObjType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.objType;
    }

    public String getObjTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getObjType(systemEnvironment);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 25: {
                return "DISTRIBUTION";
            }
            case 8: {
                return "USER";
            }
            case 9: {
                return "JOB_DEFINITION";
            }
            case 11: {
                return "RESOURCE";
            }
            case 15: {
                return "SCOPE";
            }
            case 16: {
                return "TRIGGER";
            }
            case 18: {
                return "EVENT";
            }
            case 19: {
                return "INTERVAL";
            }
            case 20: {
                return "SCHEDULE";
            }
            case 22: {
                return "SCHEDULED_EVENT";
            }
            case 28: {
                return "RESOURCE_TEMPLATE";
            }
            case 88: {
                return "INTERVAL_DISPATCHER";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown Interval.objType: $1", (Object)this.getObjType(systemEnvironment)));
    }

    public void setObjType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.objType)) {
            return;
        }
        if (n == null && this.objType == null) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.objType = n;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.creatorUId = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(Interval) Change of system object not allowed"));
        }
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.createTs = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.changerUId = l;
        sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSIntervalGeneric sDMSIntervalGeneric = this;
        if (sDMSIntervalGeneric.versions.o_v == null || sDMSIntervalGeneric.versions.o_v.size() == 0 || sDMSIntervalGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalGeneric.changeTs = l;
        sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSIntervalGeneric != this) {
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric, 0L);
        }
    }

    public SDMSIntervalGeneric set_NameObjId(SystemEnvironment systemEnvironment, String string, Long l) throws SDMSException {
        SDMSIntervalGeneric sDMSIntervalGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(Interval) Change of system object not allowed"));
            }
            sDMSIntervalGeneric = (SDMSIntervalGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(Interval) Length of $1 exceeds maximum length $2", (Object)"changeTs", (Object)"64"));
            }
            sDMSIntervalGeneric.name = string;
            sDMSIntervalGeneric.objId = l;
            sDMSIntervalGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalGeneric.versions.table.index(systemEnvironment, sDMSIntervalGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSIntervalGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSInterval(this);
    }

    protected SDMSIntervalGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, Integer n, Integer n2, Integer n3, Integer n4, Long l6, Boolean bl, Boolean bl2, Long l7, Long l8, Long l9, Integer n5, Long l10, Long l11, Long l12, Long l13, long l14, long l15) {
        this.id = l;
        this.name = string;
        this.ownerId = l2;
        this.startTime = l3;
        this.endTime = l4;
        this.delay = l5;
        this.baseInterval = n;
        this.baseIntervalMultiplier = n2;
        this.duration = n3;
        this.durationMultiplier = n4;
        this.syncTime = l6;
        this.isInverse = bl;
        this.isMerge = bl2;
        this.embeddedIntervalId = l7;
        this.seId = l8;
        this.objId = l9;
        this.objType = n5;
        this.creatorUId = l10;
        this.createTs = l11;
        this.changerUId = l12;
        this.changeTs = l13;
        this.validFrom = l14;
        this.validTo = l15;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "INTERVALL" + string3 + " (" + "ID" + ", " + string2 + "NAME" + string3 + ", " + string2 + "OWNER_ID" + string3 + ", " + string2 + "START_TIME" + string3 + ", " + string2 + "END_TIME" + string3 + ", " + string2 + "DELAY" + string3 + ", " + string2 + "BASE_INTERVAL" + string3 + ", " + string2 + "BASE_INTERVAL_MULTIPLIER" + string3 + ", " + string2 + "DURATION" + string3 + ", " + string2 + "DURATION_MULTIPLIER" + string3 + ", " + string2 + "SYNC_TIME" + string3 + ", " + string2 + "IS_INVERSE" + string3 + ", " + string2 + "IS_MERGE" + string3 + ", " + string2 + "EMBEDDED_INT_ID" + string3 + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "OBJ_ID" + string3 + ", " + string2 + "OBJ_TYPE" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSIntervalGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "Interval: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.name);
            preparedStatement.setLong(3, this.ownerId);
            if (this.startTime == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.startTime);
            }
            if (this.endTime == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.endTime);
            }
            if (this.delay == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setLong(6, this.delay);
            }
            if (this.baseInterval == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.baseInterval);
            }
            if (this.baseIntervalMultiplier == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.baseIntervalMultiplier);
            }
            if (this.duration == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.duration);
            }
            if (this.durationMultiplier == null) {
                preparedStatement.setNull(10, 4);
            } else {
                preparedStatement.setInt(10, this.durationMultiplier);
            }
            preparedStatement.setLong(11, this.syncTime);
            preparedStatement.setInt(12, this.isInverse != false ? 1 : 0);
            preparedStatement.setInt(13, this.isMerge != false ? 1 : 0);
            if (this.embeddedIntervalId == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.embeddedIntervalId);
            }
            if (this.seId == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.seId);
            }
            if (this.objId == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setLong(16, this.objId);
            }
            if (this.objType == null) {
                preparedStatement.setNull(17, 4);
            } else {
                preparedStatement.setInt(17, this.objType);
            }
            preparedStatement.setLong(18, this.creatorUId);
            preparedStatement.setLong(19, this.createTs);
            preparedStatement.setLong(20, this.changerUId);
            preparedStatement.setLong(21, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "Interval: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "INTERVALL" + string3 + " WHERE ID = ?";
                SDMSIntervalGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "Interval: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "Interval: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "INTERVALL" + string3 + " SET " + "" + string2 + "NAME" + string3 + " = ? " + ", " + string2 + "OWNER_ID" + string3 + " = ? " + ", " + string2 + "START_TIME" + string3 + " = ? " + ", " + string2 + "END_TIME" + string3 + " = ? " + ", " + string2 + "DELAY" + string3 + " = ? " + ", " + string2 + "BASE_INTERVAL" + string3 + " = ? " + ", " + string2 + "BASE_INTERVAL_MULTIPLIER" + string3 + " = ? " + ", " + string2 + "DURATION" + string3 + " = ? " + ", " + string2 + "DURATION_MULTIPLIER" + string3 + " = ? " + ", " + string2 + "SYNC_TIME" + string3 + " = ? " + ", " + string2 + "IS_INVERSE" + string3 + " = ? " + ", " + string2 + "IS_MERGE" + string3 + " = ? " + ", " + string2 + "EMBEDDED_INT_ID" + string3 + " = ? " + ", " + string2 + "SE_ID" + string3 + " = ? " + ", " + string2 + "OBJ_ID" + string3 + " = ? " + ", " + string2 + "OBJ_TYPE" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSIntervalGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "Interval: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.name);
            preparedStatement.setLong(2, this.ownerId);
            if (this.startTime == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.startTime);
            }
            if (this.endTime == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.endTime);
            }
            if (this.delay == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.delay);
            }
            if (this.baseInterval == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.baseInterval);
            }
            if (this.baseIntervalMultiplier == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.baseIntervalMultiplier);
            }
            if (this.duration == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setInt(8, this.duration);
            }
            if (this.durationMultiplier == null) {
                preparedStatement.setNull(9, 4);
            } else {
                preparedStatement.setInt(9, this.durationMultiplier);
            }
            preparedStatement.setLong(10, this.syncTime);
            preparedStatement.setInt(11, this.isInverse != false ? 1 : 0);
            preparedStatement.setInt(12, this.isMerge != false ? 1 : 0);
            if (this.embeddedIntervalId == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.embeddedIntervalId);
            }
            if (this.seId == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.seId);
            }
            if (this.objId == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.objId);
            }
            if (this.objType == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setInt(16, this.objType);
            }
            preparedStatement.setLong(17, this.creatorUId);
            preparedStatement.setLong(18, this.createTs);
            preparedStatement.setLong(19, this.changerUId);
            preparedStatement.setLong(20, this.changeTs);
            preparedStatement.setLong(21, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "Interval: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkBaseInterval(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkDuration(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkObjType(Integer n) {
        if (n == null) {
            return true;
        }
        switch (n) {
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 88: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : Interval", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "ownerId : " + this.ownerId, 2);
        SDMSThread.doTrace(null, "startTime : " + this.startTime, 2);
        SDMSThread.doTrace(null, "endTime : " + this.endTime, 2);
        SDMSThread.doTrace(null, "delay : " + this.delay, 2);
        SDMSThread.doTrace(null, "baseInterval : " + this.baseInterval, 2);
        SDMSThread.doTrace(null, "baseIntervalMultiplier : " + this.baseIntervalMultiplier, 2);
        SDMSThread.doTrace(null, "duration : " + this.duration, 2);
        SDMSThread.doTrace(null, "durationMultiplier : " + this.durationMultiplier, 2);
        SDMSThread.doTrace(null, "syncTime : " + this.syncTime, 2);
        SDMSThread.doTrace(null, "isInverse : " + this.isInverse, 2);
        SDMSThread.doTrace(null, "isMerge : " + this.isMerge, 2);
        SDMSThread.doTrace(null, "embeddedIntervalId : " + this.embeddedIntervalId, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "objId : " + this.objId, 2);
        SDMSThread.doTrace(null, "objType : " + this.objType, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "name                   : " + this.name + "\n" + string + "ownerId                : " + this.ownerId + "\n" + string + "startTime              : " + this.startTime + "\n" + string + "endTime                : " + this.endTime + "\n" + string + "delay                  : " + this.delay + "\n" + string + "baseInterval           : " + this.baseInterval + "\n" + string + "baseIntervalMultiplier : " + this.baseIntervalMultiplier + "\n" + string + "duration               : " + this.duration + "\n" + string + "durationMultiplier     : " + this.durationMultiplier + "\n" + string + "syncTime               : " + this.syncTime + "\n" + string + "isInverse              : " + this.isInverse + "\n" + string + "isMerge                : " + this.isMerge + "\n" + string + "embeddedIntervalId     : " + this.embeddedIntervalId + "\n" + string + "seId                   : " + this.seId + "\n" + string + "objId                  : " + this.objId + "\n" + string + "objType                : " + this.objType + "\n" + string + "creatorUId             : " + this.creatorUId + "\n" + string + "createTs               : " + this.createTs + "\n" + string + "changerUId             : " + this.changerUId + "\n" + string + "changeTs               : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

