/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSIntervalSelectionGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_intId = 2;
    public static final int nr_value = 3;
    public static final int nr_periodFrom = 4;
    public static final int nr_periodTo = 5;
    public static final int nr_creatorUId = 6;
    public static final int nr_createTs = 7;
    public static final int nr_changerUId = 8;
    public static final int nr_changeTs = 9;
    public static String tableName = "INTERVAL_SELECTION";
    protected Long intId;
    protected Integer value;
    protected Long periodFrom;
    protected Long periodTo;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSIntervalSelectionGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
        super(systemEnvironment, SDMSIntervalSelectionTableGeneric.table);
        this.intId = l;
        this.value = n;
        this.periodFrom = l2;
        this.periodTo = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
    }

    public Long getIntId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.intId;
    }

    public void setIntId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.intId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
            }
            SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
            sDMSIntervalSelectionGeneric.intId = l;
            sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getValue(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.value;
    }

    public void setValue(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.value)) {
            return;
        }
        if (n == null && this.value == null) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
        }
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.value = n;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getPeriodFrom(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.periodFrom;
    }

    public void setPeriodFrom(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.periodFrom)) {
            return;
        }
        if (l == null && this.periodFrom == null) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
        }
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.periodFrom = l;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getPeriodTo(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.periodTo;
    }

    public void setPeriodTo(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.periodTo)) {
            return;
        }
        if (l == null && this.periodTo == null) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
        }
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.periodTo = l;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
        }
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.creatorUId = l;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(IntervalSelection) Change of system object not allowed"));
        }
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.createTs = l;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.changerUId = l;
        sDMSIntervalSelectionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = this;
        if (sDMSIntervalSelectionGeneric.versions.o_v == null || sDMSIntervalSelectionGeneric.versions.o_v.size() == 0 || sDMSIntervalSelectionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSIntervalSelectionGeneric = (SDMSIntervalSelectionGeneric)this.change(systemEnvironment);
        }
        sDMSIntervalSelectionGeneric.changeTs = l;
        sDMSIntervalSelectionGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSIntervalSelectionGeneric != this) {
            sDMSIntervalSelectionGeneric.versions.table.index(systemEnvironment, sDMSIntervalSelectionGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSIntervalSelection(this);
    }

    protected SDMSIntervalSelectionGeneric(Long l, Long l2, Integer n, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, long l9, long l10) {
        this.id = l;
        this.intId = l2;
        this.value = n;
        this.periodFrom = l3;
        this.periodTo = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.validFrom = l9;
        this.validTo = l10;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "INTERVAL_SELECTION" + string3 + " (" + "ID" + ", " + string2 + "INT_ID" + string3 + ", " + string2 + "VALUE" + string3 + ", " + string2 + "PERIOD_FROM" + string3 + ", " + string2 + "PERIOD_TO" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSIntervalSelectionGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "IntervalSelection: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.intId);
            if (this.value == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setInt(3, this.value);
            }
            if (this.periodFrom == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.periodFrom);
            }
            if (this.periodTo == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.periodTo);
            }
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "IntervalSelection: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "INTERVAL_SELECTION" + string3 + " WHERE ID = ?";
                SDMSIntervalSelectionGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "IntervalSelection: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "IntervalSelection: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "INTERVAL_SELECTION" + string3 + " SET " + "" + string2 + "INT_ID" + string3 + " = ? " + ", " + string2 + "VALUE" + string3 + " = ? " + ", " + string2 + "PERIOD_FROM" + string3 + " = ? " + ", " + string2 + "PERIOD_TO" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSIntervalSelectionGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "IntervalSelection: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.intId);
            if (this.value == null) {
                preparedStatement.setNull(2, 4);
            } else {
                preparedStatement.setInt(2, this.value);
            }
            if (this.periodFrom == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.periodFrom);
            }
            if (this.periodTo == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.periodTo);
            }
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.setLong(9, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "IntervalSelection: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : IntervalSelection", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "intId : " + this.intId, 2);
        SDMSThread.doTrace(null, "value : " + this.value, 2);
        SDMSThread.doTrace(null, "periodFrom : " + this.periodFrom, 2);
        SDMSThread.doTrace(null, "periodTo : " + this.periodTo, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "intId      : " + this.intId + "\n" + string + "value      : " + this.value + "\n" + string + "periodFrom : " + this.periodFrom + "\n" + string + "periodTo   : " + this.periodTo + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

