/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSIntervalSelection;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionGeneric;
import de.independit.scheduler.server.repository.SDMSIntervalSelectionTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSIntervalSelectionTableGeneric
extends SDMSTable {
    public static final String tableName = "INTERVAL_SELECTION";
    public static SDMSIntervalSelectionTable table = null;
    public static final String[] columnNames = new String[]{"ID", "INT_ID", "VALUE", "PERIOD_FROM", "PERIOD_TO", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_intId;

    public SDMSIntervalSelectionTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "IntervalSelection"));
        }
        table = (SDMSIntervalSelectionTable)this;
        table = (SDMSIntervalSelectionTable)this;
        this.isVersioned = false;
        idx_intId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "intId");
    }

    public SDMSIntervalSelection create(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3) throws SDMSException {
        SDMSIntervalSelection sDMSIntervalSelection;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "IntervalSelection"));
        }
        this.validate(systemEnvironment, l, n, l2, l3, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSIntervalSelectionGeneric sDMSIntervalSelectionGeneric = new SDMSIntervalSelectionGeneric(systemEnvironment, l, n, l2, l3, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSIntervalSelectionGeneric.versions, true);
            table.put(systemEnvironment, sDMSIntervalSelectionGeneric.id, sDMSIntervalSelectionGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSIntervalSelection = (SDMSIntervalSelection)sDMSIntervalSelectionGeneric.toProxy(systemEnvironment);
            sDMSIntervalSelection.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSIntervalSelection sDMSIntervalSelection2 = (SDMSIntervalSelection)sDMSIntervalSelectionGeneric.toProxy(systemEnvironment);
            sDMSIntervalSelection2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSIntervalSelection)) {
            throw new AccessViolationException(sDMSIntervalSelection.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSIntervalSelection.touchMaster(systemEnvironment);
        return sDMSIntervalSelection;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSIntervalSelection sDMSIntervalSelection) throws SDMSException {
        return sDMSIntervalSelection.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Integer n;
        Long l9;
        Long l10;
        try {
            l10 = new Long(resultSet.getLong(1));
            l9 = new Long(resultSet.getLong(2));
            n = new Integer(resultSet.getInt(3));
            if (resultSet.wasNull()) {
                n = null;
            }
            l8 = new Long(resultSet.getLong(4));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            l6 = new Long(resultSet.getLong(6));
            l5 = new Long(resultSet.getLong(7));
            l4 = new Long(resultSet.getLong(8));
            l3 = new Long(resultSet.getLong(9));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "IntervalSelection: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSIntervalSelectionGeneric(l10, l9, n, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "INT_ID" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "PERIOD_FROM" + string2 + ", " + string + "PERIOD_TO" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_intId.check(((SDMSIntervalSelectionGeneric)sDMSObject).intId, sDMSObject);
        string = string + "idx_intId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_intId.put(systemEnvironment, ((SDMSIntervalSelectionGeneric)sDMSObject).intId, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_intId.remove(systemEnvironment, ((SDMSIntervalSelectionGeneric)sDMSObject).intId, sDMSObject);
    }

    public static SDMSIntervalSelection getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIntervalSelection)table.get(systemEnvironment, l);
    }

    public static SDMSIntervalSelection getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSIntervalSelection)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSIntervalSelection getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSIntervalSelection)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

