/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSKillJob;
import de.independit.scheduler.server.repository.SDMSKillJobTableGeneric;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSKillJobGeneric
extends SDMSObject
implements Cloneable {
    public static final int RUNNABLE = 4;
    public static final int STARTING = 5;
    public static final int STARTED = 6;
    public static final int RUNNING = 7;
    public static final int FINISHED = 11;
    public static final int BROKEN_ACTIVE = 13;
    public static final int BROKEN_FINISHED = 14;
    public static final int ERROR = 15;
    public static final int nr_id = 1;
    public static final int nr_seId = 2;
    public static final int nr_seVersion = 3;
    public static final int nr_smeId = 4;
    public static final int nr_scopeId = 5;
    public static final int nr_state = 6;
    public static final int nr_exitCode = 7;
    public static final int nr_commandline = 8;
    public static final int nr_logfile = 9;
    public static final int nr_errlogfile = 10;
    public static final int nr_pid = 11;
    public static final int nr_extPid = 12;
    public static final int nr_errorMsg = 13;
    public static final int nr_runnableTs = 14;
    public static final int nr_startTs = 15;
    public static final int nr_finishTs = 16;
    public static final int nr_creatorUId = 17;
    public static final int nr_createTs = 18;
    public static final int nr_changerUId = 19;
    public static final int nr_changeTs = 20;
    public static String tableName = "KILL_JOB";
    protected Long seId;
    protected Long seVersion;
    protected Long smeId;
    protected Long scopeId;
    protected Integer state;
    protected Integer exitCode;
    protected String commandline;
    protected String logfile;
    protected String errlogfile;
    protected String pid;
    protected String extPid;
    protected String errorMsg;
    protected Long runnableTs;
    protected Long startTs;
    protected Long finishTs;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSKillJobGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Integer n, Integer n2, String string, String string2, String string3, String string4, String string5, String string6, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11) throws SDMSException {
        super(systemEnvironment, SDMSKillJobTableGeneric.table);
        this.seId = l;
        this.seVersion = l2;
        this.smeId = l3;
        this.scopeId = l4;
        this.state = n;
        this.exitCode = n2;
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        this.commandline = string;
        if (string2 != null && string2.length() > 512) {
            string2 = string2.substring(0, 512);
        }
        this.logfile = string2;
        if (string3 != null && string3.length() > 512) {
            string3 = string3.substring(0, 512);
        }
        this.errlogfile = string3;
        if (string4 != null && string4.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(KillJob) Length of $1 exceeds maximum length $2", (Object)"pid", (Object)"32"));
        }
        this.pid = string4;
        if (string5 != null && string5.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(KillJob) Length of $1 exceeds maximum length $2", (Object)"extPid", (Object)"32"));
        }
        this.extPid = string5;
        if (string6 != null && string6.length() > 256) {
            string6 = string6.substring(0, 256);
        }
        this.errorMsg = string6;
        this.runnableTs = l5;
        this.startTs = l6;
        this.finishTs = l7;
        this.creatorUId = l8;
        this.createTs = l9;
        this.changerUId = l10;
        this.changeTs = l11;
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
            }
            SDMSKillJobGeneric sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
            sDMSKillJobGeneric.seId = l;
            sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 1L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getSeVersion(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seVersion;
    }

    public void setSeVersion(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seVersion.equals(l)) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.seVersion = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
            }
            SDMSKillJobGeneric sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
            sDMSKillJobGeneric.smeId = l;
            sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.scopeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
            }
            SDMSKillJobGeneric sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
            sDMSKillJobGeneric.scopeId = l;
            sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getState(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.state;
    }

    public String getStateAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getState(systemEnvironment);
        switch (n) {
            case 4: {
                return "RUNNABLE";
            }
            case 5: {
                return "STARTING";
            }
            case 6: {
                return "STARTED";
            }
            case 7: {
                return "RUNNING";
            }
            case 11: {
                return "FINISHED";
            }
            case 13: {
                return "BROKEN_ACTIVE";
            }
            case 14: {
                return "BROKEN_FINISHED";
            }
            case 15: {
                return "ERROR";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown KillJob.state: $1", (Object)this.getState(systemEnvironment)));
    }

    public void setState(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.state.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
            }
            SDMSKillJobGeneric sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
            sDMSKillJobGeneric.state = n;
            sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 8L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getExitCode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.exitCode;
    }

    public void setExitCode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.exitCode)) {
            return;
        }
        if (n == null && this.exitCode == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.exitCode = n;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getCommandline(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.commandline;
    }

    public void setCommandline(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.commandline)) {
            return;
        }
        if (string == null && this.commandline == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSKillJobGeneric.commandline = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.logfile;
    }

    public void setLogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.logfile)) {
            return;
        }
        if (string == null && this.logfile == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSKillJobGeneric.logfile = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getErrlogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errlogfile;
    }

    public void setErrlogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errlogfile)) {
            return;
        }
        if (string == null && this.errlogfile == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSKillJobGeneric.errlogfile = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.pid;
    }

    public void setPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.pid)) {
            return;
        }
        if (string == null && this.pid == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(KillJob) Length of $1 exceeds maximum length $2", (Object)"pid", (Object)"32"));
        }
        sDMSKillJobGeneric.pid = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getExtPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.extPid;
    }

    public void setExtPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.extPid)) {
            return;
        }
        if (string == null && this.extPid == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(KillJob) Length of $1 exceeds maximum length $2", (Object)"extPid", (Object)"32"));
        }
        sDMSKillJobGeneric.extPid = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public String getErrorMsg(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errorMsg;
    }

    public void setErrorMsg(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errorMsg)) {
            return;
        }
        if (string == null && this.errorMsg == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            string = string.substring(0, 256);
        }
        sDMSKillJobGeneric.errorMsg = string;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getRunnableTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.runnableTs;
    }

    public void setRunnableTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.runnableTs)) {
            return;
        }
        if (l == null && this.runnableTs == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.runnableTs = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getStartTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.startTs;
    }

    public void setStartTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.startTs)) {
            return;
        }
        if (l == null && this.startTs == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.startTs = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getFinishTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finishTs;
    }

    public void setFinishTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finishTs)) {
            return;
        }
        if (l == null && this.finishTs == null) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.finishTs = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.creatorUId = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(KillJob) Change of system object not allowed"));
        }
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.createTs = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.changerUId = l;
        sDMSKillJobGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSKillJobGeneric sDMSKillJobGeneric = this;
        if (sDMSKillJobGeneric.versions.o_v == null || sDMSKillJobGeneric.versions.o_v.size() == 0 || sDMSKillJobGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSKillJobGeneric = (SDMSKillJobGeneric)this.change(systemEnvironment);
        }
        sDMSKillJobGeneric.changeTs = l;
        sDMSKillJobGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSKillJobGeneric != this) {
            sDMSKillJobGeneric.versions.table.index(systemEnvironment, sDMSKillJobGeneric, 0L);
        }
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSKillJob(this);
    }

    protected SDMSKillJobGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Integer n, Integer n2, String string, String string2, String string3, String string4, String string5, String string6, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, long l13, long l14) {
        this.id = l;
        this.seId = l2;
        this.seVersion = l3;
        this.smeId = l4;
        this.scopeId = l5;
        this.state = n;
        this.exitCode = n2;
        this.commandline = string;
        this.logfile = string2;
        this.errlogfile = string3;
        this.pid = string4;
        this.extPid = string5;
        this.errorMsg = string6;
        this.runnableTs = l6;
        this.startTs = l7;
        this.finishTs = l8;
        this.creatorUId = l9;
        this.createTs = l10;
        this.changerUId = l11;
        this.changeTs = l12;
        this.validFrom = l13;
        this.validTo = l14;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "KILL_JOB" + string3 + " (" + "ID" + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "SE_VERSION" + string3 + ", " + string2 + "SME_ID" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "STATE" + string3 + ", " + string2 + "EXIT_CODE" + string3 + ", " + string2 + "COMMANDLINE" + string3 + ", " + string2 + "LOGFILE" + string3 + ", " + string2 + "ERRLOGFILE" + string3 + ", " + string2 + "PID" + string3 + ", " + string2 + "EXTPID" + string3 + ", " + string2 + "ERROR_MSG" + string3 + ", " + string2 + "RUNNABLE_TS" + string3 + ", " + string2 + "START_TS" + string3 + ", " + string2 + "FINSH_TS" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSKillJobGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "KillJob: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.seId);
            preparedStatement.setLong(3, this.seVersion);
            preparedStatement.setLong(4, this.smeId);
            preparedStatement.setLong(5, this.scopeId);
            preparedStatement.setInt(6, this.state);
            if (this.exitCode == null) {
                preparedStatement.setNull(7, 4);
            } else {
                preparedStatement.setInt(7, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.commandline);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.errlogfile);
            }
            if (this.pid == null) {
                preparedStatement.setNull(11, 12);
            } else {
                preparedStatement.setString(11, this.pid);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.extPid);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(13, 12);
            } else {
                preparedStatement.setString(13, this.errorMsg);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setLong(16, this.finishTs);
            }
            preparedStatement.setLong(17, this.creatorUId);
            preparedStatement.setLong(18, this.createTs);
            preparedStatement.setLong(19, this.changerUId);
            preparedStatement.setLong(20, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "KillJob: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "KILL_JOB" + string3 + " WHERE ID = ?";
                SDMSKillJobGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "KillJob: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "KillJob: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "KILL_JOB" + string3 + " SET " + "" + string2 + "SE_ID" + string3 + " = ? " + ", " + string2 + "SE_VERSION" + string3 + " = ? " + ", " + string2 + "SME_ID" + string3 + " = ? " + ", " + string2 + "SCOPE_ID" + string3 + " = ? " + ", " + string2 + "STATE" + string3 + " = ? " + ", " + string2 + "EXIT_CODE" + string3 + " = ? " + ", " + string2 + "COMMANDLINE" + string3 + " = ? " + ", " + string2 + "LOGFILE" + string3 + " = ? " + ", " + string2 + "ERRLOGFILE" + string3 + " = ? " + ", " + string2 + "PID" + string3 + " = ? " + ", " + string2 + "EXTPID" + string3 + " = ? " + ", " + string2 + "ERROR_MSG" + string3 + " = ? " + ", " + string2 + "RUNNABLE_TS" + string3 + " = ? " + ", " + string2 + "START_TS" + string3 + " = ? " + ", " + string2 + "FINSH_TS" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSKillJobGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "KillJob: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.seId);
            preparedStatement.setLong(2, this.seVersion);
            preparedStatement.setLong(3, this.smeId);
            preparedStatement.setLong(4, this.scopeId);
            preparedStatement.setInt(5, this.state);
            if (this.exitCode == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.commandline);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.errlogfile);
            }
            if (this.pid == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.pid);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(11, 12);
            } else {
                preparedStatement.setString(11, this.extPid);
            }
            if (this.errorMsg == null) {
                preparedStatement.setNull(12, 12);
            } else {
                preparedStatement.setString(12, this.errorMsg);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.finishTs);
            }
            preparedStatement.setLong(16, this.creatorUId);
            preparedStatement.setLong(17, this.createTs);
            preparedStatement.setLong(18, this.changerUId);
            preparedStatement.setLong(19, this.changeTs);
            preparedStatement.setLong(20, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "KillJob: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkState(Integer n) {
        switch (n) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : KillJob", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "seVersion : " + this.seVersion, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "state : " + this.state, 2);
        SDMSThread.doTrace(null, "exitCode : " + this.exitCode, 2);
        SDMSThread.doTrace(null, "commandline : " + this.commandline, 2);
        SDMSThread.doTrace(null, "logfile : " + this.logfile, 2);
        SDMSThread.doTrace(null, "errlogfile : " + this.errlogfile, 2);
        SDMSThread.doTrace(null, "pid : " + this.pid, 2);
        SDMSThread.doTrace(null, "extPid : " + this.extPid, 2);
        SDMSThread.doTrace(null, "errorMsg : " + this.errorMsg, 2);
        SDMSThread.doTrace(null, "runnableTs : " + this.runnableTs, 2);
        SDMSThread.doTrace(null, "startTs : " + this.startTs, 2);
        SDMSThread.doTrace(null, "finishTs : " + this.finishTs, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "seId        : " + this.seId + "\n" + string + "seVersion   : " + this.seVersion + "\n" + string + "smeId       : " + this.smeId + "\n" + string + "scopeId     : " + this.scopeId + "\n" + string + "state       : " + this.state + "\n" + string + "exitCode    : " + this.exitCode + "\n" + string + "commandline : " + this.commandline + "\n" + string + "logfile     : " + this.logfile + "\n" + string + "errlogfile  : " + this.errlogfile + "\n" + string + "pid         : " + this.pid + "\n" + string + "extPid      : " + this.extPid + "\n" + string + "errorMsg    : " + this.errorMsg + "\n" + string + "runnableTs  : " + this.runnableTs + "\n" + string + "startTs     : " + this.startTs + "\n" + string + "finishTs    : " + this.finishTs + "\n" + string + "creatorUId  : " + this.creatorUId + "\n" + string + "createTs    : " + this.createTs + "\n" + string + "changerUId  : " + this.changerUId + "\n" + string + "changeTs    : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

