/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSMember;
import de.independit.scheduler.server.repository.SDMSMemberGeneric;
import de.independit.scheduler.server.repository.SDMSMemberTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSMemberTableGeneric
extends SDMSTable {
    public static final String tableName = "MEMBER";
    public static SDMSMemberTable table = null;
    public static final String[] columnNames = new String[]{"ID", "G_ID", "U_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_gId;
    public static SDMSIndex idx_uId;
    public static SDMSIndex idx_gId_uId;

    public SDMSMemberTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Member"));
        }
        table = (SDMSMemberTable)this;
        table = (SDMSMemberTable)this;
        this.isVersioned = false;
        idx_gId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "gId");
        idx_uId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "uId");
        idx_gId_uId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "gId_uId");
    }

    public SDMSMember create(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSMember sDMSMember;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Member"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSMemberGeneric sDMSMemberGeneric = new SDMSMemberGeneric(systemEnvironment, l, l2, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSMemberGeneric.versions, true);
            table.put(systemEnvironment, sDMSMemberGeneric.id, sDMSMemberGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSMember = (SDMSMember)sDMSMemberGeneric.toProxy(systemEnvironment);
            sDMSMember.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSMember sDMSMember2 = (SDMSMember)sDMSMemberGeneric.toProxy(systemEnvironment);
            sDMSMember2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSMember)) {
            throw new AccessViolationException(sDMSMember.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSMember.touchMaster(systemEnvironment);
        return sDMSMember;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSMember sDMSMember) throws SDMSException {
        return sDMSMember.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            l8 = new Long(resultSet.getLong(2));
            l7 = new Long(resultSet.getLong(3));
            l6 = new Long(resultSet.getLong(4));
            l5 = new Long(resultSet.getLong(5));
            l4 = new Long(resultSet.getLong(6));
            l3 = new Long(resultSet.getLong(7));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Member: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSMemberGeneric(l9, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "G_ID" + string2 + ", " + string + "U_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_gId.check(((SDMSMemberGeneric)sDMSObject).gId, sDMSObject);
        string = string + "idx_gId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_uId.check(((SDMSMemberGeneric)sDMSObject).uId, sDMSObject);
        string = string + "idx_uId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).gId);
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).uId);
        bl = idx_gId_uId.check(sDMSKey, sDMSObject);
        string = string + "idx_gId_uId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_gId.put(systemEnvironment, ((SDMSMemberGeneric)sDMSObject).gId, sDMSObject, (1L & l) != 0L);
        idx_uId.put(systemEnvironment, ((SDMSMemberGeneric)sDMSObject).uId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).gId);
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).uId);
        idx_gId_uId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_gId.remove(systemEnvironment, ((SDMSMemberGeneric)sDMSObject).gId, sDMSObject);
        idx_uId.remove(systemEnvironment, ((SDMSMemberGeneric)sDMSObject).uId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).gId);
        sDMSKey.add(((SDMSMemberGeneric)sDMSObject).uId);
        idx_gId_uId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSMember getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSMember)table.get(systemEnvironment, l);
    }

    public static SDMSMember getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSMember)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSMember getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSMember)table.get(systemEnvironment, l, l2);
    }

    public static SDMSMember idx_gId_uId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSMember)idx_gId_uId.getUnique(systemEnvironment, object);
    }

    public static SDMSMember idx_gId_uId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSMember)idx_gId_uId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSMember idx_gId_uId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSMember)idx_gId_uId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

