/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectComment;
import de.independit.scheduler.server.repository.SDMSObjectCommentGeneric;
import de.independit.scheduler.server.repository.SDMSObjectCommentTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSObjectCommentTableGeneric
extends SDMSTable {
    public static final String tableName = "OBJECT_COMMENT";
    public static SDMSObjectCommentTable table = null;
    public static final String[] columnNames = new String[]{"ID", "OBJECT_ID", "OBJECT_TYPE", "INFO_TYPE", "SEQUENCE_NUMBER", "TAG", "DESCRIPTION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_objectId;
    public static SDMSIndex idx_objectType;

    public SDMSObjectCommentTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ObjectComment"));
        }
        table = (SDMSObjectCommentTable)this;
        table = (SDMSObjectCommentTable)this;
        this.isVersioned = true;
        idx_objectId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "objectId");
        idx_objectType = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "objectType");
    }

    public SDMSObjectComment create(SystemEnvironment systemEnvironment, Long l, Integer n, Integer n2, Integer n3, String string, String string2) throws SDMSException {
        SDMSObjectComment sDMSObjectComment;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ObjectComment"));
        }
        this.validate(systemEnvironment, l, n, n2, n3, string, string2, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSObjectCommentGeneric sDMSObjectCommentGeneric = new SDMSObjectCommentGeneric(systemEnvironment, l, n, n2, n3, string, string2, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSObjectCommentGeneric.versions, true);
            table.put(systemEnvironment, sDMSObjectCommentGeneric.id, sDMSObjectCommentGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSObjectComment = (SDMSObjectComment)sDMSObjectCommentGeneric.toProxy(systemEnvironment);
            sDMSObjectComment.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSObjectComment sDMSObjectComment2 = (SDMSObjectComment)sDMSObjectCommentGeneric.toProxy(systemEnvironment);
            sDMSObjectComment2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSObjectComment)) {
            throw new AccessViolationException(sDMSObjectComment.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSObjectComment.touchMaster(systemEnvironment);
        return sDMSObjectComment;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSObjectComment sDMSObjectComment) throws SDMSException {
        return sDMSObjectComment.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Integer n, Integer n2, Integer n3, String string, String string2, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
        if (!SDMSObjectCommentGeneric.checkObjectType(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectComment: $1 $2", (Object)"objectType", (Object)n));
        }
        if (!SDMSObjectCommentGeneric.checkInfoType(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectComment: $1 $2", (Object)"infoType", (Object)n2));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        String string2;
        Integer n;
        Integer n2;
        Integer n3;
        Long l7;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            l7 = new Long(resultSet.getLong(2));
            n3 = new Integer(resultSet.getInt(3));
            n2 = new Integer(resultSet.getInt(4));
            n = new Integer(resultSet.getInt(5));
            string2 = resultSet.getString(6);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            string = resultSet.getString(7);
            l6 = new Long(resultSet.getLong(8));
            l5 = new Long(resultSet.getLong(9));
            l4 = new Long(resultSet.getLong(10));
            l3 = new Long(resultSet.getLong(11));
            l2 = resultSet.getLong(12);
            l = resultSet.getLong(13);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ObjectComment: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSObjectCommentGeneric(l8, l7, n3, n2, n, string2, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "OBJECT_ID" + string2 + ", " + string + "OBJECT_TYPE" + string2 + ", " + string + "INFO_TYPE" + string2 + ", " + string + "SEQUENCE_NUMBER" + string2 + ", " + string + "TAG" + string2 + ", " + string + "DESCRIPTION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_objectId.check(((SDMSObjectCommentGeneric)sDMSObject).objectId, sDMSObject);
        string = string + "idx_objectId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_objectType.check(((SDMSObjectCommentGeneric)sDMSObject).objectType, sDMSObject);
        string = string + "idx_objectType: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_objectId.put(systemEnvironment, ((SDMSObjectCommentGeneric)sDMSObject).objectId, sDMSObject, (1L & l) != 0L);
        idx_objectType.put(systemEnvironment, ((SDMSObjectCommentGeneric)sDMSObject).objectType, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_objectId.remove(systemEnvironment, ((SDMSObjectCommentGeneric)sDMSObject).objectId, sDMSObject);
        idx_objectType.remove(systemEnvironment, ((SDMSObjectCommentGeneric)sDMSObject).objectType, sDMSObject);
    }

    public static SDMSObjectComment getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectComment)table.get(systemEnvironment, l);
    }

    public static SDMSObjectComment getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectComment)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSObjectComment getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSObjectComment)table.get(systemEnvironment, l, l2);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

