/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectInstance;
import de.independit.scheduler.server.repository.SDMSObjectInstanceTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSObjectInstanceGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_uniqueName = 2;
    public static final int nr_omId = 3;
    public static final int nr_modifyTs = 4;
    public static final int nr_removeTs = 5;
    public static final int nr_creatorUId = 6;
    public static final int nr_createTs = 7;
    public static final int nr_changerUId = 8;
    public static final int nr_changeTs = 9;
    public static String tableName = "OBJECT_INSTANCE";
    protected String uniqueName;
    protected Long omId;
    protected Long modifyTs;
    protected Long removeTs;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSObjectInstanceGeneric(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
        super(systemEnvironment, SDMSObjectInstanceTableGeneric.table);
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ObjectInstance) Length of $1 exceeds maximum length $2", (Object)"uniqueName", (Object)"256"));
        }
        this.uniqueName = string;
        this.omId = l;
        this.modifyTs = l2;
        this.removeTs = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
    }

    public String getUniqueName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.uniqueName;
    }

    public void setUniqueName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.uniqueName.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
            }
            SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 256) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ObjectInstance) Length of $1 exceeds maximum length $2", (Object)"uniqueName", (Object)"256"));
            }
            sDMSObjectInstanceGeneric.uniqueName = string;
            sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getOmId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.omId;
    }

    public void setOmId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.omId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
            }
            SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
            sDMSObjectInstanceGeneric.omId = l;
            sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 3L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getModifyTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.modifyTs;
    }

    public void setModifyTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.modifyTs)) {
            return;
        }
        if (l == null && this.modifyTs == null) {
            return;
        }
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
        }
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.modifyTs = l;
        sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public Long getRemoveTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.removeTs;
    }

    public void setRemoveTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.removeTs)) {
            return;
        }
        if (l == null && this.removeTs == null) {
            return;
        }
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
        }
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.removeTs = l;
        sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
        }
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.creatorUId = l;
        sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ObjectInstance) Change of system object not allowed"));
        }
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.createTs = l;
        sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.changerUId = l;
        sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric = this;
        if (sDMSObjectInstanceGeneric.versions.o_v == null || sDMSObjectInstanceGeneric.versions.o_v.size() == 0 || sDMSObjectInstanceGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
        }
        sDMSObjectInstanceGeneric.changeTs = l;
        sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSObjectInstanceGeneric != this) {
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric, 0L);
        }
    }

    public SDMSObjectInstanceGeneric set_OmIdUniqueName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSObjectInstanceGeneric sDMSObjectInstanceGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ObjectInstance) Change of system object not allowed"));
            }
            sDMSObjectInstanceGeneric = (SDMSObjectInstanceGeneric)this.change(systemEnvironment);
            sDMSObjectInstanceGeneric.omId = l;
            if (string != null && string.length() > 256) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290025", "(ObjectInstance) Length of $1 exceeds maximum length $2", (Object)"changeTs", (Object)"256"));
            }
            sDMSObjectInstanceGeneric.uniqueName = string;
            sDMSObjectInstanceGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSObjectInstanceGeneric.changeTs = systemEnvironment.txTime();
            sDMSObjectInstanceGeneric.versions.table.index(systemEnvironment, sDMSObjectInstanceGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSObjectInstanceGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSObjectInstance(this);
    }

    protected SDMSObjectInstanceGeneric(Long l, String string, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, Long l8, long l9, long l10) {
        this.id = l;
        this.uniqueName = string;
        this.omId = l2;
        this.modifyTs = l3;
        this.removeTs = l4;
        this.creatorUId = l5;
        this.createTs = l6;
        this.changerUId = l7;
        this.changeTs = l8;
        this.validFrom = l9;
        this.validTo = l10;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "OBJECT_INSTANCE" + string3 + " (" + "ID" + ", " + string2 + "UNIQUE_NAME" + string3 + ", " + string2 + "OM_ID" + string3 + ", " + string2 + "MODIFY_TS" + string3 + ", " + string2 + "REMOVE_TS" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSObjectInstanceGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ObjectInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setString(2, this.uniqueName);
            preparedStatement.setLong(3, this.omId);
            if (this.modifyTs == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.modifyTs);
            }
            if (this.removeTs == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.removeTs);
            }
            preparedStatement.setLong(6, this.creatorUId);
            preparedStatement.setLong(7, this.createTs);
            preparedStatement.setLong(8, this.changerUId);
            preparedStatement.setLong(9, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ObjectInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "OBJECT_INSTANCE" + string3 + " WHERE ID = ?";
                SDMSObjectInstanceGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ObjectInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ObjectInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "OBJECT_INSTANCE" + string3 + " SET " + "" + string2 + "UNIQUE_NAME" + string3 + " = ? " + ", " + string2 + "OM_ID" + string3 + " = ? " + ", " + string2 + "MODIFY_TS" + string3 + " = ? " + ", " + string2 + "REMOVE_TS" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSObjectInstanceGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ObjectInstance: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setString(1, this.uniqueName);
            preparedStatement.setLong(2, this.omId);
            if (this.modifyTs == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.modifyTs);
            }
            if (this.removeTs == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.removeTs);
            }
            preparedStatement.setLong(5, this.creatorUId);
            preparedStatement.setLong(6, this.createTs);
            preparedStatement.setLong(7, this.changerUId);
            preparedStatement.setLong(8, this.changeTs);
            preparedStatement.setLong(9, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ObjectInstance: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ObjectInstance", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "uniqueName : " + this.uniqueName, 2);
        SDMSThread.doTrace(null, "omId : " + this.omId, 2);
        SDMSThread.doTrace(null, "modifyTs : " + this.modifyTs, 2);
        SDMSThread.doTrace(null, "removeTs : " + this.removeTs, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "uniqueName : " + this.uniqueName + "\n" + string + "omId       : " + this.omId + "\n" + string + "modifyTs   : " + this.modifyTs + "\n" + string + "removeTs   : " + this.removeTs + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

