/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSObjectMonitor;
import de.independit.scheduler.server.repository.SDMSObjectMonitorGeneric;
import de.independit.scheduler.server.repository.SDMSObjectMonitorTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSObjectMonitorTableGeneric
extends SDMSTable {
    public static final String tableName = "OBJECT_MONITOR";
    public static SDMSObjectMonitorTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NAME", "OWNER_ID", "WT_ID", "RECREATE_HANDLING", "WATCH_SE_ID", "DELETE_AMOUNT", "DELETE_BASE", "EVENT_DELETE_AMOUNT", "EVENT_DELETE_BASE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_name;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_wtId;
    public static SDMSIndex idx_recreateHandling;
    public static SDMSIndex idx_watchSeId;

    public SDMSObjectMonitorTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ObjectMonitor"));
        }
        table = (SDMSObjectMonitorTable)this;
        table = (SDMSObjectMonitorTable)this;
        this.isVersioned = false;
        idx_name = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "name");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_wtId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "wtId");
        idx_recreateHandling = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "recreateHandling");
        idx_watchSeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "watchSeId");
    }

    public SDMSObjectMonitor create(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Integer n4, Integer n5) throws SDMSException {
        SDMSObjectMonitor sDMSObjectMonitor;
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        Long l6 = systemEnvironment.cEnv.uid();
        Long l7 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ObjectMonitor"));
        }
        this.validate(systemEnvironment, string, l, l2, n, l3, n2, n3, n4, n5, l4, l5, l6, l7);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSObjectMonitorGeneric sDMSObjectMonitorGeneric = new SDMSObjectMonitorGeneric(systemEnvironment, string, l, l2, n, l3, n2, n3, n4, n5, l4, l5, l6, l7);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSObjectMonitorGeneric.versions, true);
            table.put(systemEnvironment, sDMSObjectMonitorGeneric.id, sDMSObjectMonitorGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSObjectMonitor = (SDMSObjectMonitor)sDMSObjectMonitorGeneric.toProxy(systemEnvironment);
            sDMSObjectMonitor.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSObjectMonitor sDMSObjectMonitor2 = (SDMSObjectMonitor)sDMSObjectMonitorGeneric.toProxy(systemEnvironment);
            sDMSObjectMonitor2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSObjectMonitor)) {
            throw new AccessViolationException(sDMSObjectMonitor.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSObjectMonitor;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSObjectMonitor sDMSObjectMonitor) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, Long l, Long l2, Integer n, Long l3, Integer n2, Integer n3, Integer n4, Integer n5, Long l4, Long l5, Long l6, Long l7) throws SDMSException {
        if (!SDMSObjectMonitorGeneric.checkRecreateHandling(n)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectMonitor: $1 $2", (Object)"recreateHandling", (Object)n));
        }
        if (!SDMSObjectMonitorGeneric.checkDeleteBase(n3)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectMonitor: $1 $2", (Object)"deleteBase", (Object)n3));
        }
        if (!SDMSObjectMonitorGeneric.checkEventDeleteBase(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ObjectMonitor: $1 $2", (Object)"eventDeleteBase", (Object)n5));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Long l7;
        Integer n5;
        Long l8;
        Long l9;
        String string;
        Long l10;
        try {
            l10 = new Long(resultSet.getLong(1));
            string = resultSet.getString(2);
            l9 = new Long(resultSet.getLong(3));
            l8 = new Long(resultSet.getLong(4));
            n5 = new Integer(resultSet.getInt(5));
            l7 = new Long(resultSet.getLong(6));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n4 = new Integer(resultSet.getInt(7));
            if (resultSet.wasNull()) {
                n4 = null;
            }
            n3 = new Integer(resultSet.getInt(8));
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = new Integer(resultSet.getInt(9));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = new Integer(resultSet.getInt(10));
            if (resultSet.wasNull()) {
                n = null;
            }
            l6 = new Long(resultSet.getLong(11));
            l5 = new Long(resultSet.getLong(12));
            l4 = new Long(resultSet.getLong(13));
            l3 = new Long(resultSet.getLong(14));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ObjectMonitor: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSObjectMonitorGeneric(l10, string, l9, l8, n5, l7, n4, n3, n2, n, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NAME" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "WT_ID" + string2 + ", " + string + "RECREATE_HANDLING" + string2 + ", " + string + "WATCH_SE_ID" + string2 + ", " + string + "DELETE_AMOUNT" + string2 + ", " + string + "DELETE_BASE" + string2 + ", " + string + "EVENT_DELETE_AMOUNT" + string2 + ", " + string + "EVENT_DELETE_BASE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_name.check(((SDMSObjectMonitorGeneric)sDMSObject).name, sDMSObject);
        string = string + "idx_name: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSObjectMonitorGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_wtId.check(((SDMSObjectMonitorGeneric)sDMSObject).wtId, sDMSObject);
        string = string + "idx_wtId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_recreateHandling.check(((SDMSObjectMonitorGeneric)sDMSObject).recreateHandling, sDMSObject);
        string = string + "idx_recreateHandling: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_watchSeId.check(((SDMSObjectMonitorGeneric)sDMSObject).watchSeId, sDMSObject);
        string = string + "idx_watchSeId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_name.put(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).name, sDMSObject, (1L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).ownerId, sDMSObject, (2L & l) != 0L);
        idx_wtId.put(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).wtId, sDMSObject, (4L & l) != 0L);
        idx_recreateHandling.put(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).recreateHandling, sDMSObject, (8L & l) != 0L);
        idx_watchSeId.put(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).watchSeId, sDMSObject, (0x10L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_name.remove(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).name, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).ownerId, sDMSObject);
        idx_wtId.remove(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).wtId, sDMSObject);
        idx_recreateHandling.remove(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).recreateHandling, sDMSObject);
        idx_watchSeId.remove(systemEnvironment, ((SDMSObjectMonitorGeneric)sDMSObject).watchSeId, sDMSObject);
    }

    public static SDMSObjectMonitor getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectMonitor)table.get(systemEnvironment, l);
    }

    public static SDMSObjectMonitor getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSObjectMonitor)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSObjectMonitor getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSObjectMonitor)table.get(systemEnvironment, l, l2);
    }

    public static SDMSObjectMonitor idx_name_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSObjectMonitor)idx_name.getUnique(systemEnvironment, object);
    }

    public static SDMSObjectMonitor idx_name_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSObjectMonitor)idx_name.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSObjectMonitor idx_name_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSObjectMonitor)idx_name.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

