/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTableGeneric;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSParameterDefinitionGeneric
extends SDMSObject
implements Cloneable {
    public static final int REFERENCE = 10;
    public static final int CHILDREFERENCE = 20;
    public static final int CONSTANT = 30;
    public static final int RESULT = 40;
    public static final int PARAMETER = 50;
    public static final int EXPRESSION = 60;
    public static final int IMPORT = 70;
    public static final int DYNAMIC = 80;
    public static final int DYNAMICVALUE = 81;
    public static final int LOCAL_CONSTANT = 90;
    public static final int RESOURCEREFERENCE = 91;
    public static final int NONE = 0;
    public static final int AVG = 61;
    public static final int COUNT = 62;
    public static final int MIN = 63;
    public static final int MAX = 64;
    public static final int SUM = 65;
    public static final int nr_id = 1;
    public static final int nr_seId = 2;
    public static final int nr_name = 3;
    public static final int nr_type = 4;
    public static final int nr_aggFunction = 5;
    public static final int nr_defaultValue = 6;
    public static final int nr_isLocal = 7;
    public static final int nr_linkPdId = 8;
    public static final int nr_exportName = 9;
    public static final int nr_isLong = 10;
    public static final int nr_creatorUId = 11;
    public static final int nr_createTs = 12;
    public static final int nr_changerUId = 13;
    public static final int nr_changeTs = 14;
    public static String tableName = "PARAMETER_DEFINITION";
    protected Long seId;
    protected String name;
    protected Integer type;
    protected Integer aggFunction;
    protected String defaultValue;
    protected Boolean isLocal;
    protected Long linkPdId;
    protected String exportName;
    protected Boolean isLong;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSParameterDefinitionGeneric(SystemEnvironment systemEnvironment, Long l, String string, Integer n, Integer n2, String string2, Boolean bl, Long l2, String string3, Boolean bl2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSParameterDefinitionTableGeneric.table);
        this.seId = l;
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
        }
        this.name = string;
        this.type = n;
        this.aggFunction = n2;
        if (string2 != null && string2.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"defaultValue", (Object)"256"));
        }
        this.defaultValue = string2;
        this.isLocal = bl;
        this.linkPdId = l2;
        if (string3 != null && string3.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"exportName", (Object)"64"));
        }
        this.exportName = string3;
        this.isLong = bl2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getSeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.seId;
    }

    public void setSeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.seId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
            }
            SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
            sDMSParameterDefinitionGeneric.seId = l;
            sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.name;
    }

    public void setName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (this.name.equals(string)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
            }
            SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"name", (Object)"64"));
            }
            sDMSParameterDefinitionGeneric.name = string;
            sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getType(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.type;
    }

    public String getTypeAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getType(systemEnvironment);
        switch (n) {
            case 10: {
                return "REFERENCE";
            }
            case 20: {
                return "CHILDREFERENCE";
            }
            case 30: {
                return "CONSTANT";
            }
            case 40: {
                return "RESULT";
            }
            case 50: {
                return "PARAMETER";
            }
            case 60: {
                return "EXPRESSION";
            }
            case 70: {
                return "IMPORT";
            }
            case 80: {
                return "DYNAMIC";
            }
            case 81: {
                return "DYNAMICVALUE";
            }
            case 90: {
                return "LOCAL_CONSTANT";
            }
            case 91: {
                return "RESOURCEREFERENCE";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ParameterDefinition.type: $1", (Object)this.getType(systemEnvironment)));
    }

    public void setType(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.type.equals(n)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.type = n;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Integer getAggFunction(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.aggFunction;
    }

    public String getAggFunctionAsString(SystemEnvironment systemEnvironment) throws SDMSException {
        Integer n = this.getAggFunction(systemEnvironment);
        switch (n) {
            case 0: {
                return "NONE";
            }
            case 61: {
                return "AVG";
            }
            case 62: {
                return "COUNT";
            }
            case 63: {
                return "MIN";
            }
            case 64: {
                return "MAX";
            }
            case 65: {
                return "SUM";
            }
        }
        throw new FatalException(new SDMSMessage(systemEnvironment, "01205252242", "Unknown ParameterDefinition.aggFunction: $1", (Object)this.getAggFunction(systemEnvironment)));
    }

    public void setAggFunction(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.aggFunction.equals(n)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.aggFunction = n;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public String getDefaultValue(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.defaultValue;
    }

    public void setDefaultValue(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.defaultValue)) {
            return;
        }
        if (string == null && this.defaultValue == null) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 256) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"defaultValue", (Object)"256"));
        }
        sDMSParameterDefinitionGeneric.defaultValue = string;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Boolean getIsLocal(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isLocal;
    }

    public void setIsLocal(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isLocal.equals(bl)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.isLocal = bl;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Long getLinkPdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.linkPdId;
    }

    public void setLinkPdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.linkPdId)) {
            return;
        }
        if (l == null && this.linkPdId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
            }
            SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
            sDMSParameterDefinitionGeneric.linkPdId = l;
            sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public String getExportName(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.exportName;
    }

    public void setExportName(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.exportName)) {
            return;
        }
        if (string == null && this.exportName == null) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 64) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"exportName", (Object)"64"));
        }
        sDMSParameterDefinitionGeneric.exportName = string;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Boolean getIsLong(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.isLong;
    }

    public void setIsLong(SystemEnvironment systemEnvironment, Boolean bl) throws SDMSException {
        if (this.isLong.equals(bl)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.isLong = bl;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.creatorUId = l;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ParameterDefinition) Change of system object not allowed"));
        }
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.createTs = l;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.changerUId = l;
        sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric = this;
        if (sDMSParameterDefinitionGeneric.versions.o_v == null || sDMSParameterDefinitionGeneric.versions.o_v.size() == 0 || sDMSParameterDefinitionGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
        }
        sDMSParameterDefinitionGeneric.changeTs = l;
        sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSParameterDefinitionGeneric != this) {
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric, 0L);
        }
    }

    public SDMSParameterDefinitionGeneric set_SeIdName(SystemEnvironment systemEnvironment, Long l, String string) throws SDMSException {
        SDMSParameterDefinitionGeneric sDMSParameterDefinitionGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ParameterDefinition) Change of system object not allowed"));
            }
            sDMSParameterDefinitionGeneric = (SDMSParameterDefinitionGeneric)this.change(systemEnvironment);
            sDMSParameterDefinitionGeneric.seId = l;
            if (string != null && string.length() > 64) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01201290026", "(ParameterDefinition) Length of $1 exceeds maximum length $2", (Object)"changeTs", (Object)"64"));
            }
            sDMSParameterDefinitionGeneric.name = string;
            sDMSParameterDefinitionGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSParameterDefinitionGeneric.changeTs = systemEnvironment.txTime();
            sDMSParameterDefinitionGeneric.versions.table.index(systemEnvironment, sDMSParameterDefinitionGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSParameterDefinitionGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSParameterDefinition(this);
    }

    protected SDMSParameterDefinitionGeneric(Long l, Long l2, String string, Integer n, Integer n2, String string2, Boolean bl, Long l3, String string3, Boolean bl2, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.seId = l2;
        this.name = string;
        this.type = n;
        this.aggFunction = n2;
        this.defaultValue = string2;
        this.isLocal = bl;
        this.linkPdId = l3;
        this.exportName = string3;
        this.isLong = bl2;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "PARAMETER_DEFINITION" + string3 + " (" + "ID" + ", " + string2 + "SE_ID" + string3 + ", " + string2 + "NAME" + string3 + ", " + string2 + "TYPE" + string3 + ", " + string2 + "AGG_FUNCTION" + string3 + ", " + string2 + "DEFAULTVALUE" + string3 + ", " + string2 + "IS_LOCAL" + string3 + ", " + string2 + "LINK_PD_ID" + string3 + ", " + string2 + "EXPORT_NAME" + string3 + ", " + string2 + "IS_LONG" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ", VALID_FROM, VALID_TO" + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?, ?" + ")";
                SDMSParameterDefinitionGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ParameterDefinition: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.seId);
            preparedStatement.setString(3, this.name);
            preparedStatement.setInt(4, this.type);
            preparedStatement.setInt(5, this.aggFunction);
            if (this.defaultValue == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.defaultValue);
            }
            preparedStatement.setInt(7, this.isLocal != false ? 1 : 0);
            if (this.linkPdId == null) {
                preparedStatement.setNull(8, 4);
            } else {
                preparedStatement.setLong(8, this.linkPdId);
            }
            if (this.exportName == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.exportName);
            }
            preparedStatement.setInt(10, this.isLong != false ? 1 : 0);
            preparedStatement.setLong(11, this.creatorUId);
            preparedStatement.setLong(12, this.createTs);
            preparedStatement.setLong(13, this.changerUId);
            preparedStatement.setLong(14, this.changeTs);
            preparedStatement.setLong(15, systemEnvironment.tx.versionId);
            preparedStatement.setLong(16, Long.MAX_VALUE);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ParameterDefinition: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.closeDBObject(systemEnvironment);
        this.insertDBObject(systemEnvironment);
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        this.closeDBObject(systemEnvironment);
    }

    private void closeDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = systemEnvironment.dbConnection.getMetaData().getDriverName();
                boolean bl = string2.startsWith("PostgreSQL");
                String string3 = SystemEnvironment.SQUOTE;
                String string4 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string3 + "PARAMETER_DEFINITION" + string4 + " SET VALID_TO = ?, " + "    CHANGE_TS = ?, " + "    CHANGER_U_ID = ? " + "WHERE ID = ?" + "  AND VALID_TO = " + (bl ? "CAST ('9223372036854775807' AS DECIMAL)" : "9223372036854775807");
                SDMSParameterDefinitionGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181955", "ParameterDefinition : $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, systemEnvironment.tx.versionId);
            preparedStatement.setLong(2, this.changeTs);
            preparedStatement.setLong(3, this.changerUId);
            preparedStatement.setLong(4, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181956", "ParameterDefinition: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    public static boolean checkType(Integer n) {
        switch (n) {
            case 10: 
            case 20: 
            case 30: 
            case 40: 
            case 50: 
            case 60: 
            case 70: 
            case 80: 
            case 81: 
            case 90: 
            case 91: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkAggFunction(Integer n) {
        switch (n) {
            case 0: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ParameterDefinition", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "seId : " + this.seId, 2);
        SDMSThread.doTrace(null, "name : " + this.name, 2);
        SDMSThread.doTrace(null, "type : " + this.type, 2);
        SDMSThread.doTrace(null, "aggFunction : " + this.aggFunction, 2);
        SDMSThread.doTrace(null, "defaultValue : " + this.defaultValue, 2);
        SDMSThread.doTrace(null, "isLocal : " + this.isLocal, 2);
        SDMSThread.doTrace(null, "linkPdId : " + this.linkPdId, 2);
        SDMSThread.doTrace(null, "exportName : " + this.exportName, 2);
        SDMSThread.doTrace(null, "isLong : " + this.isLong, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "seId         : " + this.seId + "\n" + string + "name         : " + this.name + "\n" + string + "type         : " + this.type + "\n" + string + "aggFunction  : " + this.aggFunction + "\n" + string + "defaultValue : " + this.defaultValue + "\n" + string + "isLocal      : " + this.isLocal + "\n" + string + "linkPdId     : " + this.linkPdId + "\n" + string + "exportName   : " + this.exportName + "\n" + string + "isLong       : " + this.isLong + "\n" + string + "creatorUId   : " + this.creatorUId + "\n" + string + "createTs     : " + this.createTs + "\n" + string + "changerUId   : " + this.changerUId + "\n" + string + "changeTs     : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

