/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSPool;
import de.independit.scheduler.server.repository.SDMSPoolGeneric;
import de.independit.scheduler.server.repository.SDMSPoolTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSPoolTableGeneric
extends SDMSTable {
    public static final String tableName = "POOL";
    public static SDMSPoolTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NR_ID", "SCOPE_ID", "OWNER_ID", "MANAGER_ID", "DIST_ID", "DEFINED_AMOUNT", "AMOUNT", "FREE_AMOUNT", "CHILD_ALLOCATED", "EVALUATION_CYCLE", "NEXT_EVALUATION_TIME", "TAG", "TRACE_INTERVAL", "TRACE_BASE", "TRACE_BASE_MULTIPLIER", "TD0_AVG", "TD1_AVG", "TD2_AVG", "LW_AVG", "LAST_EVAL", "LAST_WRITE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_scopeId;
    public static SDMSIndex idx_ownerId;
    public static SDMSIndex idx_managerId;
    public static SDMSIndex idx_tag;
    public static SDMSIndex idx_nrId_scopeId;

    public SDMSPoolTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "Pool"));
        }
        table = (SDMSPoolTable)this;
        table = (SDMSPoolTable)this;
        this.isVersioned = false;
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_scopeId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "scopeId");
        idx_ownerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "ownerId");
        idx_managerId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "managerId");
        idx_tag = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "tag");
        idx_nrId_scopeId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "nrId_scopeId");
    }

    public SDMSPool create(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Long l6, String string, Integer n6, Integer n7, Integer n8, Float f, Float f2, Float f3, Float f4, Long l7, Long l8) throws SDMSException {
        SDMSPool sDMSPool;
        Long l9 = systemEnvironment.cEnv.uid();
        Long l10 = systemEnvironment.txTime();
        Long l11 = systemEnvironment.cEnv.uid();
        Long l12 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "Pool"));
        }
        this.validate(systemEnvironment, l, l2, l3, l4, l5, n, n2, n3, n4, n5, l6, string, n6, n7, n8, f, f2, f3, f4, l7, l8, l9, l10, l11, l12);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSPoolGeneric sDMSPoolGeneric = new SDMSPoolGeneric(systemEnvironment, l, l2, l3, l4, l5, n, n2, n3, n4, n5, l6, string, n6, n7, n8, f, f2, f3, f4, l7, l8, l9, l10, l11, l12);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSPoolGeneric.versions, true);
            table.put(systemEnvironment, sDMSPoolGeneric.id, sDMSPoolGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSPool = (SDMSPool)sDMSPoolGeneric.toProxy(systemEnvironment);
            sDMSPool.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSPool sDMSPool2 = (SDMSPool)sDMSPoolGeneric.toProxy(systemEnvironment);
            sDMSPool2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSPool)) {
            throw new AccessViolationException(sDMSPool.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSPool;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSPool sDMSPool) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Integer n, Integer n2, Integer n3, Integer n4, Integer n5, Long l6, String string, Integer n6, Integer n7, Integer n8, Float f, Float f2, Float f3, Float f4, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Long l8;
        Float f;
        Float f2;
        Float f3;
        Float f4;
        Integer n;
        Integer n2;
        Integer n3;
        String string;
        Long l9;
        Integer n4;
        Integer n5;
        Integer n6;
        Integer n7;
        Integer n8;
        Long l10;
        Long l11;
        Long l12;
        Long l13;
        Long l14;
        Long l15;
        try {
            l15 = new Long(resultSet.getLong(1));
            l14 = new Long(resultSet.getLong(2));
            l13 = new Long(resultSet.getLong(3));
            l12 = new Long(resultSet.getLong(4));
            l11 = new Long(resultSet.getLong(5));
            if (resultSet.wasNull()) {
                l11 = null;
            }
            l10 = new Long(resultSet.getLong(6));
            if (resultSet.wasNull()) {
                l10 = null;
            }
            n8 = new Integer(resultSet.getInt(7));
            n7 = new Integer(resultSet.getInt(8));
            n6 = new Integer(resultSet.getInt(9));
            n5 = new Integer(resultSet.getInt(10));
            n4 = new Integer(resultSet.getInt(11));
            if (resultSet.wasNull()) {
                n4 = null;
            }
            l9 = new Long(resultSet.getLong(12));
            string = resultSet.getString(13);
            if (resultSet.wasNull()) {
                string = null;
            }
            n3 = new Integer(resultSet.getInt(14));
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = new Integer(resultSet.getInt(15));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            n = new Integer(resultSet.getInt(16));
            f4 = new Float(resultSet.getFloat(17));
            f3 = new Float(resultSet.getFloat(18));
            f2 = new Float(resultSet.getFloat(19));
            f = new Float(resultSet.getFloat(20));
            l8 = new Long(resultSet.getLong(21));
            l7 = new Long(resultSet.getLong(22));
            l6 = new Long(resultSet.getLong(23));
            l5 = new Long(resultSet.getLong(24));
            l4 = new Long(resultSet.getLong(25));
            l3 = new Long(resultSet.getLong(26));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "Pool: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSPoolGeneric(l15, l14, l13, l12, l11, l10, n8, n7, n6, n5, n4, l9, string, n3, n2, n, f4, f3, f2, f, l8, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NR_ID" + string2 + ", " + string + "SCOPE_ID" + string2 + ", " + string + "OWNER_ID" + string2 + ", " + string + "MANAGER_ID" + string2 + ", " + string + "DIST_ID" + string2 + ", " + string + "DEFINED_AMOUNT" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "FREE_AMOUNT" + string2 + ", " + string + "CHILD_ALLOCATED" + string2 + ", " + string + "EVALUATION_CYCLE" + string2 + ", " + string + "NEXT_EVALUATION_TIME" + string2 + ", " + string + "TAG" + string2 + ", " + string + "TRACE_INTERVAL" + string2 + ", " + string + "TRACE_BASE" + string2 + ", " + string + "TRACE_BASE_MULTIPLIER" + string2 + ", " + string + "TD0_AVG" + string2 + ", " + string + "TD1_AVG" + string2 + ", " + string + "TD2_AVG" + string2 + ", " + string + "LW_AVG" + string2 + ", " + string + "LAST_EVAL" + string2 + ", " + string + "LAST_WRITE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_nrId.check(((SDMSPoolGeneric)sDMSObject).nrId, sDMSObject);
        string = string + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_scopeId.check(((SDMSPoolGeneric)sDMSObject).scopeId, sDMSObject);
        string = string + "idx_scopeId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_ownerId.check(((SDMSPoolGeneric)sDMSObject).ownerId, sDMSObject);
        string = string + "idx_ownerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_managerId.check(((SDMSPoolGeneric)sDMSObject).managerId, sDMSObject);
        string = string + "idx_managerId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_tag.check(((SDMSPoolGeneric)sDMSObject).tag, sDMSObject);
        string = string + "idx_tag: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).scopeId);
        bl = idx_nrId_scopeId.check(sDMSKey, sDMSObject);
        string = string + "idx_nrId_scopeId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_nrId.put(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).nrId, sDMSObject, (1L & l) != 0L);
        idx_scopeId.put(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).scopeId, sDMSObject, (2L & l) != 0L);
        idx_ownerId.put(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).ownerId, sDMSObject, (4L & l) != 0L);
        idx_managerId.put(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).managerId, sDMSObject, (8L & l) != 0L);
        idx_tag.put(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).tag, sDMSObject, (0x10L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).scopeId);
        idx_nrId_scopeId.put(systemEnvironment, sDMSKey, sDMSObject, (0x20L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_nrId.remove(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).nrId, sDMSObject);
        idx_scopeId.remove(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).scopeId, sDMSObject);
        idx_ownerId.remove(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).ownerId, sDMSObject);
        idx_managerId.remove(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).managerId, sDMSObject);
        idx_tag.remove(systemEnvironment, ((SDMSPoolGeneric)sDMSObject).tag, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).nrId);
        sDMSKey.add(((SDMSPoolGeneric)sDMSObject).scopeId);
        idx_nrId_scopeId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSPool getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPool)table.get(systemEnvironment, l);
    }

    public static SDMSPool getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSPool)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSPool getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSPool)table.get(systemEnvironment, l, l2);
    }

    public static SDMSPool idx_nrId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPool)idx_nrId_scopeId.getUnique(systemEnvironment, object);
    }

    public static SDMSPool idx_nrId_scopeId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSPool)idx_nrId_scopeId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSPool idx_nrId_scopeId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSPool)idx_nrId_scopeId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

