/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceRequirement;
import de.independit.scheduler.server.repository.SDMSResourceRequirementGeneric;
import de.independit.scheduler.server.repository.SDMSResourceRequirementTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceRequirementTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_REQUIREMENT";
    public static SDMSResourceRequirementTable table = null;
    public static final String[] columnNames = new String[]{"ID", "NR_ID", "SE_ID", "AMOUNT", "KEEP_MODE", "IS_STICKY", "STICKY_NAME", "STICKY_PARENT", "RSMP_ID", "EXPIRED_AMOUNT", "EXPIRED_BASE", "IGNORE_ON_RERUN", "LOCKMODE", "CONDITION", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_nrId;
    public static SDMSIndex idx_seId;
    public static SDMSIndex idx_rsmpId;
    public static SDMSIndex idx_seId_nrId;

    public SDMSResourceRequirementTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceRequirement"));
        }
        table = (SDMSResourceRequirementTable)this;
        table = (SDMSResourceRequirementTable)this;
        this.isVersioned = true;
        idx_nrId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "nrId");
        idx_seId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "seId");
        idx_rsmpId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rsmpId");
        idx_seId_nrId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "seId_nrId");
    }

    public SDMSResourceRequirement create(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Boolean bl, String string, Long l3, Long l4, Integer n3, Integer n4, Boolean bl2, Integer n5, String string2) throws SDMSException {
        SDMSResourceRequirement sDMSResourceRequirement;
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        Long l7 = systemEnvironment.cEnv.uid();
        Long l8 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceRequirement"));
        }
        this.validate(systemEnvironment, l, l2, n, n2, bl, string, l3, l4, n3, n4, bl2, n5, string2, l5, l6, l7, l8);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceRequirementGeneric sDMSResourceRequirementGeneric = new SDMSResourceRequirementGeneric(systemEnvironment, l, l2, n, n2, bl, string, l3, l4, n3, n4, bl2, n5, string2, l5, l6, l7, l8);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceRequirementGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceRequirementGeneric.id, sDMSResourceRequirementGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceRequirement = (SDMSResourceRequirement)sDMSResourceRequirementGeneric.toProxy(systemEnvironment);
            sDMSResourceRequirement.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceRequirement sDMSResourceRequirement2 = (SDMSResourceRequirement)sDMSResourceRequirementGeneric.toProxy(systemEnvironment);
            sDMSResourceRequirement2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceRequirement)) {
            throw new AccessViolationException(sDMSResourceRequirement.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceRequirement.touchMaster(systemEnvironment);
        return sDMSResourceRequirement;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceRequirement sDMSResourceRequirement) throws SDMSException {
        return sDMSResourceRequirement.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, Integer n, Integer n2, Boolean bl, String string, Long l3, Long l4, Integer n3, Integer n4, Boolean bl2, Integer n5, String string2, Long l5, Long l6, Long l7, Long l8) throws SDMSException {
        if (!SDMSResourceRequirementGeneric.checkKeepMode(n2)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceRequirement: $1 $2", (Object)"keepMode", (Object)n2));
        }
        if (!SDMSResourceRequirementGeneric.checkExpiredBase(n4)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceRequirement: $1 $2", (Object)"expiredBase", (Object)n4));
        }
        if (!SDMSResourceRequirementGeneric.checkLockmode(n5)) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182023", "ResourceRequirement: $1 $2", (Object)"lockmode", (Object)n5));
        }
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Integer n;
        Boolean bl;
        Integer n2;
        Integer n3;
        Long l7;
        Long l8;
        String string2;
        Boolean bl2;
        Integer n4;
        Integer n5;
        Long l9;
        Long l10;
        Long l11;
        try {
            l11 = new Long(resultSet.getLong(1));
            l10 = new Long(resultSet.getLong(2));
            l9 = new Long(resultSet.getLong(3));
            n5 = new Integer(resultSet.getInt(4));
            if (resultSet.wasNull()) {
                n5 = null;
            }
            n4 = new Integer(resultSet.getInt(5));
            bl2 = new Boolean(resultSet.getInt(6) != 0);
            string2 = resultSet.getString(7);
            if (resultSet.wasNull()) {
                string2 = null;
            }
            l8 = new Long(resultSet.getLong(8));
            if (resultSet.wasNull()) {
                l8 = null;
            }
            l7 = new Long(resultSet.getLong(9));
            if (resultSet.wasNull()) {
                l7 = null;
            }
            n3 = new Integer(resultSet.getInt(10));
            if (resultSet.wasNull()) {
                n3 = null;
            }
            n2 = new Integer(resultSet.getInt(11));
            if (resultSet.wasNull()) {
                n2 = null;
            }
            bl = new Boolean(resultSet.getInt(12) != 0);
            n = new Integer(resultSet.getInt(13));
            if (resultSet.wasNull()) {
                n = null;
            }
            string = resultSet.getString(14);
            if (resultSet.wasNull()) {
                string = null;
            }
            l6 = new Long(resultSet.getLong(15));
            l5 = new Long(resultSet.getLong(16));
            l4 = new Long(resultSet.getLong(17));
            l3 = new Long(resultSet.getLong(18));
            l2 = resultSet.getLong(19);
            l = resultSet.getLong(20);
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceRequirement: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceRequirementGeneric(l11, l10, l9, n5, n4, bl2, string2, l8, l7, n3, n2, bl, n, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "NR_ID" + string2 + ", " + string + "SE_ID" + string2 + ", " + string + "AMOUNT" + string2 + ", " + string + "KEEP_MODE" + string2 + ", " + string + "IS_STICKY" + string2 + ", " + string + "STICKY_NAME" + string2 + ", " + string + "STICKY_PARENT" + string2 + ", " + string + "RSMP_ID" + string2 + ", " + string + "EXPIRED_AMOUNT" + string2 + ", " + string + "EXPIRED_BASE" + string2 + ", " + string + "IGNORE_ON_RERUN" + string2 + ", " + string + "LOCKMODE" + string2 + ", " + string + "CONDITION" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + ", VALID_FROM, VALID_TO " + " FROM " + string + this.tableName() + string2 + " WHERE VALID_TO >= " + (bl ? "CAST ('" + systemEnvironment.lowestActiveVersion + "' AS DECIMAL)" : "" + systemEnvironment.lowestActiveVersion) + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_nrId.check(((SDMSResourceRequirementGeneric)sDMSObject).nrId, sDMSObject);
        string = string + "idx_nrId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_seId.check(((SDMSResourceRequirementGeneric)sDMSObject).seId, sDMSObject);
        string = string + "idx_seId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rsmpId.check(((SDMSResourceRequirementGeneric)sDMSObject).rsmpId, sDMSObject);
        string = string + "idx_rsmpId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).seId);
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).nrId);
        bl = idx_seId_nrId.check(sDMSKey, sDMSObject);
        string = string + "idx_seId_nrId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_nrId.put(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).nrId, sDMSObject, (1L & l) != 0L);
        idx_seId.put(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).seId, sDMSObject, (2L & l) != 0L);
        idx_rsmpId.put(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).rsmpId, sDMSObject, (4L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).seId);
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).nrId);
        idx_seId_nrId.put(systemEnvironment, sDMSKey, sDMSObject, (8L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_nrId.remove(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).nrId, sDMSObject);
        idx_seId.remove(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).seId, sDMSObject);
        idx_rsmpId.remove(systemEnvironment, ((SDMSResourceRequirementGeneric)sDMSObject).rsmpId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).seId);
        sDMSKey.add(((SDMSResourceRequirementGeneric)sDMSObject).nrId);
        idx_seId_nrId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceRequirement getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceRequirement)table.get(systemEnvironment, l);
    }

    public static SDMSResourceRequirement getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceRequirement)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceRequirement getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceRequirement)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceRequirement idx_seId_nrId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceRequirement)idx_seId_nrId.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceRequirement idx_seId_nrId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceRequirement)idx_seId_nrId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceRequirement idx_seId_nrId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceRequirement)idx_seId_nrId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

