/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceState;
import de.independit.scheduler.server.repository.SDMSResourceStateTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSResourceStateGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_rsdId = 2;
    public static final int nr_rspId = 3;
    public static final int nr_creatorUId = 4;
    public static final int nr_createTs = 5;
    public static final int nr_changerUId = 6;
    public static final int nr_changeTs = 7;
    public static String tableName = "RESOURCE_STATE";
    protected Long rsdId;
    protected Long rspId;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSResourceStateGeneric(SystemEnvironment systemEnvironment, Long l, Long l2, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
        super(systemEnvironment, SDMSResourceStateTableGeneric.table);
        this.rsdId = l;
        this.rspId = l2;
        this.creatorUId = l3;
        this.createTs = l4;
        this.changerUId = l5;
        this.changeTs = l6;
    }

    public Long getRsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rsdId;
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.rsdId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceState) Change of system object not allowed"));
            }
            SDMSResourceStateGeneric sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
            sDMSResourceStateGeneric.rsdId = l;
            sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getRspId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rspId;
    }

    public void setRspId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.rspId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceState) Change of system object not allowed"));
            }
            SDMSResourceStateGeneric sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
            sDMSResourceStateGeneric.rspId = l;
            sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 6L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSResourceStateGeneric sDMSResourceStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceState) Change of system object not allowed"));
        }
        if (sDMSResourceStateGeneric.versions.o_v == null || sDMSResourceStateGeneric.versions.o_v.size() == 0 || sDMSResourceStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
        }
        sDMSResourceStateGeneric.creatorUId = l;
        sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceStateGeneric != this) {
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSResourceStateGeneric sDMSResourceStateGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(ResourceState) Change of system object not allowed"));
        }
        if (sDMSResourceStateGeneric.versions.o_v == null || sDMSResourceStateGeneric.versions.o_v.size() == 0 || sDMSResourceStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
        }
        sDMSResourceStateGeneric.createTs = l;
        sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceStateGeneric != this) {
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSResourceStateGeneric sDMSResourceStateGeneric = this;
        if (sDMSResourceStateGeneric.versions.o_v == null || sDMSResourceStateGeneric.versions.o_v.size() == 0 || sDMSResourceStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
        }
        sDMSResourceStateGeneric.changerUId = l;
        sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSResourceStateGeneric != this) {
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSResourceStateGeneric sDMSResourceStateGeneric = this;
        if (sDMSResourceStateGeneric.versions.o_v == null || sDMSResourceStateGeneric.versions.o_v.size() == 0 || sDMSResourceStateGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
        }
        sDMSResourceStateGeneric.changeTs = l;
        sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSResourceStateGeneric != this) {
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric, 0L);
        }
    }

    public SDMSResourceStateGeneric set_RsdIdRspId(SystemEnvironment systemEnvironment, Long l, Long l2) throws SDMSException {
        SDMSResourceStateGeneric sDMSResourceStateGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(ResourceState) Change of system object not allowed"));
            }
            sDMSResourceStateGeneric = (SDMSResourceStateGeneric)this.change(systemEnvironment);
            sDMSResourceStateGeneric.rsdId = l;
            sDMSResourceStateGeneric.rspId = l2;
            sDMSResourceStateGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSResourceStateGeneric.changeTs = systemEnvironment.txTime();
            sDMSResourceStateGeneric.versions.table.index(systemEnvironment, sDMSResourceStateGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSResourceStateGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSResourceState(this);
    }

    protected SDMSResourceStateGeneric(Long l, Long l2, Long l3, Long l4, Long l5, Long l6, Long l7, long l8, long l9) {
        this.id = l;
        this.rsdId = l2;
        this.rspId = l3;
        this.creatorUId = l4;
        this.createTs = l5;
        this.changerUId = l6;
        this.changeTs = l7;
        this.validFrom = l8;
        this.validTo = l9;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "RESOURCE_STATE" + string3 + " (" + "ID" + ", " + string2 + "RSD_ID" + string3 + ", " + string2 + "RSP_ID" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSResourceStateGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "ResourceState: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.rsdId);
            preparedStatement.setLong(3, this.rspId);
            preparedStatement.setLong(4, this.creatorUId);
            preparedStatement.setLong(5, this.createTs);
            preparedStatement.setLong(6, this.changerUId);
            preparedStatement.setLong(7, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "ResourceState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "RESOURCE_STATE" + string3 + " WHERE ID = ?";
                SDMSResourceStateGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "ResourceState: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "ResourceState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "RESOURCE_STATE" + string3 + " SET " + "" + string2 + "RSD_ID" + string3 + " = ? " + ", " + string2 + "RSP_ID" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSResourceStateGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "ResourceState: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.rsdId);
            preparedStatement.setLong(2, this.rspId);
            preparedStatement.setLong(3, this.creatorUId);
            preparedStatement.setLong(4, this.createTs);
            preparedStatement.setLong(5, this.changerUId);
            preparedStatement.setLong(6, this.changeTs);
            preparedStatement.setLong(7, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "ResourceState: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : ResourceState", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "rsdId : " + this.rsdId, 2);
        SDMSThread.doTrace(null, "rspId : " + this.rspId, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "rsdId      : " + this.rsdId + "\n" + string + "rspId      : " + this.rspId + "\n" + string + "creatorUId : " + this.creatorUId + "\n" + string + "createTs   : " + this.createTs + "\n" + string + "changerUId : " + this.changerUId + "\n" + string + "changeTs   : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

