/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.NotFoundException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.output.SDMSOutputContainer;
import de.independit.scheduler.server.parser.WithHash;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSNamedResource;
import de.independit.scheduler.server.repository.SDMSNamedResourceTable;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSOwnedObject;
import de.independit.scheduler.server.repository.SDMSParameterDefinition;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionProxyGeneric;
import de.independit.scheduler.server.repository.SDMSParameterDefinitionTable;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSResourceStateProfile;
import de.independit.scheduler.server.repository.SDMSResourceStateProfileTable;
import de.independit.scheduler.server.repository.SDMSResourceStateTable;
import de.independit.scheduler.server.repository.SDMSResourceTemplateProxyGeneric;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSSchedulingEntity;
import de.independit.scheduler.server.repository.SDMSSchedulingEntityTable;
import de.independit.scheduler.server.repository.SDMSSubmittedEntity;
import de.independit.scheduler.server.repository.SDMSTemplateVariable;
import de.independit.scheduler.server.repository.SDMSTemplateVariableTable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public class SDMSResourceTemplate
extends SDMSResourceTemplateProxyGeneric
implements SDMSOwnedObject {
    public static final String __version = "@(#) $Id: SDMSResourceTemplate.java,v 2.11.2.3 2013/03/22 14:48:03 ronald Exp $";
    private static Boolean nonlocal = Boolean.FALSE;

    protected SDMSResourceTemplate(SDMSObject sDMSObject) {
        super(sDMSObject);
    }

    public String getName(SystemEnvironment systemEnvironment) throws SDMSException {
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, this.getNrId(systemEnvironment));
        String string = sDMSNamedResource.getName(systemEnvironment);
        return string;
    }

    @Override
    public void setRequestableAmount(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        super.setRequestableAmount(systemEnvironment, n);
    }

    @Override
    public void setRsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        this.setRsdId(systemEnvironment, l, null);
    }

    public void setRsdId(SystemEnvironment systemEnvironment, Long l, SDMSSubmittedEntity sDMSSubmittedEntity) throws SDMSException {
        Object var4_4 = null;
        Long l2 = this.getNrId(systemEnvironment);
        SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l2);
        Long l3 = sDMSNamedResource.getRspId(systemEnvironment);
        if (l3 == null) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409301352", "Named Resource $1 is stateless", (Object)sDMSNamedResource.pathVector(systemEnvironment).toString()));
        }
        if (!SDMSResourceStateTable.idx_rsdId_rspId.containsKey(systemEnvironment, new SDMSKey(l, l3))) {
            SDMSResourceStateProfile sDMSResourceStateProfile = SDMSResourceStateProfileTable.getObject(systemEnvironment, l3);
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409301353", "Resource state is not defined in the profile $1", (Object)sDMSResourceStateProfile.getName(systemEnvironment)));
        }
    }

    @Override
    public void delete(SystemEnvironment systemEnvironment) throws SDMSException {
        this.killVariables(systemEnvironment);
        super.delete(systemEnvironment);
    }

    @Override
    public long getPrivileges(SystemEnvironment systemEnvironment, long l, boolean bl, Vector vector) throws SDMSException {
        long l2 = super.getPrivileges(systemEnvironment, l, bl, vector);
        if (systemEnvironment.cEnv.isUser()) {
            Long l3 = this.getNrId(systemEnvironment);
            SDMSNamedResource sDMSNamedResource = SDMSNamedResourceTable.getObject(systemEnvironment, l3);
            long l4 = sDMSNamedResource.getPrivileges(systemEnvironment, 8L, bl, vector);
            Long l5 = this.getSeId(systemEnvironment);
            SDMSSchedulingEntity sDMSSchedulingEntity = SDMSSchedulingEntityTable.getObject(systemEnvironment, l5);
            if (((l4 &= sDMSSchedulingEntity.getPrivileges(systemEnvironment, 8L, bl, vector)) & 8L) == 8L) {
                l2 |= 1L;
            }
        }
        return l2 & l;
    }

    private final SDMSParameterDefinition getParameterDefinition(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        SDMSParameterDefinition sDMSParameterDefinition = null;
        Long l = this.getNrId(systemEnvironment);
        sDMSParameterDefinition = null;
        try {
            sDMSParameterDefinition = SDMSParameterDefinitionTable.idx_seId_Name_getUnique(systemEnvironment, new SDMSKey(l, (Comparable)((Object)string)));
        }
        catch (NotFoundException notFoundException) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409111747", "Parameter $1 not defined for this resource", (Object)string));
        }
        return sDMSParameterDefinition;
    }

    public final void createVariables(SystemEnvironment systemEnvironment, WithHash withHash) throws SDMSException {
        if (withHash == null) {
            return;
        }
        Long l = this.getId(systemEnvironment);
        Vector vector = new Vector(withHash.keySet());
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.get(i);
            Vector vector2 = (Vector)withHash.get(string);
            String string2 = (String)vector2.get(1);
            SDMSParameterDefinition sDMSParameterDefinition = this.getParameterDefinition(systemEnvironment, string);
            int n2 = sDMSParameterDefinition.getType(systemEnvironment);
            if (n2 == 30) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409111750", "Parameter $1 is defined as a $2 for this resource", (Object)string, (Object)sDMSParameterDefinition.getTypeAsString(systemEnvironment)));
            }
            if (string2 == null) continue;
            String string3 = string2 == null ? string2 : '=' + string2;
            SDMSTemplateVariableTable.table.create(systemEnvironment, sDMSParameterDefinition.getId(systemEnvironment), l, string3);
        }
    }

    public final void killVariables(SystemEnvironment systemEnvironment) throws SDMSException {
        Long l = this.getId(systemEnvironment);
        Vector vector = SDMSResourceVariableTable.idx_rId.getVector(systemEnvironment, l);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTemplateVariable sDMSTemplateVariable = (SDMSTemplateVariable)vector.get(i);
            sDMSTemplateVariable.delete(systemEnvironment);
        }
    }

    public final void copyVariables(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSTemplateVariableTable.idx_rtId.getVector(systemEnvironment, l2);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            SDMSTemplateVariable sDMSTemplateVariable = (SDMSTemplateVariable)vector.get(i);
            SDMSTemplateVariableTable.table.create(systemEnvironment, sDMSTemplateVariable.getPdId(systemEnvironment), l, sDMSTemplateVariable.getValue(systemEnvironment));
        }
    }

    public final void alterVariables(SystemEnvironment systemEnvironment, WithHash withHash, long l) throws SDMSException {
        Long l2 = this.getId(systemEnvironment);
        Vector vector = SDMSTemplateVariableTable.idx_rtId.getVector(systemEnvironment, l2);
        Long l3 = this.getNrId(systemEnvironment);
        if (withHash != null) {
            Set set = withHash.keySet();
            for (String string : set) {
                int n;
                Vector vector2 = (Vector)withHash.get(string);
                String string2 = (String)vector2.get(1);
                SDMSParameterDefinition sDMSParameterDefinition = this.getParameterDefinition(systemEnvironment, string);
                if (sDMSParameterDefinition.getType(systemEnvironment) == 30) {
                    throw new CommonErrorException(new SDMSMessage(systemEnvironment, "03409131150", "Parameter $1 is defined as a $2 for this resource", (Object)string, (Object)sDMSParameterDefinition.getTypeAsString(systemEnvironment)));
                }
                Long l4 = sDMSParameterDefinition.getId(systemEnvironment);
                String string3 = null;
                if (string2 != null) {
                    string3 = "=" + string2;
                }
                for (n = 0; n < vector.size(); ++n) {
                    SDMSTemplateVariable sDMSTemplateVariable = (SDMSTemplateVariable)vector.get(n);
                    if (!l4.equals(sDMSTemplateVariable.getPdId(systemEnvironment))) continue;
                    vector.removeElementAt(n);
                    n = -1;
                    if (string3 == null) {
                        sDMSTemplateVariable.delete(systemEnvironment);
                        break;
                    }
                    sDMSTemplateVariable.setValue(systemEnvironment, string3);
                    break;
                }
                if (n < vector.size() || string3 == null) continue;
                SDMSTemplateVariableTable.table.create(systemEnvironment, l4, l2, string3);
            }
        }
    }

    public final SDMSOutputContainer getVariables(SystemEnvironment systemEnvironment) throws SDMSException {
        Object object;
        String string;
        Object object2;
        Vector<String> vector = new Vector<String>();
        HashSet<String> hashSet = new HashSet<String>();
        Long l = this.getId(systemEnvironment);
        vector.add("ID");
        vector.add("NAME");
        vector.add("TYPE");
        vector.add("VALUE");
        vector.add("IS_DEFAULT");
        SDMSOutputContainer sDMSOutputContainer = new SDMSOutputContainer(systemEnvironment, null, vector);
        Vector vector2 = SDMSTemplateVariableTable.idx_rtId.getVector(systemEnvironment, l);
        for (int i = 0; i < vector2.size(); ++i) {
            SDMSTemplateVariable sDMSTemplateVariable = (SDMSTemplateVariable)vector2.get(i);
            try {
                object2 = SDMSParameterDefinitionTable.getObject(systemEnvironment, sDMSTemplateVariable.getPdId(systemEnvironment));
                string = ((SDMSParameterDefinitionProxyGeneric)object2).getName(systemEnvironment);
                object = new Vector();
                ((Vector)object).add(sDMSTemplateVariable.getId(systemEnvironment));
                ((Vector)object).add(string);
                ((Vector)object).add(((SDMSParameterDefinitionProxyGeneric)object2).getTypeAsString(systemEnvironment));
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            object2 = sDMSTemplateVariable.getValue(systemEnvironment);
            ((Vector)object).add(object2 == null ? null : ((String)object2).substring(1));
            ((Vector)object).add(Boolean.FALSE);
            hashSet.add(string);
            sDMSOutputContainer.addData(systemEnvironment, (Vector)object);
        }
        Vector vector3 = SDMSParameterDefinitionTable.idx_seId.getVector(systemEnvironment, this.getNrId(systemEnvironment));
        for (int i = 0; i < vector3.size(); ++i) {
            object = (SDMSParameterDefinition)vector3.get(i);
            string = ((SDMSParameterDefinitionProxyGeneric)object).getName(systemEnvironment);
            if (hashSet.contains(string)) continue;
            object2 = new Vector();
            ((Vector)object2).add(((SDMSProxy)object).getId(systemEnvironment));
            ((Vector)object2).add(string);
            ((Vector)object2).add(((SDMSParameterDefinitionProxyGeneric)object).getTypeAsString(systemEnvironment));
            String string2 = ((SDMSParameterDefinition)object).getDefaultValue(systemEnvironment);
            ((Vector)object2).add(string2 == null ? null : string2.substring(1));
            ((Vector)object2).add(Boolean.TRUE);
            sDMSOutputContainer.addData(systemEnvironment, (Vector)object2);
        }
        Collections.sort(sDMSOutputContainer.dataset, sDMSOutputContainer.getComparator(systemEnvironment, 1));
        return sDMSOutputContainer;
    }
}

