/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSResourceVariable;
import de.independit.scheduler.server.repository.SDMSResourceVariableGeneric;
import de.independit.scheduler.server.repository.SDMSResourceVariableTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSResourceVariableTableGeneric
extends SDMSTable {
    public static final String tableName = "RESOURCE_VARIABLE";
    public static SDMSResourceVariableTable table = null;
    public static final String[] columnNames = new String[]{"ID", "PD_ID", "R_ID", "VALUE", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_pdId;
    public static SDMSIndex idx_rId;
    public static SDMSIndex idx_pdId_rId;

    public SDMSResourceVariableTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ResourceVariable"));
        }
        table = (SDMSResourceVariableTable)this;
        table = (SDMSResourceVariableTable)this;
        this.isVersioned = false;
        idx_pdId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "pdId");
        idx_rId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "rId");
        idx_pdId_rId = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "pdId_rId");
    }

    public SDMSResourceVariable create(SystemEnvironment systemEnvironment, Long l, Long l2, String string) throws SDMSException {
        SDMSResourceVariable sDMSResourceVariable;
        Long l3 = systemEnvironment.cEnv.uid();
        Long l4 = systemEnvironment.txTime();
        Long l5 = systemEnvironment.cEnv.uid();
        Long l6 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ResourceVariable"));
        }
        this.validate(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSResourceVariableGeneric sDMSResourceVariableGeneric = new SDMSResourceVariableGeneric(systemEnvironment, l, l2, string, l3, l4, l5, l6);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSResourceVariableGeneric.versions, true);
            table.put(systemEnvironment, sDMSResourceVariableGeneric.id, sDMSResourceVariableGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSResourceVariable = (SDMSResourceVariable)sDMSResourceVariableGeneric.toProxy(systemEnvironment);
            sDMSResourceVariable.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSResourceVariable sDMSResourceVariable2 = (SDMSResourceVariable)sDMSResourceVariableGeneric.toProxy(systemEnvironment);
            sDMSResourceVariable2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSResourceVariable)) {
            throw new AccessViolationException(sDMSResourceVariable.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSResourceVariable.touchMaster(systemEnvironment);
        return sDMSResourceVariable;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSResourceVariable sDMSResourceVariable) throws SDMSException {
        return sDMSResourceVariable.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, Long l, Long l2, String string, Long l3, Long l4, Long l5, Long l6) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        String string;
        Long l7;
        Long l8;
        Long l9;
        try {
            l9 = new Long(resultSet.getLong(1));
            l8 = new Long(resultSet.getLong(2));
            l7 = new Long(resultSet.getLong(3));
            string = resultSet.getString(4);
            l6 = new Long(resultSet.getLong(5));
            l5 = new Long(resultSet.getLong(6));
            l4 = new Long(resultSet.getLong(7));
            l3 = new Long(resultSet.getLong(8));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ResourceVariable: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSResourceVariableGeneric(l9, l8, l7, string, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "PD_ID" + string2 + ", " + string + "R_ID" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_pdId.check(((SDMSResourceVariableGeneric)sDMSObject).pdId, sDMSObject);
        string = string + "idx_pdId: " + (bl ? "ok" : "missing") + "\n";
        bl = idx_rId.check(((SDMSResourceVariableGeneric)sDMSObject).rId, sDMSObject);
        string = string + "idx_rId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).rId);
        bl = idx_pdId_rId.check(sDMSKey, sDMSObject);
        string = string + "idx_pdId_rId: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_pdId.put(systemEnvironment, ((SDMSResourceVariableGeneric)sDMSObject).pdId, sDMSObject, (1L & l) != 0L);
        idx_rId.put(systemEnvironment, ((SDMSResourceVariableGeneric)sDMSObject).rId, sDMSObject, (2L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).rId);
        idx_pdId_rId.put(systemEnvironment, sDMSKey, sDMSObject, (4L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_pdId.remove(systemEnvironment, ((SDMSResourceVariableGeneric)sDMSObject).pdId, sDMSObject);
        idx_rId.remove(systemEnvironment, ((SDMSResourceVariableGeneric)sDMSObject).rId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).pdId);
        sDMSKey.add(((SDMSResourceVariableGeneric)sDMSObject).rId);
        idx_pdId_rId.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSResourceVariable getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceVariable)table.get(systemEnvironment, l);
    }

    public static SDMSResourceVariable getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSResourceVariable)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSResourceVariable getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSResourceVariable)table.get(systemEnvironment, l, l2);
    }

    public static SDMSResourceVariable idx_pdId_rId_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceVariable)idx_pdId_rId.getUnique(systemEnvironment, object);
    }

    public static SDMSResourceVariable idx_pdId_rId_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSResourceVariable)idx_pdId_rId.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSResourceVariable idx_pdId_rId_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSResourceVariable)idx_pdId_rId.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

