/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMapping;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingGeneric;
import de.independit.scheduler.server.repository.SDMSScopeConfigEnvMappingTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSScopeConfigEnvMappingTableGeneric
extends SDMSTable {
    public static final String tableName = "SCOPE_CONFIG_ENVMAPPING";
    public static SDMSScopeConfigEnvMappingTable table = null;
    public static final String[] columnNames = new String[]{"ID", "KEY", "VALUE", "S_ID", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_sId;
    public static SDMSIndex idx_scopeId_key;

    public SDMSScopeConfigEnvMappingTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "ScopeConfigEnvMapping"));
        }
        table = (SDMSScopeConfigEnvMappingTable)this;
        table = (SDMSScopeConfigEnvMappingTable)this;
        this.isVersioned = false;
        idx_sId = new SDMSIndex(systemEnvironment, 0, this.isVersioned, table, "sId");
        idx_scopeId_key = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "scopeId_key");
    }

    public SDMSScopeConfigEnvMapping create(SystemEnvironment systemEnvironment, String string, String string2, Long l) throws SDMSException {
        SDMSScopeConfigEnvMapping sDMSScopeConfigEnvMapping;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "ScopeConfigEnvMapping"));
        }
        this.validate(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSScopeConfigEnvMappingGeneric sDMSScopeConfigEnvMappingGeneric = new SDMSScopeConfigEnvMappingGeneric(systemEnvironment, string, string2, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSScopeConfigEnvMappingGeneric.versions, true);
            table.put(systemEnvironment, sDMSScopeConfigEnvMappingGeneric.id, sDMSScopeConfigEnvMappingGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSScopeConfigEnvMapping = (SDMSScopeConfigEnvMapping)sDMSScopeConfigEnvMappingGeneric.toProxy(systemEnvironment);
            sDMSScopeConfigEnvMapping.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSScopeConfigEnvMapping sDMSScopeConfigEnvMapping2 = (SDMSScopeConfigEnvMapping)sDMSScopeConfigEnvMappingGeneric.toProxy(systemEnvironment);
            sDMSScopeConfigEnvMapping2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSScopeConfigEnvMapping)) {
            throw new AccessViolationException(sDMSScopeConfigEnvMapping.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        sDMSScopeConfigEnvMapping.touchMaster(systemEnvironment);
        return sDMSScopeConfigEnvMapping;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSScopeConfigEnvMapping sDMSScopeConfigEnvMapping) throws SDMSException {
        return sDMSScopeConfigEnvMapping.checkPrivileges(systemEnvironment, 1L);
    }

    protected void validate(SystemEnvironment systemEnvironment, String string, String string2, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        String string;
        String string2;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            string2 = resultSet.getString(2);
            string = resultSet.getString(3);
            l7 = new Long(resultSet.getLong(4));
            l6 = new Long(resultSet.getLong(5));
            l5 = new Long(resultSet.getLong(6));
            l4 = new Long(resultSet.getLong(7));
            l3 = new Long(resultSet.getLong(8));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "ScopeConfigEnvMapping: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSScopeConfigEnvMappingGeneric(l8, string2, string, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "KEY" + string2 + ", " + string + "VALUE" + string2 + ", " + string + "S_ID" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        boolean bl = idx_sId.check(((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId, sDMSObject);
        string = string + "idx_sId: " + (bl ? "ok" : "missing") + "\n";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigEnvMappingGeneric)sDMSObject).key));
        bl = idx_scopeId_key.check(sDMSKey, sDMSObject);
        string = string + "idx_scopeId_key: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        idx_sId.put(systemEnvironment, ((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId, sDMSObject, (1L & l) != 0L);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigEnvMappingGeneric)sDMSObject).key));
        idx_scopeId_key.put(systemEnvironment, sDMSKey, sDMSObject, (2L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        idx_sId.remove(systemEnvironment, ((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId, sDMSObject);
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSScopeConfigEnvMappingGeneric)sDMSObject).sId);
        sDMSKey.add((Comparable)((Object)((SDMSScopeConfigEnvMappingGeneric)sDMSObject).key));
        idx_scopeId_key.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSScopeConfigEnvMapping getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)table.get(systemEnvironment, l);
    }

    public static SDMSScopeConfigEnvMapping getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSScopeConfigEnvMapping getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)table.get(systemEnvironment, l, l2);
    }

    public static SDMSScopeConfigEnvMapping idx_scopeId_key_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)idx_scopeId_key.getUnique(systemEnvironment, object);
    }

    public static SDMSScopeConfigEnvMapping idx_scopeId_key_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)idx_scopeId_key.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSScopeConfigEnvMapping idx_scopeId_key_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSScopeConfigEnvMapping)idx_scopeId_key.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

