/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.AccessViolationException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.repository.SDMSIndex;
import de.independit.scheduler.server.repository.SDMSKey;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSSmeCounter;
import de.independit.scheduler.server.repository.SDMSSmeCounterGeneric;
import de.independit.scheduler.server.repository.SDMSSmeCounterTable;
import de.independit.scheduler.server.repository.SDMSTable;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SDMSSmeCounterTableGeneric
extends SDMSTable {
    public static final String tableName = "SME_COUNTER";
    public static SDMSSmeCounterTable table = null;
    public static final String[] columnNames = new String[]{"ID", "JAHR", "MONAT", "TAG", "ANZAHL", "CHECKSUM", "CREATOR_U_ID", "CREATE_TS", "CHANGER_U_ID", "CHANGE_TS"};
    public static SDMSIndex idx_jahr_monat_tag;

    public SDMSSmeCounterTableGeneric(SystemEnvironment systemEnvironment) throws SDMSException {
        super(systemEnvironment);
        if (table != null) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182009", "SmeCounter"));
        }
        table = (SDMSSmeCounterTable)this;
        table = (SDMSSmeCounterTable)this;
        this.isVersioned = false;
        idx_jahr_monat_tag = new SDMSIndex(systemEnvironment, 1, this.isVersioned, table, "jahr_monat_tag");
    }

    public SDMSSmeCounter create(SystemEnvironment systemEnvironment, Integer n, Integer n2, Integer n3, Integer n4, Long l) throws SDMSException {
        SDMSSmeCounter sDMSSmeCounter;
        Long l2 = systemEnvironment.cEnv.uid();
        Long l3 = systemEnvironment.txTime();
        Long l4 = systemEnvironment.cEnv.uid();
        Long l5 = systemEnvironment.txTime();
        if (systemEnvironment.tx.mode == 1) {
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182049", "SmeCounter"));
        }
        this.validate(systemEnvironment, n, n2, n3, n4, l, l2, l3, l4, l5);
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        SDMSSmeCounterGeneric sDMSSmeCounterGeneric = new SDMSSmeCounterGeneric(systemEnvironment, n, n2, n3, n4, l, l2, l3, l4, l5);
        try {
            systemEnvironment.tx.addToTouchSet(systemEnvironment, sDMSSmeCounterGeneric.versions, true);
            table.put(systemEnvironment, sDMSSmeCounterGeneric.id, sDMSSmeCounterGeneric.versions);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
            sDMSSmeCounter = (SDMSSmeCounter)sDMSSmeCounterGeneric.toProxy(systemEnvironment);
            sDMSSmeCounter.current = true;
        }
        catch (SDMSException sDMSException) {
            SDMSSmeCounter sDMSSmeCounter2 = (SDMSSmeCounter)sDMSSmeCounterGeneric.toProxy(systemEnvironment);
            sDMSSmeCounter2.current = true;
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        if (!this.checkCreatePrivs(systemEnvironment, sDMSSmeCounter)) {
            throw new AccessViolationException(sDMSSmeCounter.accessViolationMessage(systemEnvironment, "01402270738"));
        }
        return sDMSSmeCounter;
    }

    protected boolean checkCreatePrivs(SystemEnvironment systemEnvironment, SDMSSmeCounter sDMSSmeCounter) throws SDMSException {
        return true;
    }

    protected void validate(SystemEnvironment systemEnvironment, Integer n, Integer n2, Integer n3, Integer n4, Long l, Long l2, Long l3, Long l4, Long l5) throws SDMSException {
    }

    @Override
    protected SDMSObject rowToObject(SystemEnvironment systemEnvironment, ResultSet resultSet) throws SDMSException {
        long l;
        long l2;
        Long l3;
        Long l4;
        Long l5;
        Long l6;
        Long l7;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Long l8;
        try {
            l8 = new Long(resultSet.getLong(1));
            n4 = new Integer(resultSet.getInt(2));
            n3 = new Integer(resultSet.getInt(3));
            n2 = new Integer(resultSet.getInt(4));
            n = new Integer(resultSet.getInt(5));
            l7 = new Long(resultSet.getLong(6));
            l6 = new Long(resultSet.getLong(7));
            l5 = new Long(resultSet.getLong(8));
            l4 = new Long(resultSet.getLong(9));
            l3 = new Long(resultSet.getLong(10));
            l2 = 0L;
            l = Long.MAX_VALUE;
        }
        catch (SQLException sQLException) {
            SDMSThread.doTrace(null, "SQL Error : " + sQLException.getMessage(), -1);
            throw new FatalException(new SDMSMessage(systemEnvironment, "01110182045", "SmeCounter: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
        if (l < systemEnvironment.lowestActiveVersion) {
            return null;
        }
        return new SDMSSmeCounterGeneric(l8, n4, n3, n2, n, l7, l6, l5, l4, l3, l2, l);
    }

    @Override
    protected void loadTable(SystemEnvironment systemEnvironment) throws SQLException, SDMSException {
        int n = 0;
        int n2 = 0;
        boolean bl = SystemEnvironment.isPostgreSQL;
        String string = SystemEnvironment.SQUOTE;
        String string2 = SystemEnvironment.EQUOTE;
        Statement statement = systemEnvironment.dbConnection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string + this.tableName() + string2 + ".ID" + ", " + string + "JAHR" + string2 + ", " + string + "MONAT" + string2 + ", " + string + "TAG" + string2 + ", " + string + "ANZAHL" + string2 + ", " + string + "CHECKSUM" + string2 + ", " + string + "CREATOR_U_ID" + string2 + ", " + string + "CREATE_TS" + string2 + ", " + string + "CHANGER_U_ID" + string2 + ", " + string + "CHANGE_TS" + string2 + " FROM " + string + this.tableName() + string2 + "");
        while (resultSet.next()) {
            if (this.loadObject(systemEnvironment, resultSet)) {
                ++n2;
            }
            ++n;
        }
        statement.close();
        SDMSThread.doTrace(null, "Read " + n + ", Loaded " + n2 + " rows for " + this.tableName(), 0);
    }

    @Override
    public String checkIndex(SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).jahr);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).monat);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).tag);
        boolean bl = idx_jahr_monat_tag.check(sDMSKey, sDMSObject);
        string = string + "idx_jahr_monat_tag: " + (bl ? "ok" : "missing") + "\n";
        return string;
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        this.index(systemEnvironment, sDMSObject, -1L);
    }

    @Override
    protected void index(SystemEnvironment systemEnvironment, SDMSObject sDMSObject, long l) throws SDMSException {
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).jahr);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).monat);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).tag);
        idx_jahr_monat_tag.put(systemEnvironment, sDMSKey, sDMSObject, (1L & l) != 0L);
    }

    @Override
    protected void unIndex(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        SDMSKey sDMSKey = new SDMSKey();
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).jahr);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).monat);
        sDMSKey.add(((SDMSSmeCounterGeneric)sDMSObject).tag);
        idx_jahr_monat_tag.remove(systemEnvironment, sDMSKey, sDMSObject);
    }

    public static SDMSSmeCounter getObject(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSmeCounter)table.get(systemEnvironment, l);
    }

    public static SDMSSmeCounter getObjectForUpdate(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        return (SDMSSmeCounter)table.getForUpdate(systemEnvironment, l);
    }

    public static SDMSSmeCounter getObject(SystemEnvironment systemEnvironment, Long l, long l2) throws SDMSException {
        return (SDMSSmeCounter)table.get(systemEnvironment, l, l2);
    }

    public static SDMSSmeCounter idx_jahr_monat_tag_getUnique(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSmeCounter)idx_jahr_monat_tag.getUnique(systemEnvironment, object);
    }

    public static SDMSSmeCounter idx_jahr_monat_tag_getUniqueForUpdate(SystemEnvironment systemEnvironment, Object object) throws SDMSException {
        return (SDMSSmeCounter)idx_jahr_monat_tag.getUniqueForUpdate(systemEnvironment, object);
    }

    public static SDMSSmeCounter idx_jahr_monat_tag_getUnique(SystemEnvironment systemEnvironment, Object object, long l) throws SDMSException {
        return (SDMSSmeCounter)idx_jahr_monat_tag.getUnique(systemEnvironment, object, l);
    }

    @Override
    public String tableName() {
        return tableName;
    }

    @Override
    public String[] columnNames() {
        return columnNames;
    }
}

