/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.repository;

import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.CommonErrorException;
import de.independit.scheduler.server.exception.FatalException;
import de.independit.scheduler.server.exception.SDMSException;
import de.independit.scheduler.server.exception.SDMSMessage;
import de.independit.scheduler.server.exception.SDMSSQLException;
import de.independit.scheduler.server.repository.SDMSObject;
import de.independit.scheduler.server.repository.SDMSProxy;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStats;
import de.independit.scheduler.server.repository.SDMSSubmittedEntityStatsTableGeneric;
import de.independit.scheduler.server.util.SDMSThread;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SDMSSubmittedEntityStatsGeneric
extends SDMSObject
implements Cloneable {
    public static final int nr_id = 1;
    public static final int nr_smeId = 2;
    public static final int nr_rerunSeq = 3;
    public static final int nr_scopeId = 4;
    public static final int nr_jobEsdId = 5;
    public static final int nr_exitCode = 6;
    public static final int nr_commandline = 7;
    public static final int nr_workdir = 8;
    public static final int nr_logfile = 9;
    public static final int nr_errlogfile = 10;
    public static final int nr_extPid = 11;
    public static final int nr_syncTs = 12;
    public static final int nr_resourceTs = 13;
    public static final int nr_runnableTs = 14;
    public static final int nr_startTs = 15;
    public static final int nr_finishTs = 16;
    public static final int nr_creatorUId = 17;
    public static final int nr_createTs = 18;
    public static final int nr_changerUId = 19;
    public static final int nr_changeTs = 20;
    public static String tableName = "SUBMITTED_ENTITY_STATS";
    protected Long smeId;
    protected Integer rerunSeq;
    protected Long scopeId;
    protected Long jobEsdId;
    protected Integer exitCode;
    protected String commandline;
    protected String workdir;
    protected String logfile;
    protected String errlogfile;
    protected String extPid;
    protected Long syncTs;
    protected Long resourceTs;
    protected Long runnableTs;
    protected Long startTs;
    protected Long finishTs;
    protected Long creatorUId;
    protected Long createTs;
    protected Long changerUId;
    protected Long changeTs;
    private static PreparedStatement[] pUpdate = new PreparedStatement[128];
    private static PreparedStatement[] pDelete = new PreparedStatement[128];
    private static PreparedStatement[] pInsert = new PreparedStatement[128];

    public SDMSSubmittedEntityStatsGeneric(SystemEnvironment systemEnvironment, Long l, Integer n, Long l2, Long l3, Integer n2, String string, String string2, String string3, String string4, String string5, Long l4, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12) throws SDMSException {
        super(systemEnvironment, SDMSSubmittedEntityStatsTableGeneric.table);
        this.smeId = l;
        this.rerunSeq = n;
        this.scopeId = l2;
        this.jobEsdId = l3;
        this.exitCode = n2;
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        this.commandline = string;
        if (string2 != null && string2.length() > 512) {
            string2 = string2.substring(0, 512);
        }
        this.workdir = string2;
        if (string3 != null && string3.length() > 512) {
            string3 = string3.substring(0, 512);
        }
        this.logfile = string3;
        if (string4 != null && string4.length() > 512) {
            string4 = string4.substring(0, 512);
        }
        this.errlogfile = string4;
        if (string5 != null && string5.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141528", "(SubmittedEntityStats) Length of $1 exceeds maximum length $2", (Object)"extPid", (Object)"32"));
        }
        this.extPid = string5;
        this.syncTs = l4;
        this.resourceTs = l5;
        this.runnableTs = l6;
        this.startTs = l7;
        this.finishTs = l8;
        this.creatorUId = l9;
        this.createTs = l10;
        this.changerUId = l11;
        this.changeTs = l12;
    }

    public Long getSmeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.smeId;
    }

    public void setSmeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.smeId.equals(l)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
            }
            SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityStatsGeneric.smeId = l;
            sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 5L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Integer getRerunSeq(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.rerunSeq;
    }

    public void setRerunSeq(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (this.rerunSeq.equals(n)) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
            }
            SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityStatsGeneric.rerunSeq = n;
            sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 4L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getScopeId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.scopeId;
    }

    public void setScopeId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.scopeId)) {
            return;
        }
        if (l == null && this.scopeId == null) {
            return;
        }
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
            }
            SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityStatsGeneric.scopeId = l;
            sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 2L);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
    }

    public Long getJobEsdId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.jobEsdId;
    }

    public void setJobEsdId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.jobEsdId)) {
            return;
        }
        if (l == null && this.jobEsdId == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.jobEsdId = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Integer getExitCode(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.exitCode;
    }

    public void setExitCode(SystemEnvironment systemEnvironment, Integer n) throws SDMSException {
        if (n != null && n.equals(this.exitCode)) {
            return;
        }
        if (n == null && this.exitCode == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.exitCode = n;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public String getCommandline(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.commandline;
    }

    public void setCommandline(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.commandline)) {
            return;
        }
        if (string == null && this.commandline == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityStatsGeneric.commandline = string;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public String getWorkdir(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.workdir;
    }

    public void setWorkdir(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.workdir)) {
            return;
        }
        if (string == null && this.workdir == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityStatsGeneric.workdir = string;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public String getLogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.logfile;
    }

    public void setLogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.logfile)) {
            return;
        }
        if (string == null && this.logfile == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityStatsGeneric.logfile = string;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public String getErrlogfile(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.errlogfile;
    }

    public void setErrlogfile(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.errlogfile)) {
            return;
        }
        if (string == null && this.errlogfile == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 512) {
            string = string.substring(0, 512);
        }
        sDMSSubmittedEntityStatsGeneric.errlogfile = string;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public String getExtPid(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.extPid;
    }

    public void setExtPid(SystemEnvironment systemEnvironment, String string) throws SDMSException {
        if (string != null && string.equals(this.extPid)) {
            return;
        }
        if (string == null && this.extPid == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        if (string != null && string.length() > 32) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "01112141510", "(SubmittedEntityStats) Length of $1 exceeds maximum length $2", (Object)"extPid", (Object)"32"));
        }
        sDMSSubmittedEntityStatsGeneric.extPid = string;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getSyncTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.syncTs;
    }

    public void setSyncTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.syncTs)) {
            return;
        }
        if (l == null && this.syncTs == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.syncTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getResourceTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.resourceTs;
    }

    public void setResourceTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.resourceTs)) {
            return;
        }
        if (l == null && this.resourceTs == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.resourceTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getRunnableTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.runnableTs;
    }

    public void setRunnableTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.runnableTs)) {
            return;
        }
        if (l == null && this.runnableTs == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.runnableTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getStartTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.startTs;
    }

    public void setStartTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.startTs)) {
            return;
        }
        if (l == null && this.startTs == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.startTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getFinishTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.finishTs;
    }

    public void setFinishTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (l != null && l.equals(this.finishTs)) {
            return;
        }
        if (l == null && this.finishTs == null) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.finishTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getCreatorUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.creatorUId;
    }

    void setCreatorUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.creatorUId.equals(l)) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.creatorUId = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getCreateTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.createTs;
    }

    void setCreateTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.createTs.equals(l)) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (this.versions.id < 1000L) {
            throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141636", "(SubmittedEntityStats) Change of system object not allowed"));
        }
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.createTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getChangerUId(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changerUId;
    }

    public void setChangerUId(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.changerUId = l;
        sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public Long getChangeTs(SystemEnvironment systemEnvironment) throws SDMSException {
        return this.changeTs;
    }

    void setChangeTs(SystemEnvironment systemEnvironment, Long l) throws SDMSException {
        if (this.changeTs.equals(l)) {
            return;
        }
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric = this;
        if (sDMSSubmittedEntityStatsGeneric.versions.o_v == null || sDMSSubmittedEntityStatsGeneric.versions.o_v.size() == 0 || sDMSSubmittedEntityStatsGeneric.subTxId != systemEnvironment.tx.subTxId) {
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
        }
        sDMSSubmittedEntityStatsGeneric.changeTs = l;
        sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
        if (sDMSSubmittedEntityStatsGeneric != this) {
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric, 0L);
        }
    }

    public SDMSSubmittedEntityStatsGeneric set_SmeIdRerunSeq(SystemEnvironment systemEnvironment, Long l, Integer n) throws SDMSException {
        SDMSSubmittedEntityStatsGeneric sDMSSubmittedEntityStatsGeneric;
        systemEnvironment.tx.beginSubTransaction(systemEnvironment);
        try {
            if (this.versions.id < 1000L) {
                throw new CommonErrorException(new SDMSMessage(systemEnvironment, "02112141637", "(SubmittedEntityStats) Change of system object not allowed"));
            }
            sDMSSubmittedEntityStatsGeneric = (SDMSSubmittedEntityStatsGeneric)this.change(systemEnvironment);
            sDMSSubmittedEntityStatsGeneric.smeId = l;
            sDMSSubmittedEntityStatsGeneric.rerunSeq = n;
            sDMSSubmittedEntityStatsGeneric.changerUId = systemEnvironment.cEnv.uid();
            sDMSSubmittedEntityStatsGeneric.changeTs = systemEnvironment.txTime();
            sDMSSubmittedEntityStatsGeneric.versions.table.index(systemEnvironment, sDMSSubmittedEntityStatsGeneric);
            systemEnvironment.tx.commitSubTransaction(systemEnvironment);
        }
        catch (SDMSException sDMSException) {
            systemEnvironment.tx.rollbackSubTransaction(systemEnvironment);
            throw sDMSException;
        }
        return sDMSSubmittedEntityStatsGeneric;
    }

    @Override
    protected SDMSProxy toProxy(SystemEnvironment systemEnvironment) {
        return new SDMSSubmittedEntityStats(this);
    }

    protected SDMSSubmittedEntityStatsGeneric(Long l, Long l2, Integer n, Long l3, Long l4, Integer n2, String string, String string2, String string3, String string4, String string5, Long l5, Long l6, Long l7, Long l8, Long l9, Long l10, Long l11, Long l12, Long l13, long l14, long l15) {
        this.id = l;
        this.smeId = l2;
        this.rerunSeq = n;
        this.scopeId = l3;
        this.jobEsdId = l4;
        this.exitCode = n2;
        this.commandline = string;
        this.workdir = string2;
        this.logfile = string3;
        this.errlogfile = string4;
        this.extPid = string5;
        this.syncTs = l5;
        this.resourceTs = l6;
        this.runnableTs = l7;
        this.startTs = l8;
        this.finishTs = l9;
        this.creatorUId = l10;
        this.createTs = l11;
        this.changerUId = l12;
        this.changeTs = l13;
        this.validFrom = l14;
        this.validTo = l15;
    }

    protected String tableName() {
        return tableName;
    }

    @Override
    protected void insertDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pInsert[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "INSERT INTO " + string2 + "SUBMITTED_ENTITY_STATS" + string3 + " (" + "ID" + ", " + string2 + "SME_ID" + string3 + ", " + string2 + "RERUN_SEQ" + string3 + ", " + string2 + "SCOPE_ID" + string3 + ", " + string2 + "JOB_ESD_ID" + string3 + ", " + string2 + "EXIT_CODE" + string3 + ", " + string2 + "COMMANDLINE" + string3 + ", " + string2 + "WORKDIR" + string3 + ", " + string2 + "LOGFILE" + string3 + ", " + string2 + "ERRLOGFILE" + string3 + ", " + string2 + "EXTPID" + string3 + ", " + string2 + "SYNC_TS" + string3 + ", " + string2 + "RESOURCE_TS" + string3 + ", " + string2 + "RUNNABLE_TS" + string3 + ", " + string2 + "START_TS" + string3 + ", " + string2 + "FINISH_TS" + string3 + ", " + string2 + "CREATOR_U_ID" + string3 + ", " + string2 + "CREATE_TS" + string3 + ", " + string2 + "CHANGER_U_ID" + string3 + ", " + string2 + "CHANGE_TS" + string3 + ") VALUES (?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ", ?" + ")";
                SDMSSubmittedEntityStatsGeneric.pInsert[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110181952", "SubmittedEntityStats: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pInsert[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.setLong(2, this.smeId);
            preparedStatement.setInt(3, this.rerunSeq);
            if (this.scopeId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.scopeId);
            }
            if (this.jobEsdId == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setLong(5, this.jobEsdId);
            }
            if (this.exitCode == null) {
                preparedStatement.setNull(6, 4);
            } else {
                preparedStatement.setInt(6, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.commandline);
            }
            if (this.workdir == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.workdir);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.errlogfile);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(11, 12);
            } else {
                preparedStatement.setString(11, this.extPid);
            }
            if (this.syncTs == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.syncTs);
            }
            if (this.resourceTs == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.resourceTs);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(16, 4);
            } else {
                preparedStatement.setLong(16, this.finishTs);
            }
            preparedStatement.setLong(17, this.creatorUId);
            preparedStatement.setLong(18, this.createTs);
            preparedStatement.setLong(19, this.changerUId);
            preparedStatement.setLong(20, this.changeTs);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110181954", "SubmittedEntityStats: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void deleteDBObject(SystemEnvironment systemEnvironment) throws SDMSException {
        String string = "";
        if (pDelete[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "DELETE FROM " + string2 + "SUBMITTED_ENTITY_STATS" + string3 + " WHERE ID = ?";
                SDMSSubmittedEntityStatsGeneric.pDelete[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182001", "SubmittedEntityStats: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pDelete[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182002", "SubmittedEntityStats: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    protected void updateDBObject(SystemEnvironment systemEnvironment, SDMSObject sDMSObject) throws SDMSException {
        String string = "";
        if (pUpdate[systemEnvironment.dbConnectionNr] == null) {
            try {
                String string2 = SystemEnvironment.SQUOTE;
                String string3 = SystemEnvironment.EQUOTE;
                string = "UPDATE " + string2 + "SUBMITTED_ENTITY_STATS" + string3 + " SET " + "" + string2 + "SME_ID" + string3 + " = ? " + ", " + string2 + "RERUN_SEQ" + string3 + " = ? " + ", " + string2 + "SCOPE_ID" + string3 + " = ? " + ", " + string2 + "JOB_ESD_ID" + string3 + " = ? " + ", " + string2 + "EXIT_CODE" + string3 + " = ? " + ", " + string2 + "COMMANDLINE" + string3 + " = ? " + ", " + string2 + "WORKDIR" + string3 + " = ? " + ", " + string2 + "LOGFILE" + string3 + " = ? " + ", " + string2 + "ERRLOGFILE" + string3 + " = ? " + ", " + string2 + "EXTPID" + string3 + " = ? " + ", " + string2 + "SYNC_TS" + string3 + " = ? " + ", " + string2 + "RESOURCE_TS" + string3 + " = ? " + ", " + string2 + "RUNNABLE_TS" + string3 + " = ? " + ", " + string2 + "START_TS" + string3 + " = ? " + ", " + string2 + "FINISH_TS" + string3 + " = ? " + ", " + string2 + "CREATOR_U_ID" + string3 + " = ? " + ", " + string2 + "CREATE_TS" + string3 + " = ? " + ", " + string2 + "CHANGER_U_ID" + string3 + " = ? " + ", " + string2 + "CHANGE_TS" + string3 + " = ? " + "WHERE ID = ?";
                SDMSSubmittedEntityStatsGeneric.pUpdate[systemEnvironment.dbConnectionNr] = systemEnvironment.dbConnection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                throw new FatalException(new SDMSMessage(systemEnvironment, "01110182005", "SubmittedEntityStats: $1\n$2", (Object)string, (Object)sQLException.toString()));
            }
        }
        PreparedStatement preparedStatement = pUpdate[systemEnvironment.dbConnectionNr];
        try {
            preparedStatement.clearParameters();
            preparedStatement.setLong(1, this.smeId);
            preparedStatement.setInt(2, this.rerunSeq);
            if (this.scopeId == null) {
                preparedStatement.setNull(3, 4);
            } else {
                preparedStatement.setLong(3, this.scopeId);
            }
            if (this.jobEsdId == null) {
                preparedStatement.setNull(4, 4);
            } else {
                preparedStatement.setLong(4, this.jobEsdId);
            }
            if (this.exitCode == null) {
                preparedStatement.setNull(5, 4);
            } else {
                preparedStatement.setInt(5, this.exitCode);
            }
            if (this.commandline == null) {
                preparedStatement.setNull(6, 12);
            } else {
                preparedStatement.setString(6, this.commandline);
            }
            if (this.workdir == null) {
                preparedStatement.setNull(7, 12);
            } else {
                preparedStatement.setString(7, this.workdir);
            }
            if (this.logfile == null) {
                preparedStatement.setNull(8, 12);
            } else {
                preparedStatement.setString(8, this.logfile);
            }
            if (this.errlogfile == null) {
                preparedStatement.setNull(9, 12);
            } else {
                preparedStatement.setString(9, this.errlogfile);
            }
            if (this.extPid == null) {
                preparedStatement.setNull(10, 12);
            } else {
                preparedStatement.setString(10, this.extPid);
            }
            if (this.syncTs == null) {
                preparedStatement.setNull(11, 4);
            } else {
                preparedStatement.setLong(11, this.syncTs);
            }
            if (this.resourceTs == null) {
                preparedStatement.setNull(12, 4);
            } else {
                preparedStatement.setLong(12, this.resourceTs);
            }
            if (this.runnableTs == null) {
                preparedStatement.setNull(13, 4);
            } else {
                preparedStatement.setLong(13, this.runnableTs);
            }
            if (this.startTs == null) {
                preparedStatement.setNull(14, 4);
            } else {
                preparedStatement.setLong(14, this.startTs);
            }
            if (this.finishTs == null) {
                preparedStatement.setNull(15, 4);
            } else {
                preparedStatement.setLong(15, this.finishTs);
            }
            preparedStatement.setLong(16, this.creatorUId);
            preparedStatement.setLong(17, this.createTs);
            preparedStatement.setLong(18, this.changerUId);
            preparedStatement.setLong(19, this.changeTs);
            preparedStatement.setLong(20, this.id);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SDMSSQLException(new SDMSMessage(systemEnvironment, "01110182006", "SubmittedEntityStats: $1 $2", (Object)new Integer(sQLException.getErrorCode()), (Object)sQLException.getMessage()));
        }
    }

    @Override
    public void print() {
        SDMSThread.doTrace(null, "Type : SubmittedEntityStats", 2);
        SDMSThread.doTrace(null, "id : " + this.id, 2);
        SDMSThread.doTrace(null, "smeId : " + this.smeId, 2);
        SDMSThread.doTrace(null, "rerunSeq : " + this.rerunSeq, 2);
        SDMSThread.doTrace(null, "scopeId : " + this.scopeId, 2);
        SDMSThread.doTrace(null, "jobEsdId : " + this.jobEsdId, 2);
        SDMSThread.doTrace(null, "exitCode : " + this.exitCode, 2);
        SDMSThread.doTrace(null, "commandline : " + this.commandline, 2);
        SDMSThread.doTrace(null, "workdir : " + this.workdir, 2);
        SDMSThread.doTrace(null, "logfile : " + this.logfile, 2);
        SDMSThread.doTrace(null, "errlogfile : " + this.errlogfile, 2);
        SDMSThread.doTrace(null, "extPid : " + this.extPid, 2);
        SDMSThread.doTrace(null, "syncTs : " + this.syncTs, 2);
        SDMSThread.doTrace(null, "resourceTs : " + this.resourceTs, 2);
        SDMSThread.doTrace(null, "runnableTs : " + this.runnableTs, 2);
        SDMSThread.doTrace(null, "startTs : " + this.startTs, 2);
        SDMSThread.doTrace(null, "finishTs : " + this.finishTs, 2);
        SDMSThread.doTrace(null, "creatorUId : " + this.creatorUId, 2);
        SDMSThread.doTrace(null, "createTs : " + this.createTs, 2);
        SDMSThread.doTrace(null, "changerUId : " + this.changerUId, 2);
        SDMSThread.doTrace(null, "changeTs : " + this.changeTs, 2);
        SDMSThread.doTrace(null, "validFrom : " + this.validFrom, 2);
        SDMSThread.doTrace(null, "validTo : " + this.validTo, 2);
        this.dumpVersions(2);
    }

    @Override
    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer(n + 1);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(" ");
        }
        String string = new String(stringBuffer);
        String string2 = string + "id : " + this.id + "\n" + string + "smeId       : " + this.smeId + "\n" + string + "rerunSeq    : " + this.rerunSeq + "\n" + string + "scopeId     : " + this.scopeId + "\n" + string + "jobEsdId    : " + this.jobEsdId + "\n" + string + "exitCode    : " + this.exitCode + "\n" + string + "commandline : " + this.commandline + "\n" + string + "workdir     : " + this.workdir + "\n" + string + "logfile     : " + this.logfile + "\n" + string + "errlogfile  : " + this.errlogfile + "\n" + string + "extPid      : " + this.extPid + "\n" + string + "syncTs      : " + this.syncTs + "\n" + string + "resourceTs  : " + this.resourceTs + "\n" + string + "runnableTs  : " + this.runnableTs + "\n" + string + "startTs     : " + this.startTs + "\n" + string + "finishTs    : " + this.finishTs + "\n" + string + "creatorUId  : " + this.creatorUId + "\n" + string + "createTs    : " + this.createTs + "\n" + string + "changerUId  : " + this.changerUId + "\n" + string + "changeTs    : " + this.changeTs + "\n" + string + "validFrom : " + this.validFrom + "\n" + string + "validTo : " + this.validTo + "\n";
        return string2;
    }

    public String toString() {
        String string = this.toString(0);
        return string;
    }
}

