/*
 * Decompiled with CFR 0.152.
 */
package de.independit.scheduler.server.util;

import de.independit.scheduler.server.ConnectionEnvironment;
import de.independit.scheduler.server.SystemEnvironment;
import de.independit.scheduler.server.exception.SerializationException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class SDMSThread
extends Thread {
    public SerializationException lastSerializationException = null;
    public static final String __version = "@(#) $Id: SDMSThread.java,v 2.9.2.1 2013/03/14 10:25:29 ronald Exp $";
    public static final int SEVERITY_DEBUG = 3;
    public static final int SEVERITY_MESSAGE = 2;
    public static final int SEVERITY_WARNING = 1;
    public static final int SEVERITY_INFO = 0;
    public static final int SEVERITY_ERROR = -1;
    public static final int SEVERITY_FATAL = -2;
    protected volatile boolean run = true;
    protected volatile boolean isSuspended = false;
    private static final SimpleDateFormat sysDateFmt = (SimpleDateFormat)SystemEnvironment.staticSystemDateFormat.clone();
    public int readLock = 0;
    public SDMSThread lockThread = null;
    public long exceptionsToTrace = 0L;

    public SDMSThread() {
    }

    public SDMSThread(String string) {
        super(string);
    }

    public SDMSThread(Runnable runnable) {
        super(runnable);
    }

    public SDMSThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public void print(PrintStream printStream) {
        printStream.println(this.getName());
    }

    public abstract int id();

    public void do_stop() {
        this.run = false;
        this.interrupt();
    }

    public void SDMSsuspend() {
        this.isSuspended = true;
    }

    public void SDMSresume() {
        this.isSuspended = false;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void setTimeout(int n) {
    }

    public int getTimeout() {
        return 0;
    }

    public static String severityName(int n) {
        switch (n) {
            case 3: {
                return "DEBUG  ";
            }
            case 2: {
                return "MESSAGE";
            }
            case 1: {
                return "WARNING";
            }
            case 0: {
                return "INFO   ";
            }
            case -1: {
                return "ERROR  ";
            }
            case -2: {
                return "FATAL  ";
            }
        }
        return "UNKNOWN";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String getHeader(ConnectionEnvironment connectionEnvironment, int n) {
        Object object;
        String string = Thread.currentThread().getName();
        String string2 = connectionEnvironment != null ? ((object = connectionEnvironment.uid()) != null ? connectionEnvironment.uid() + "," + connectionEnvironment.name() + "(" + string + ")" : connectionEnvironment.name() + "(" + string + ")") : string;
        object = SDMSThread.severityName(n) + " [" + string2 + "]";
        if (string2.length() < 6) {
            object = (String)object + "\t";
        }
        SimpleDateFormat simpleDateFormat = sysDateFmt;
        synchronized (simpleDateFormat) {
            return (String)object + "\t" + sysDateFmt.format(new Date(System.currentTimeMillis())) + " ";
        }
    }

    public static void doTrace(ConnectionEnvironment connectionEnvironment, String string, int n) {
        SDMSThread.doTrace(connectionEnvironment, string, null, n, false);
    }

    public static void doTrace(ConnectionEnvironment connectionEnvironment, String string, Object[] objectArray, int n) {
        SDMSThread.doTrace(connectionEnvironment, string, objectArray, n, false);
    }

    public static void doTrace(ConnectionEnvironment connectionEnvironment, String string, Object[] objectArray, int n, boolean bl) {
        String string2 = SDMSThread.getHeader(connectionEnvironment, n);
        if (n <= SystemEnvironment.getTraceLevel() || connectionEnvironment != null && n <= connectionEnvironment.getTraceLevel()) {
            System.err.println(string2 + string);
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    System.err.println(string2 + objectArray[i].toString());
                }
            }
        }
        if (n <= -1) {
            SDMSThread.printStackTrace(string2);
        }
        if (n == -2 && !bl) {
            System.exit(1);
        }
    }

    public static void printMyStackTrace(String string) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        System.err.println(string + "****************** Start Stacktrace *********************");
        for (int i = 1; i < stackTraceElementArray.length; ++i) {
            System.err.println(string + stackTraceElementArray[i].toString());
        }
        System.err.println(string + "****************** End Stacktrace   *********************");
    }

    private static void printStackTrace(String string) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        System.err.println(string + "****************** Start Stacktrace *********************");
        for (int i = 2; i < stackTraceElementArray.length; ++i) {
            System.err.println(string + stackTraceElementArray[i].toString());
        }
        System.err.println(string + "****************** End Stacktrace   *********************");
    }

    public abstract void SDMSrun();

    @Override
    public void run() {
        if (this.lockThread != null) {
            super.run();
            return;
        }
        try {
            this.SDMSrun();
        }
        catch (Exception exception) {
            try {
                SDMSThread.doTrace(null, exception.toString(), exception.getStackTrace(), -2);
            }
            catch (Error error) {
                try {
                    System.err.println("FATAL\t *****************************************");
                    System.err.println("FATAL\t *                                       *");
                    System.err.println("FATAL\t * SEVERE ERROR, PROBABLY OUT OF MEMORY! *");
                    System.err.println("FATAL\t *                                       *");
                    System.err.println("FATAL\t *****************************************");
                }
                catch (Error error2) {
                    // empty catch block
                }
                Runtime.getRuntime().halt(1);
            }
        }
        catch (Error error) {
            try {
                SDMSThread.doTrace(null, error.toString(), error.getStackTrace(), -2);
            }
            catch (Error error3) {
                try {
                    System.err.println("FATAL\t *****************************************");
                    System.err.println("FATAL\t *                                       *");
                    System.err.println("FATAL\t * SEVERE ERROR, PROBABLY OUT OF MEMORY! *");
                    System.err.println("FATAL\t *                                       *");
                    System.err.println("FATAL\t *****************************************");
                }
                catch (Error error4) {
                    // empty catch block
                }
            }
            Runtime.getRuntime().halt(1);
        }
    }
}

