@ECHO OFF

REM
REM JDBC driver jar to use
REM
SET BICSUITEJDBC=D:\Program Files (x86)\PostgreSQL\pgJDBC\postgresql-8.4-701.jdbc4.jar

REM
REM Bicsuite JAR to use
REM
SET BICSUITEJAR=%BICSUITEHOME%\lib\BICsuite.jar

REM
REM CLASSPATH to use containing the BICsuite JAR and the JDBC driver jar
REM
SET BICSUITECLASSPATH=%BICSUITEJAR%;%BICSUITEJDBC%

REM
REM java executable to use
REM
SET BICSUITEJAVA=java

REM
REM java used for BICsuite Server
REM
SET BICSUITEJAVA_BS=%BICSUITEJAVA%
SET BICSUITEJAVA_BS_SERVICE=%BICSUITEJAVA%

REM
REM java used for BICsuite Jobserver
REM
SET BICSUITEJAVA_JS=%BICSUITEJAVA%
SET BICSUITEJAVA_JS_SERVICE=%BICSUITEJAVA%w

REM
REM java used for BICsuite Tools
REM
SET BICSUITEJAVA_TL=%BICSUITEJAVA%

REM
REM java used for BICsuite Proxy
REM
SET BICSUITEJAVA_PX=%BICSUITEJAVA%

REM
REM Additional Java Flags to use 
REM

REM
REM java flags used for BICsuite Server
REM
SET BICSUITEMEM=320

REM
REM MAXMEM should be BICSUITEMEM
REM
SET MAXMEM=%BICSUITEMEM%m

REM
REM A good initial STARTMEM is BICSUITEMEM / 2
REM
SET /A STARTMEM=%BICSUITEMEM%/2
SET STARTMEM=%STARTMEM%m

REM
REM A good initial NEWSIZE is BICSUITEMEM / 16 
REM
SET /A NEWSIZE=%BICSUITEMEM%/16
SET NEWSIZE=%NEWSIZE%m

SET MEMSIZES=-Xmx%MAXMEM% -Xms%STARTMEM% -XX:NewSize=%NEWSIZE%
SET MEMFLAGS=-XX:+UseConcMarkSweepGC -XX:+CMSParallelRemarkEnabled -XX:CMSInitiatingOccupancyFraction=80 -XX:+DisableExplicitGC -XX:ParallelGCThreads=4
SET MEMDEBUG= 
SET MEMCONF=%MEMSIZES% %MEMFLAGS% %MEMDEBUG%

REM
REM java flags used for BICsuite Server
REM Note:
REM use a blank char after the '=' if no flags should be used
REM Otherwise it would be not defined at all
REM
REM -Dfile.encoding=UTF-8 ensures that the server will interpret commands as UTF-8
REM
SET BICSUITEJAVAFLAGS_BS=-Dfile.encoding=UTF-8 %MEMCONF%

REM
REM java flags used for BICsuite Jobserver
REM Note:
REM use a blank char after the '=' if no flags should be used
REM Otherwise it would be not defined at all
REM
SET BICSUITEJAVAFLAGS_JS=-client -XX:ParallelGCThreads=2

REM
REM java flags used for BICsuite Tools
REM Note:
REM use a blank char after the '=' if no flags should be used
REM Otherwise it would be not defined at all
REM
SET BICSUITEJAVAFLAGS_TL=-client

REM
REM java flags used for BICsuite Proxy
REM Note:
REM use a blank char after the '=' if no flags should be used
REM Otherwise it would be not defined at all
REM
SET BICSUITEJAVAFLAGS_PX= 

SET BICSUITE_BATCH_EXITCODE=0
REM
REM Exit depending on windows version
REM
IF [%WIN_VERSION%]==[WIN_9X] GOTO EXIT_SET_ERRORLEVEL
EXIT /B %BICSUITE_BATCH_EXITCODE% >NUL
:EXIT_SET_ERRORLEVEL
SET ERRORLEVEL=%BICSUITE_BATCH_EXITCODE%

