-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE RESOURCE_VARIABLE (
    ID                             bigint NOT NULL
    , PD_ID                          bigint          NOT NULL
    , R_ID                           bigint          NOT NULL
    , VALUE                          varchar(256)    NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_RESOURCE_VARIABLE
ON RESOURCE_VARIABLE(ID);
CREATE VIEW SCI_RESOURCE_VARIABLE AS
SELECT 
    ID 
    , PD_ID                          AS PD_ID
    , R_ID                           AS R_ID
    , VALUE                          AS VALUE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CREATE_TS, 1125899906842624)/1000) seconds AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , timestamp('1970-01-01-00.00.00') + int(mod(CHANGE_TS, 1125899906842624)/1000) seconds AS CHANGE_TS
  FROM RESOURCE_VARIABLE;
