-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE POOL_DIST_CONFIG (
    ID                             bigint NOT NULL
    , PLD_ID                         bigint          NOT NULL
    , PR_ID                          bigint          NOT NULL
    , IS_MANAGED                     integer             NULL
    , NOM_PCT                        int8                NULL
    , FREE_PCT                       int8                NULL
    , MIN_PCT                        int8                NULL
    , MAX_PCT                        int8                NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_POOL_DIST_CONFIG
ON POOL_DIST_CONFIG(ID);
CREATE VIEW SCI_POOL_DIST_CONFIG (ID,PLD_ID,PR_ID,IS_MANAGED,NOM_PCT,FREE_PCT,MIN_PCT,MAX_PCT,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS) AS
SELECT 
    ID 
    , PLD_ID                         AS PLD_ID
    , PR_ID                          AS PR_ID
    , DECODE (IS_MANAGED, 1, 'TRUE', 0, 'FALSE') AS IS_MANAGED
    , NOM_PCT                        AS NOM_PCT
    , FREE_PCT                       AS FREE_PCT
    , MIN_PCT                        AS MIN_PCT
    , MAX_PCT                        AS MAX_PCT
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
  FROM POOL_DIST_CONFIG;
