-- Copyright (C) 2001,2002 topIT Informationstechnologie GmbH
-- Copyright (C) 2003-2014 independIT Integrative Technologies GmbH

CREATE TABLE SCHEDULE (
    ID                             bigint NOT NULL
    , NAME                           lvarchar(64)    NOT NULL
    , OWNER_ID                       bigint          NOT NULL
    , INT_ID                         bigint              NULL
    , PARENT_ID                      bigint              NULL
    , TIME_ZONE                      lvarchar(32)    NOT NULL
    , SE_ID                          bigint              NULL
    , ACTIVE                         integer         NOT NULL
    , CREATOR_U_ID                   bigint          NOT NULL
    , CREATE_TS                      bigint          NOT NULL
    , CHANGER_U_ID                   bigint          NOT NULL
    , CHANGE_TS                      bigint          NOT NULL
    , INHERIT_PRIVS                  bigint          NOT NULL
);
CREATE UNIQUE INDEX PK_SCHEDULE
ON SCHEDULE(ID);
CREATE VIEW SCI_SCHEDULE (ID,NAME,OWNER_ID,INT_ID,PARENT_ID,TIME_ZONE,SE_ID,ACTIVE,CREATOR_U_ID,CREATE_TS,CHANGER_U_ID,CHANGE_TS,INHERIT_PRIVS) AS
SELECT 
    ID 
    , NAME                           AS NAME
    , OWNER_ID                       AS OWNER_ID
    , INT_ID                         AS INT_ID
    , PARENT_ID                      AS PARENT_ID
    , TIME_ZONE                      AS TIME_ZONE
    , SE_ID                          AS SE_ID
    , DECODE (ACTIVE, 1, 'ACTIVE', 0, 'INACTIVE') AS ACTIVE
    , CREATOR_U_ID                   AS CREATOR_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CREATE_TS, 1125899906842624)/1000)) AS CREATE_TS
    , CHANGER_U_ID                   AS CHANGER_U_ID
    , dbinfo ('utc_to_datetime', round(mod(CHANGE_TS, 1125899906842624)/1000)) AS CHANGE_TS
    , INHERIT_PRIVS                  AS INHERIT_PRIVS
  FROM SCHEDULE;
